/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.beans.range.NumberRange;
import io.github.palexdev.mfxcore.base.properties.range.IntegerRangeProperty;
import io.github.palexdev.mfxcore.utils.fx.ListChangeHelper;
import io.github.palexdev.virtualizedfx.beans.FlowStateProperty;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.flow.FlowState;
import io.github.palexdev.virtualizedfx.flow.OrientationHelper;
import io.github.palexdev.virtualizedfx.flow.VirtualFlow;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.ListChangeListener;

public class FlowManager<T, C extends Cell<T>> {
    private final VirtualFlow<T, C> virtualFlow;
    private final FlowStateProperty<T, C> state = new FlowStateProperty(FlowState.EMPTY);
    private final IntegerRangeProperty lastRange = new IntegerRangeProperty();

    FlowManager(VirtualFlow<T, C> virtualFlow) {
        this.virtualFlow = virtualFlow;
    }

    public void init() {
        if (this.itemsEmpty() || this.virtualFlow.getCellFactory() == null) {
            return;
        }
        OrientationHelper helper = this.virtualFlow.getOrientationHelper();
        int num = helper.maxCells();
        int first = helper.firstVisible();
        int last = Math.min(first + num - 1, this.itemsNum() - 1);
        first = Math.max(last - num + 1, 0);
        IntegerRange range = IntegerRange.of((Integer)first, (Integer)last);
        FlowState<T, C> newState = new FlowState<T, C>(this.virtualFlow, range);
        FlowState<T, C> oldState = this.getState();
        if (oldState == FlowState.EMPTY) {
            for (int i = ((Integer)range.getMin()).intValue(); i <= (Integer)range.getMax(); ++i) {
                T item = this.indexToItem(i);
                C cell = this.itemToCell(item);
                cell.updateIndex(i);
                newState.addCell(i, cell);
            }
            newState.setCellsChanged(true);
            this.setState(newState);
            this.setLastRange(range);
            this.virtualFlow.requestViewportLayout();
            return;
        }
        Map<Integer, C> cells = oldState.getCells();
        for (int i = ((Integer)range.getMin()).intValue(); i <= (Integer)range.getMax(); ++i) {
            if (cells.containsKey(i)) {
                newState.addCell(i, (Cell)cells.remove(i));
                continue;
            }
            T item = this.indexToItem(i);
            C cell = this.itemToCell(item);
            cell.updateIndex(i);
            newState.addCell(i, cell);
        }
        cells.values().forEach(Cell::dispose);
        newState.setCellsChanged(oldState.cellsNum() != newState.cellsNum());
        this.setState(newState);
        this.setLastRange(range);
        this.virtualFlow.requestViewportLayout();
    }

    public void onScroll() {
        IntegerRange lRange;
        FlowState<T, C> state = this.getState();
        if (state == FlowState.EMPTY || this.itemsEmpty()) {
            return;
        }
        OrientationHelper helper = this.virtualFlow.getOrientationHelper();
        int num = helper.maxCells();
        int sFirst = helper.firstVisible();
        int sLast = helper.lastVisible();
        int sTrueFirst = Math.max(sLast - num + 1, 0);
        IntegerRange sRange = IntegerRange.of((Integer)sTrueFirst, (Integer)sLast);
        if (!sRange.equals((Object)state.getRange())) {
            this.setState(state.transition(sRange));
        }
        if (!(lRange = IntegerRange.of((Integer)sFirst, (Integer)sLast)).equals(this.getLastRange())) {
            this.virtualFlow.requestViewportLayout();
        }
        this.setLastRange(lRange);
    }

    public void onListChange(ListChangeListener.Change<? extends T> c) {
        if (this.itemsEmpty()) {
            this.clear();
            return;
        }
        if (this.getState() == FlowState.EMPTY) {
            this.init();
            return;
        }
        List changes = ListChangeHelper.instance().processChange(c);
        this.setState(this.getState().transition(changes));
        this.virtualFlow.requestViewportLayout();
        this.setLastRange(this.getState().getRange());
    }

    public void clear() {
        this.getState().clear();
        this.setState(FlowState.EMPTY);
        this.setLastRange(IntegerRange.of((Integer)-1));
        OrientationHelper helper = this.virtualFlow.getOrientationHelper();
        helper.computeEstimatedLength();
        this.virtualFlow.requestViewportLayout();
    }

    public void reset() {
        this.clear();
        this.init();
    }

    protected T indexToItem(int index) {
        return (T)this.virtualFlow.getItems().get(index);
    }

    protected C itemToCell(T item) {
        return (C)((Cell)this.virtualFlow.getCellFactory().apply(item));
    }

    public final int itemsNum() {
        return this.virtualFlow.getItems().size();
    }

    public final boolean itemsEmpty() {
        return this.virtualFlow.getItems().isEmpty();
    }

    protected VirtualFlow<T, C> getVirtualFlow() {
        return this.virtualFlow;
    }

    public FlowState<T, C> getState() {
        return (FlowState)this.state.get();
    }

    public ReadOnlyObjectProperty<FlowState<T, C>> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    protected void setState(FlowState<T, C> state) {
        this.state.set(state);
    }

    public NumberRange<Integer> getLastRange() {
        return (NumberRange)this.lastRange.get();
    }

    public ReadOnlyObjectProperty<NumberRange<Integer>> lastRangeProperty() {
        return this.lastRange.getReadOnlyProperty();
    }

    protected void setLastRange(IntegerRange lastRange) {
        this.lastRange.set((NumberRange)lastRange);
    }
}

