/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow;

import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.flow.FlowState;
import io.github.palexdev.virtualizedfx.flow.VirtualFlow;

public interface FlowMapping<T, C extends Cell<T>> {
    public void manage(FlowState<T, C> var1, FlowState<T, C> var2);

    public int getOldIndex();

    public int getNewIndex();

    public static class FullMapping<T, C extends Cell<T>>
    extends AbstractMapping<T, C> {
        public FullMapping(int oldIndex, int newIndex) {
            super(oldIndex, newIndex);
        }

        @Override
        public void manage(FlowState<T, C> oldState, FlowState<T, C> newState) {
            VirtualFlow<T, C> virtualFlow = newState.getVirtualFlow();
            Object item = virtualFlow.getItems().get(this.newIndex);
            Cell cell = (Cell)oldState.getCells().remove(this.oldIndex);
            if (cell != null) {
                cell.updateItem(item);
            } else {
                cell = (Cell)virtualFlow.getCellFactory().apply(item);
            }
            cell.updateIndex(this.newIndex);
            newState.addCell(this.newIndex, cell);
        }
    }

    public static class PartialMapping<T, C extends Cell<T>>
    extends AbstractMapping<T, C> {
        public PartialMapping(int oldIndex, int newIndex) {
            super(oldIndex, newIndex);
        }

        @Override
        public void manage(FlowState<T, C> oldState, FlowState<T, C> newState) {
            Cell cell = (Cell)oldState.getCells().remove(this.oldIndex);
            cell.updateIndex(this.newIndex);
            newState.addCell(this.newIndex, cell);
        }
    }

    public static class ValidMapping<T, C extends Cell<T>>
    extends AbstractMapping<T, C> {
        public ValidMapping(int oldIndex, int newIndex) {
            super(oldIndex, newIndex);
        }

        @Override
        public void manage(FlowState<T, C> oldState, FlowState<T, C> newState) {
            newState.addCell(this.newIndex, (Cell)oldState.getCells().remove(this.newIndex));
        }
    }

    public static abstract class AbstractMapping<T, C extends Cell<T>>
    implements FlowMapping<T, C> {
        protected final int oldIndex;
        protected final int newIndex;

        public AbstractMapping(int oldIndex, int newIndex) {
            this.oldIndex = oldIndex;
            this.newIndex = newIndex;
        }

        @Override
        public int getOldIndex() {
            return this.oldIndex;
        }

        @Override
        public int getNewIndex() {
            return this.newIndex;
        }
    }
}

