/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.utils.fx.ListChangeHelper;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.enums.UpdateType;
import io.github.palexdev.virtualizedfx.flow.FlowMapping;
import io.github.palexdev.virtualizedfx.flow.OrientationHelper;
import io.github.palexdev.virtualizedfx.flow.VirtualFlow;
import io.github.palexdev.virtualizedfx.flow.paginated.PaginatedVirtualFlow;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class FlowState<T, C extends Cell<T>> {
    public static final FlowState EMPTY = new FlowState();
    private final VirtualFlow<T, C> virtualFlow;
    private final IntegerRange range;
    private final Map<Integer, C> cells = new TreeMap<Integer, C>();
    private final Set<Double> positions = new TreeSet<Double>();
    private final int targetSize;
    private UpdateType type = UpdateType.INIT;
    private boolean cellsChanged = false;
    private boolean hidden = false;

    private FlowState() {
        this.virtualFlow = null;
        this.range = IntegerRange.of((Integer)-1);
        this.targetSize = -1;
    }

    public FlowState(VirtualFlow<T, C> virtualFlow, IntegerRange range) {
        this.virtualFlow = virtualFlow;
        this.range = range;
        this.targetSize = virtualFlow.getOrientationHelper().maxCells();
    }

    public FlowState<T, C> transition(IntegerRange newRange) {
        if (this.range.equals((Object)newRange)) {
            return this;
        }
        this.type = UpdateType.SCROLL;
        FlowState<T, Cell> newState = new FlowState<T, Cell>(this.virtualFlow, newRange);
        ArrayDeque<Integer> toUpdate = new ArrayDeque<Integer>();
        for (int i = ((Integer)newRange.getMin()).intValue(); i <= (Integer)newRange.getMax(); ++i) {
            Cell common = (Cell)this.cells.remove(i);
            if (common != null) {
                newState.addCell(i, common);
                continue;
            }
            toUpdate.add(i);
        }
        Iterator<Map.Entry<Integer, C>> it = this.cells.entrySet().iterator();
        while (!toUpdate.isEmpty() && it.hasNext()) {
            Map.Entry<Integer, C> next = it.next();
            Cell cell = (Cell)next.getValue();
            int cIndex = (Integer)toUpdate.removeFirst();
            Object item = this.virtualFlow.getItems().get(cIndex);
            cell.updateIndex(cIndex);
            cell.updateItem(item);
            newState.addCell(cIndex, cell);
            it.remove();
        }
        if (!this.cells.isEmpty()) {
            this.clear();
            newState.setCellsChanged(true);
        }
        return newState;
    }

    public FlowState<T, C> transition(List<ListChangeHelper.Change> changes) {
        FlowState<T, C> newState = this;
        for (ListChangeHelper.Change change : changes) {
            newState = newState.transition(change);
        }
        newState.positions.addAll(this.positions);
        newState.type = UpdateType.CHANGE;
        return newState;
    }

    protected FlowState<T, C> transition(ListChangeHelper.Change change) {
        switch (change.getType()) {
            case PERMUTATION: {
                FlowState<T, C> newState = new FlowState<T, C>(this.virtualFlow, this.range);
                this.cells.forEach((index, cell) -> {
                    Object item = this.virtualFlow.getItems().get(index.intValue());
                    cell.updateItem(item);
                });
                newState.addCells(this.cells);
                this.cells.clear();
                return newState;
            }
            case REPLACE: {
                OrientationHelper helper = this.virtualFlow.getOrientationHelper();
                int cellsNum = this.cellsNum();
                int last = helper.lastVisible();
                int first = last - cellsNum + 1;
                if (change.getFrom() > last) {
                    return this;
                }
                IntegerRange newRange = IntegerRange.of((Integer)first, (Integer)last);
                FlowState<T, Cell> newState = new FlowState<T, Cell>(this.virtualFlow, newRange);
                ArrayDeque<Integer> available = new ArrayDeque<Integer>(this.cells.keySet());
                for (int i = first; i <= last; ++i) {
                    Cell cell2;
                    if (!change.hasChanged(i)) {
                        newState.addCell(i, (Cell)this.cells.remove(i));
                        available.remove(i);
                        continue;
                    }
                    Integer index2 = (Integer)available.poll();
                    Object item = this.virtualFlow.getItems().get(i);
                    if (index2 != null) {
                        cell2 = (Cell)this.cells.remove(index2);
                        cell2.updateItem(item);
                    } else {
                        cell2 = (Cell)this.virtualFlow.getCellFactory().apply(item);
                    }
                    cell2.updateIndex(i);
                    newState.addCell(i, cell2);
                }
                if (!this.isEmpty()) {
                    Iterator<Map.Entry<Integer, C>> it = this.cells.entrySet().iterator();
                    while (it.hasNext()) {
                        Cell cell3 = (Cell)it.next().getValue();
                        cell3.dispose();
                        it.remove();
                    }
                    this.positions.clear();
                }
                newState.setCellsChanged(newState.cellsNum() != cellsNum);
                return newState;
            }
            case ADD: {
                boolean viewportFull = this.isViewportFull();
                if (viewportFull && change.getFrom() > (Integer)this.range.getMax()) {
                    return this;
                }
                int first = this.getFirst();
                int last = this.getLast();
                int cellsNum = this.cellsNum();
                IntegerRange newRange = IntegerRange.of((Integer)first, (Integer)last);
                FlowState<T, C> newState = new FlowState<T, C>(this.virtualFlow, newRange);
                Set available = IntegerRange.expandRangeToSet((IntegerRange)newRange);
                HashMap<Integer, FlowMapping.AbstractMapping> mappings = new HashMap<Integer, FlowMapping.AbstractMapping>();
                for (int i = first; i < change.getFrom(); ++i) {
                    mappings.put(i, new FlowMapping.ValidMapping(i, i));
                    available.remove(i);
                }
                int from = Math.max(change.getFrom(), first);
                int targetSize = this.computeTargetSize(newState.targetSize);
                int lastInvalid = -1;
                Deque<Integer> keys = this.getKeysDeque();
                while (!available.isEmpty() || mappings.size() != targetSize) {
                    int newIndex;
                    Integer index3 = keys.poll();
                    if (mappings.containsKey(index3)) continue;
                    if (index3 != null && IntegerRange.inRangeOf((int)(newIndex = index3 + change.size()), (IntegerRange)newRange) && !change.hasChanged(newIndex) && available.contains(newIndex)) {
                        mappings.put(index3, new FlowMapping.PartialMapping(index3, newIndex));
                        available.remove(newIndex);
                        continue;
                    }
                    int fIndex = index3 == null ? lastInvalid-- : index3;
                    mappings.put(fIndex, new FlowMapping.FullMapping(fIndex, from));
                    available.remove(from);
                    ++from;
                }
                mappings.values().forEach(m -> m.manage(this, newState));
                if (this.virtualFlow instanceof PaginatedVirtualFlow) {
                    newState.addCells(this.cells);
                    this.cells.clear();
                } else if (!this.range.equals((Object)newRange)) {
                    this.positions.clear();
                }
                newState.setCellsChanged(newState.cellsNum() != cellsNum);
                return newState;
            }
            case REMOVE: {
                if (change.getFrom() > (Integer)this.range.getMax()) break;
                int max = Math.min((Integer)this.range.getMin() + this.targetSize - 1, this.virtualFlow.getItems().size() - 1);
                int min = Math.max(0, max - this.targetSize + 1);
                IntegerRange newRange = IntegerRange.of((Integer)min, (Integer)max);
                FlowState<T, Cell> newState = new FlowState<T, Cell>(this.virtualFlow, newRange);
                Set pUpdate = IntegerRange.expandRangeToSet((IntegerRange)this.range);
                pUpdate.removeAll(change.getIndexes());
                List<Integer> changeIndexes = change.getIndexes().stream().sorted().collect(Collectors.toList());
                for (Integer index4 : pUpdate) {
                    int newIndex = index4 - this.findShift(changeIndexes, index4);
                    if (newIndex < (Integer)this.range.getMin()) continue;
                    Cell cell4 = (Cell)this.cells.remove(index4);
                    cell4.updateIndex(newIndex);
                    newState.addCell(newIndex, cell4);
                }
                Set fUpdate = IntegerRange.expandRangeToSet((IntegerRange)newRange);
                fUpdate.removeAll(newState.cells.keySet());
                ArrayDeque<Integer> available = new ArrayDeque<Integer>(this.cells.keySet());
                for (Integer index5 : fUpdate) {
                    Object item = this.virtualFlow.getItems().get(index5.intValue());
                    int cellIndex = (Integer)available.removeFirst();
                    Cell cell5 = (Cell)this.cells.remove(cellIndex);
                    cell5.updateIndex(index5);
                    cell5.updateItem(item);
                    newState.addCell(index5, cell5);
                }
                if (!this.isEmpty()) {
                    Iterator<Map.Entry<Integer, C>> it = this.cells.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Integer, C> next = it.next();
                        Cell cell6 = (Cell)next.getValue();
                        cell6.dispose();
                        it.remove();
                    }
                    newState.setCellsChanged(true);
                    this.positions.clear();
                }
                return newState;
            }
        }
        return this;
    }

    public Set<Double> computePositions() {
        boolean adjust;
        if (this.isEmpty()) {
            return Set.of();
        }
        if (this.virtualFlow instanceof PaginatedVirtualFlow) {
            return this.computePaginatedPositions();
        }
        OrientationHelper helper = this.virtualFlow.getOrientationHelper();
        double cellSize = this.virtualFlow.getCellSize();
        int first = helper.firstVisible();
        int last = first + helper.maxCells() - 1;
        boolean bl = adjust = last > this.virtualFlow.getItems().size() - 1 && this.isViewportFull();
        if (!adjust && this.type == UpdateType.CHANGE && this.positions.size() >= this.targetSize) {
            return this.positions;
        }
        this.positions.clear();
        double bottom = (double)(this.cells.size() - 1) * cellSize;
        if (adjust) {
            bottom -= cellSize;
        }
        for (int i = ((Integer)this.range.getMax()).intValue(); i >= (Integer)this.range.getMin(); --i) {
            this.positions.add(bottom);
            bottom -= cellSize;
        }
        return this.positions;
    }

    public Set<Double> computePaginatedPositions() {
        this.positions.clear();
        PaginatedVirtualFlow pFlow = (PaginatedVirtualFlow)this.virtualFlow;
        OrientationHelper helper = pFlow.getOrientationHelper();
        double cellSize = this.virtualFlow.getCellSize();
        int first = helper.firstVisible();
        int last = Math.min(first + helper.maxCells() - 1, pFlow.getItems().size() - 1);
        IntegerRange range = new IntegerRange(Integer.valueOf(first), Integer.valueOf(last));
        for (int i = first; i <= last; ++i) {
            Cell cell = (Cell)this.cells.get(i);
            double pos = (double)this.positions.size() * cellSize;
            this.positions.add(pos);
            cell.getNode().setVisible(true);
        }
        this.cells.entrySet().stream().filter(e -> !IntegerRange.inRangeOf((int)((Integer)e.getKey()), (IntegerRange)range)).peek(e -> {
            this.hidden = true;
        }).forEach(e -> ((Cell)e.getValue()).getNode().setVisible(false));
        return this.positions;
    }

    protected int findShift(List<Integer> indexes, int index) {
        int shift = Collections.binarySearch(indexes, index);
        return shift > -1 ? shift : -(shift + 1);
    }

    protected void addCell(int index, C cell) {
        this.cells.put(index, cell);
    }

    protected void addCells(Map<Integer, C> cells) {
        this.cells.putAll(cells);
    }

    protected C removeLast() {
        int last = this.getLastAvailable();
        return (C)((Cell)this.cells.remove(last));
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public int cellsNum() {
        return this.cells.size();
    }

    public boolean isViewportFull() {
        int cellsNum = this.cellsNum();
        if (this.virtualFlow instanceof PaginatedVirtualFlow) {
            cellsNum = (int)this.cells.values().stream().filter(c -> c.getNode().isVisible()).count();
        }
        return cellsNum >= this.targetSize;
    }

    public int getFirst() {
        return this.virtualFlow.getOrientationHelper().firstVisible();
    }

    public int getLast() {
        return this.virtualFlow.getOrientationHelper().lastVisible();
    }

    public int getLastAvailable() {
        return this.cells.keySet().stream().max(Integer::compareTo).orElse((Integer)this.range.getMax());
    }

    protected Deque<Integer> getKeysDeque() {
        if (this.virtualFlow instanceof PaginatedVirtualFlow && this.hidden) {
            ArrayDeque<Integer> deque = new ArrayDeque<Integer>();
            LinkedHashSet<Integer> keys = new LinkedHashSet<Integer>(this.cells.keySet());
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                Integer index = (Integer)it.next();
                Cell cell = (Cell)this.cells.get(index);
                if (!cell.getNode().isVisible()) continue;
                deque.add(index);
                it.remove();
            }
            deque.addAll(keys);
            return deque;
        }
        return new ArrayDeque<Integer>(this.cells.keySet());
    }

    protected int computeTargetSize(int expectedSize) {
        PaginatedVirtualFlow pFlow;
        if (this.virtualFlow instanceof PaginatedVirtualFlow && (pFlow = (PaginatedVirtualFlow)this.virtualFlow).getCurrentPage() == pFlow.getMaxPage()) {
            int remainder = pFlow.getItems().size() % pFlow.getCellsPerPage();
            return remainder != 0 ? remainder : expectedSize;
        }
        return Math.min(this.virtualFlow.getItems().size(), expectedSize);
    }

    protected void clear() {
        this.cells.values().forEach(Cell::dispose);
        this.cells.clear();
    }

    public VirtualFlow<T, C> getVirtualFlow() {
        return this.virtualFlow;
    }

    public IntegerRange getRange() {
        return this.range;
    }

    protected Map<Integer, C> getCells() {
        return this.cells;
    }

    public Map<Integer, C> getCellsUnmodifiable() {
        return Collections.unmodifiableMap(this.cells);
    }

    public List<Node> getNodes() {
        return this.cells.values().stream().map(Cell::getNode).collect(Collectors.toList());
    }

    protected Set<Double> getPositions() {
        return this.positions;
    }

    public Set<Double> getPositionsUnmodifiable() {
        return Collections.unmodifiableSet(this.positions);
    }

    public int getTargetSize() {
        return this.targetSize;
    }

    public UpdateType getType() {
        return this.type;
    }

    public boolean haveCellsChanged() {
        return this.cellsChanged;
    }

    protected void setCellsChanged(boolean cellsChanged) {
        this.cellsChanged = cellsChanged;
    }

    public boolean anyHidden() {
        return this.hidden;
    }
}

