/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow;

import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.LayoutUtils;
import io.github.palexdev.virtualizedfx.flow.FlowManager;
import io.github.palexdev.virtualizedfx.flow.VirtualFlow;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public interface OrientationHelper {
    public int firstVisible();

    public int lastVisible();

    public int maxCells();

    public double maxVScroll();

    public double maxHScroll();

    public double computeEstimatedLength();

    public ReadOnlyDoubleProperty estimatedLengthProperty();

    public double computeBreadth(Node var1);

    public ReadOnlyDoubleProperty maxBreadthProperty();

    public DoubleBinding xPosBinding();

    public DoubleBinding yPosBinding();

    public void invalidatePos();

    public void scrollBy(double var1);

    public void scrollToPixel(double var1);

    public void scrollToIndex(int var1);

    public void layout(Node var1, double var2, double var4);

    public void dispose();

    public static class VerticalHelper
    extends AbstractOrientationHelper {
        private ChangeListener<? super Number> heightListener = (observable, oldValue, newValue) -> {
            if (newValue.doubleValue() > 0.0) {
                this.manager.init();
            }
        };
        private InvalidationListener widthListener = invalidated -> virtualFlow.requestViewportLayout();
        private InvalidationListener vPosListener = invalidated -> this.manager.onScroll();
        private DoubleBinding xPosBinding;
        private DoubleBinding yPosBinding;

        public VerticalHelper(VirtualFlow<?, ?> virtualFlow) {
            super(virtualFlow);
            virtualFlow.heightProperty().addListener(this.heightListener);
            virtualFlow.widthProperty().addListener(this.widthListener);
            virtualFlow.vPosProperty().addListener(this.vPosListener);
            ((DoubleProperty)virtualFlow.estimatedLengthProperty()).bind((ObservableValue)this.estimatedLengthProperty());
            ((DoubleProperty)virtualFlow.maxBreadthProperty()).bind((ObservableValue)this.maxBreadthProperty());
        }

        @Override
        public int firstVisible() {
            return NumberUtils.clamp((int)((int)Math.floor(this.virtualFlow.getVPos() / this.virtualFlow.getCellSize())), (int)0, (int)(this.virtualFlow.getItems().size() - 1));
        }

        @Override
        public int lastVisible() {
            return NumberUtils.clamp((int)(this.firstVisible() + this.maxCells() - 1), (int)0, (int)(this.virtualFlow.getItems().size() - 1));
        }

        @Override
        public int maxCells() {
            return (int)(Math.ceil(this.virtualFlow.getHeight() / this.virtualFlow.getCellSize()) + 1.0);
        }

        @Override
        public double maxVScroll() {
            return this.estimatedLengthProperty().get() - this.virtualFlow.getHeight();
        }

        @Override
        public double maxHScroll() {
            return this.maxBreadthProperty().get() - this.virtualFlow.getWidth();
        }

        @Override
        public double computeEstimatedLength() {
            double val = (double)this.virtualFlow.getItems().size() * this.virtualFlow.getCellSize();
            this.estimatedLength.set(val);
            return val;
        }

        @Override
        public double computeBreadth(Node node) {
            boolean fitToBreadth = this.virtualFlow.isFitToBreadth();
            return fitToBreadth ? this.virtualFlow.getWidth() : LayoutUtils.boundWidth((Node)node);
        }

        @Override
        public DoubleBinding xPosBinding() {
            if (this.xPosBinding == null) {
                this.xPosBinding = Bindings.createDoubleBinding(() -> -NumberUtils.clamp((double)this.virtualFlow.getHPos(), (double)0.0, (double)(this.maxBreadth.get() - this.virtualFlow.getWidth())), (Observable[])new Observable[]{this.virtualFlow.hPosProperty(), this.virtualFlow.widthProperty(), this.maxBreadth});
            }
            return this.xPosBinding;
        }

        @Override
        public DoubleBinding yPosBinding() {
            if (this.yPosBinding == null) {
                this.yPosBinding = Bindings.createDoubleBinding(() -> -this.virtualFlow.getVPos() % this.virtualFlow.getCellSize(), (Observable[])new Observable[]{this.virtualFlow.vPosProperty(), this.virtualFlow.cellSizeProperty()});
            }
            return this.yPosBinding;
        }

        @Override
        public void invalidatePos() {
            double length = this.estimatedLength.get();
            double breadth = this.maxBreadth.get();
            this.virtualFlow.setVPos(Math.min(this.virtualFlow.getVPos(), length));
            this.virtualFlow.setHPos(Math.min(this.virtualFlow.getHPos(), breadth));
        }

        @Override
        public void scrollBy(double pixels) {
            double newVal = NumberUtils.clamp((double)(this.virtualFlow.getVPos() + pixels), (double)0.0, (double)this.maxVScroll());
            this.virtualFlow.setVPos(newVal);
        }

        @Override
        public void scrollToPixel(double pixel) {
            double clampedVal = NumberUtils.clamp((double)pixel, (double)0.0, (double)this.maxVScroll());
            this.virtualFlow.setVPos(clampedVal);
        }

        @Override
        public void scrollToIndex(int index) {
            double val = (double)index * this.virtualFlow.getCellSize();
            double clampedVal = NumberUtils.clamp((double)val, (double)0.0, (double)this.maxVScroll());
            this.virtualFlow.setVPos(clampedVal);
        }

        @Override
        public void layout(Node node, double pos, double breadth) {
            double size = this.virtualFlow.getCellSize();
            node.resizeRelocate(0.0, pos, breadth, size);
        }

        @Override
        public void dispose() {
            this.virtualFlow.heightProperty().removeListener(this.heightListener);
            this.virtualFlow.widthProperty().removeListener(this.widthListener);
            this.virtualFlow.vPosProperty().removeListener(this.vPosListener);
            this.heightListener = null;
            this.widthListener = null;
            this.vPosListener = null;
            if (this.xPosBinding != null) {
                this.xPosBinding.dispose();
            }
            if (this.yPosBinding != null) {
                this.yPosBinding.dispose();
            }
            this.xPosBinding = null;
            this.yPosBinding = null;
        }
    }

    public static class HorizontalHelper
    extends AbstractOrientationHelper {
        private ChangeListener<? super Number> widthListener = (observable, oldValue, newValue) -> {
            if (newValue.doubleValue() > 0.0) {
                this.manager.init();
            }
        };
        private InvalidationListener heightListener = invalidated -> virtualFlow.requestViewportLayout();
        private InvalidationListener hPosListener = invalidated -> this.manager.onScroll();
        private DoubleBinding xPosBinding;
        private DoubleBinding yPosBinding;

        public HorizontalHelper(VirtualFlow<?, ?> virtualFlow) {
            super(virtualFlow);
            virtualFlow.widthProperty().addListener(this.widthListener);
            virtualFlow.heightProperty().addListener(this.heightListener);
            virtualFlow.hPosProperty().addListener(this.hPosListener);
            ((DoubleProperty)virtualFlow.estimatedLengthProperty()).bind((ObservableValue)this.estimatedLengthProperty());
            ((DoubleProperty)virtualFlow.maxBreadthProperty()).bind((ObservableValue)this.maxBreadthProperty());
        }

        @Override
        public int firstVisible() {
            return NumberUtils.clamp((int)((int)Math.floor(this.virtualFlow.getHPos() / this.virtualFlow.getCellSize())), (int)0, (int)(this.virtualFlow.getItems().size() - 1));
        }

        @Override
        public int lastVisible() {
            return NumberUtils.clamp((int)(this.firstVisible() + this.maxCells() - 1), (int)0, (int)(this.virtualFlow.getItems().size() - 1));
        }

        @Override
        public int maxCells() {
            return (int)(Math.ceil(this.virtualFlow.getWidth() / this.virtualFlow.getCellSize()) + 1.0);
        }

        @Override
        public double maxVScroll() {
            return this.maxBreadthProperty().get() - this.virtualFlow.getHeight();
        }

        @Override
        public double maxHScroll() {
            return this.estimatedLengthProperty().get() - this.virtualFlow.getWidth();
        }

        @Override
        public double computeEstimatedLength() {
            double val = (double)this.virtualFlow.getItems().size() * this.virtualFlow.getCellSize();
            this.estimatedLength.set(val);
            return val;
        }

        @Override
        public double computeBreadth(Node node) {
            boolean fitToBreadth = this.virtualFlow.isFitToBreadth();
            return fitToBreadth ? this.virtualFlow.getHeight() : LayoutUtils.boundHeight((Node)node);
        }

        @Override
        public DoubleBinding xPosBinding() {
            if (this.xPosBinding == null) {
                this.xPosBinding = Bindings.createDoubleBinding(() -> -this.virtualFlow.getHPos() % this.virtualFlow.getCellSize(), (Observable[])new Observable[]{this.virtualFlow.hPosProperty(), this.virtualFlow.cellSizeProperty()});
            }
            return this.xPosBinding;
        }

        @Override
        public DoubleBinding yPosBinding() {
            if (this.yPosBinding == null) {
                this.yPosBinding = Bindings.createDoubleBinding(() -> -NumberUtils.clamp((double)this.virtualFlow.getVPos(), (double)0.0, (double)(this.maxBreadth.get() - this.virtualFlow.getHeight())), (Observable[])new Observable[]{this.virtualFlow.vPosProperty(), this.virtualFlow.heightProperty(), this.maxBreadth});
            }
            return this.yPosBinding;
        }

        @Override
        public void invalidatePos() {
            double length = this.estimatedLength.get();
            double breadth = this.maxBreadth.get();
            this.virtualFlow.setVPos(Math.min(this.virtualFlow.getVPos(), breadth));
            this.virtualFlow.setHPos(Math.min(this.virtualFlow.getHPos(), length));
        }

        @Override
        public void scrollBy(double pixels) {
            double newVal = NumberUtils.clamp((double)(this.virtualFlow.getHPos() + pixels), (double)0.0, (double)this.maxHScroll());
            this.virtualFlow.setHPos(newVal);
        }

        @Override
        public void scrollToPixel(double pixel) {
            double clampedVal = NumberUtils.clamp((double)pixel, (double)0.0, (double)this.maxHScroll());
            this.virtualFlow.setHPos(clampedVal);
        }

        @Override
        public void scrollToIndex(int index) {
            double val = (double)index * this.virtualFlow.getCellSize();
            double clampedVal = NumberUtils.clamp((double)val, (double)0.0, (double)this.maxHScroll());
            this.virtualFlow.setHPos(clampedVal);
        }

        @Override
        public void layout(Node node, double pos, double breadth) {
            double size = this.virtualFlow.getCellSize();
            node.resizeRelocate(pos, 0.0, size, breadth);
        }

        @Override
        public void dispose() {
            this.virtualFlow.widthProperty().removeListener(this.widthListener);
            this.virtualFlow.heightProperty().removeListener(this.heightListener);
            this.virtualFlow.hPosProperty().removeListener(this.hPosListener);
            this.widthListener = null;
            this.heightListener = null;
            this.hPosListener = null;
            if (this.xPosBinding != null) {
                this.xPosBinding.dispose();
            }
            if (this.yPosBinding != null) {
                this.yPosBinding.dispose();
            }
            this.xPosBinding = null;
            this.yPosBinding = null;
        }
    }

    public static abstract class AbstractOrientationHelper
    implements OrientationHelper {
        protected final VirtualFlow<?, ?> virtualFlow;
        protected final FlowManager<?, ?> manager;
        protected final DoubleProperty estimatedLength = new SimpleDoubleProperty();
        protected final DoubleProperty maxBreadth = new SimpleDoubleProperty();

        public AbstractOrientationHelper(VirtualFlow<?, ?> virtualFlow) {
            this.virtualFlow = virtualFlow;
            this.manager = virtualFlow.getViewportManager();
        }

        @Override
        public ReadOnlyDoubleProperty estimatedLengthProperty() {
            return this.estimatedLength;
        }

        @Override
        public ReadOnlyDoubleProperty maxBreadthProperty() {
            return this.maxBreadth;
        }
    }
}

