/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow;

import io.github.palexdev.mfxcore.base.beans.range.NumberRange;
import io.github.palexdev.mfxcore.base.properties.functional.FunctionProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.mfxcore.utils.fx.PropUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.controls.VirtualScrollPane;
import io.github.palexdev.virtualizedfx.flow.FlowManager;
import io.github.palexdev.virtualizedfx.flow.FlowState;
import io.github.palexdev.virtualizedfx.flow.OrientationHelper;
import io.github.palexdev.virtualizedfx.flow.VirtualFlowSkin;
import io.github.palexdev.virtualizedfx.utils.VSPUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class VirtualFlow<T, C extends Cell<T>>
extends Control
implements VirtualScrollPane.Wrappable {
    private final String STYLE_CLASS = "virtual-flow";
    private final FlowManager<T, C> manager = new FlowManager(this);
    private final ObjectProperty<ObservableList<T>> items = new SimpleObjectProperty<ObservableList<T>>(FXCollections.observableArrayList()){

        public void set(ObservableList<T> newValue) {
            ObservableList val = newValue != null ? newValue : FXCollections.observableArrayList();
            super.set((Object)val);
        }
    };
    private final FunctionProperty<T, C> cellFactory = new FunctionProperty();
    private final DoubleProperty vPos = PropUtils.clampedDoubleProperty(() -> 0.0, () -> this.getOrientationHelper() != null ? this.getOrientationHelper().maxVScroll() : 0.0);
    private final DoubleProperty hPos = PropUtils.clampedDoubleProperty(() -> 0.0, () -> this.getOrientationHelper() != null ? this.getOrientationHelper().maxHScroll() : 0.0);
    private final ReadOnlyObjectWrapper<OrientationHelper> orientationHelper = new ReadOnlyObjectWrapper<OrientationHelper>(){

        public void set(OrientationHelper newValue) {
            OrientationHelper oldValue = (OrientationHelper)this.get();
            if (oldValue != null) {
                oldValue.dispose();
            }
            super.set((Object)newValue);
        }
    };
    private final FunctionProperty<Orientation, OrientationHelper> orientationHelperFactory = new FunctionProperty<Orientation, OrientationHelper>(o -> o == Orientation.VERTICAL ? new OrientationHelper.VerticalHelper(this) : new OrientationHelper.HorizontalHelper(this)){

        protected void invalidated() {
            Orientation orientation = VirtualFlow.this.getOrientation();
            OrientationHelper helper = (OrientationHelper)((Function)this.get()).apply(orientation);
            VirtualFlow.this.setOrientationHelper(helper);
        }
    };
    private final DoubleProperty estimatedLength = new SimpleDoubleProperty();
    private final DoubleProperty maxBreadth = new SimpleDoubleProperty();
    private final ReadOnlyBooleanWrapper needsViewportLayout = new ReadOnlyBooleanWrapper(false);
    private final StyleableBooleanProperty fitToBreadth = new StyleableBooleanProperty(StyleableProperties.FIT_TO_BREADTH, this, "fitToBreadth", true){

        protected void invalidated() {
            OrientationHelper helper = VirtualFlow.this.getOrientationHelper();
            if (helper != null) {
                helper.invalidatePos();
                VirtualFlow.this.requestViewportLayout();
            }
        }
    };
    private final StyleableDoubleProperty cellSize = new StyleableDoubleProperty(StyleableProperties.CELL_SIZE, this, "cellSize", 32.0){

        protected void invalidated() {
            VirtualFlow.this.cellSizeChanged();
        }
    };
    private final StyleableObjectProperty<Orientation> orientation = new StyleableObjectProperty<Orientation>(StyleableProperties.ORIENTATION, (Object)this, "orientation"){

        protected void invalidated() {
            Orientation orientation = (Orientation)this.get();
            OrientationHelper helper = VirtualFlow.this.getOrientationHelperFactory().apply(orientation);
            VirtualFlow.this.setOrientationHelper(helper);
            VirtualFlow.this.manager.reset();
        }
    };
    private final StyleableDoubleProperty clipBorderRadius = new StyleableDoubleProperty(StyleableProperties.CLIP_BORDER_RADIUS, (Object)this, "clipBorderRadius", Double.valueOf(0.0));

    public VirtualFlow() {
        this.setOrientation(Orientation.VERTICAL);
        this.initialize();
    }

    public VirtualFlow(ObservableList<T> items, Function<T, C> cellFactory) {
        this.setItems(items);
        this.setCellFactory(cellFactory);
        this.setOrientation(Orientation.VERTICAL);
        this.initialize();
    }

    public VirtualFlow(ObservableList<T> items, Function<T, C> cellFactory, Orientation orientation) {
        this.setItems(items);
        this.setCellFactory(cellFactory);
        this.setOrientation(orientation);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"virtual-flow");
    }

    public void requestViewportLayout() {
        this.needsViewportLayout.set(true);
    }

    protected void cellSizeChanged() {
        OrientationHelper helper = this.getOrientationHelper();
        helper.computeEstimatedLength();
        if (this.getWidth() != 0.0 && this.getHeight() != 0.0) {
            this.manager.init();
            this.scrollToPixel(0.0);
        }
    }

    public void scrollBy(double pixels) {
        OrientationHelper helper = this.getOrientationHelper();
        if (helper != null) {
            helper.scrollBy(pixels);
        }
    }

    public void scrollToPixel(double pixel) {
        OrientationHelper helper = this.getOrientationHelper();
        if (helper != null) {
            helper.scrollToPixel(pixel);
        }
    }

    public void scrollToIndex(int index) {
        OrientationHelper helper = this.getOrientationHelper();
        if (helper != null) {
            helper.scrollToIndex(index);
        }
    }

    public void scrollToFirst() {
        this.scrollToIndex(0);
    }

    public void scrollToLast() {
        this.scrollToIndex(this.getItems().size() - 1);
    }

    public double getEstimatedLength() {
        return this.estimatedLength.get();
    }

    public ReadOnlyDoubleProperty estimatedLengthProperty() {
        return this.estimatedLength;
    }

    public double getMaxBreadth() {
        return this.maxBreadth.get();
    }

    public ReadOnlyDoubleProperty maxBreadthProperty() {
        return this.maxBreadth;
    }

    public FlowState<T, C> getState() {
        return this.manager.getState();
    }

    public ReadOnlyObjectProperty<FlowState<T, C>> stateProperty() {
        return this.manager.stateProperty();
    }

    public NumberRange<Integer> getLastRange() {
        return this.manager.getLastRange();
    }

    public ReadOnlyObjectProperty<NumberRange<Integer>> lastRangeProperty() {
        return this.manager.lastRangeProperty();
    }

    public Map<Integer, C> getIndexedCells() {
        return this.manager.getState().getCells();
    }

    protected Skin<?> createDefaultSkin() {
        return new VirtualFlowSkin(this);
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return VirtualFlow.getClassCssMetaData();
    }

    @Override
    public VirtualScrollPane wrap() {
        return VSPUtils.wrap(this);
    }

    public boolean isFitToBreadth() {
        return this.fitToBreadth.get();
    }

    public StyleableBooleanProperty fitToBreadthProperty() {
        return this.fitToBreadth;
    }

    public void setFitToBreadth(boolean fitToBreadth) {
        this.fitToBreadth.set(fitToBreadth);
    }

    public double getCellSize() {
        return this.cellSize.get();
    }

    public StyleableDoubleProperty cellSizeProperty() {
        return this.cellSize;
    }

    public void setCellSize(double cellSize) {
        this.cellSize.set(cellSize);
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public StyleableObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public double getClipBorderRadius() {
        return this.clipBorderRadius.get();
    }

    public StyleableDoubleProperty clipBorderRadiusProperty() {
        return this.clipBorderRadius;
    }

    public void setClipBorderRadius(double clipBorderRadius) {
        this.clipBorderRadius.set(clipBorderRadius);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    protected FlowManager<T, C> getViewportManager() {
        return this.manager;
    }

    public ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    public void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    public Function<T, C> getCellFactory() {
        return (Function)this.cellFactory.get();
    }

    public FunctionProperty<T, C> cellFactoryProperty() {
        return this.cellFactory;
    }

    public void setCellFactory(Function<T, C> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    public double getVPos() {
        return this.vPos.get();
    }

    public DoubleProperty vPosProperty() {
        return this.vPos;
    }

    public void setVPos(double vPos) {
        this.vPos.set(vPos);
    }

    public double getHPos() {
        return this.hPos.get();
    }

    public DoubleProperty hPosProperty() {
        return this.hPos;
    }

    public void setHPos(double hPos) {
        this.hPos.set(hPos);
    }

    public OrientationHelper getOrientationHelper() {
        return (OrientationHelper)this.orientationHelper.get();
    }

    public ReadOnlyObjectProperty<OrientationHelper> orientationHelperProperty() {
        return this.orientationHelper.getReadOnlyProperty();
    }

    protected void setOrientationHelper(OrientationHelper orientationHelper) {
        this.orientationHelper.set((Object)orientationHelper);
    }

    public Function<Orientation, OrientationHelper> getOrientationHelperFactory() {
        return (Function)this.orientationHelperFactory.get();
    }

    public FunctionProperty<Orientation, OrientationHelper> orientationHelperFactoryProperty() {
        return this.orientationHelperFactory;
    }

    public void setOrientationHelperFactory(Function<Orientation, OrientationHelper> orientationHelperFactory) {
        this.orientationHelperFactory.set(orientationHelperFactory);
    }

    public boolean isNeedsViewportLayout() {
        return this.needsViewportLayout.get();
    }

    public ReadOnlyBooleanProperty needsViewportLayoutProperty() {
        return this.needsViewportLayout.getReadOnlyProperty();
    }

    protected void setNeedsViewportLayout(boolean needsViewportLayout) {
        this.needsViewportLayout.set(needsViewportLayout);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<VirtualFlow<?, ?>> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<VirtualFlow<?, ?>, Boolean> FIT_TO_BREADTH;
        private static final CssMetaData<VirtualFlow<?, ?>, Number> CELL_SIZE;
        private static final CssMetaData<VirtualFlow<?, ?>, Orientation> ORIENTATION;
        private static final CssMetaData<VirtualFlow<?, ?>, Number> CLIP_BORDER_RADIUS;

        private StyleableProperties() {
        }

        static {
            FIT_TO_BREADTH = FACTORY.createBooleanCssMetaData("-fx-fit-to-breadth", VirtualFlow::fitToBreadthProperty, true);
            CELL_SIZE = FACTORY.createSizeCssMetaData("-fx-cell-size", VirtualFlow::cellSizeProperty, (Number)32.0);
            ORIENTATION = FACTORY.createEnumCssMetaData(Orientation.class, "-fx-orientation", VirtualFlow::orientationProperty, (Enum)Orientation.VERTICAL);
            CLIP_BORDER_RADIUS = FACTORY.createSizeCssMetaData("-fx-clip-border-radius", VirtualFlow::clipBorderRadiusProperty, (Number)0.0);
            cssMetaDataList = StyleUtils.cssMetaDataList((List)Control.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{FIT_TO_BREADTH, CELL_SIZE, ORIENTATION, CLIP_BORDER_RADIUS});
        }
    }
}

