/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.enums.UpdateType;
import io.github.palexdev.virtualizedfx.flow.FlowManager;
import io.github.palexdev.virtualizedfx.flow.FlowState;
import io.github.palexdev.virtualizedfx.flow.OrientationHelper;
import io.github.palexdev.virtualizedfx.flow.VirtualFlow;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;

public class VirtualFlowSkin<T, C extends Cell<T>>
extends SkinBase<VirtualFlow<T, C>> {
    private final Pane viewport;
    private final Rectangle clip;
    private FlowManager<T, C> manager;
    private final double DEFAULT_SIZE = 100.0;
    private ListChangeListener<? super T> itemsChanged;
    private ChangeListener<? super ObservableList<T>> listChanged;
    private InvalidationListener factoryChanged;
    private ChangeListener<? super FlowState<T, C>> stateChanged;
    private ChangeListener<? super OrientationHelper> orientationChanged;
    private ChangeListener<? super Boolean> layoutRequestListener;

    public VirtualFlowSkin(final VirtualFlow<T, C> virtualFlow) {
        super(virtualFlow);
        this.manager = virtualFlow.getViewportManager();
        this.viewport = new Pane(){

            protected void layoutChildren() {
                OrientationHelper helper = virtualFlow.getOrientationHelper();
                if (helper == null) {
                    throw new IllegalStateException("OrientationHelper is null, cannot proceed with layout");
                }
                DoubleProperty maxBreadth = (DoubleProperty)helper.maxBreadthProperty();
                FlowState state = virtualFlow.getState();
                if (state == FlowState.EMPTY || state.isEmpty()) {
                    helper.invalidatePos();
                    maxBreadth.set(0.0);
                    return;
                }
                if (state.getType() == UpdateType.CHANGE) {
                    helper.invalidatePos();
                }
                Map cells = state.getCells();
                Set<Double> positions = state.computePositions();
                double mBreadth = 0.0;
                ListIterator<Double> pIt = new ArrayList<Double>(positions).listIterator(positions.size());
                ListIterator cIt = new ArrayList(cells.values()).listIterator(cells.size());
                while (pIt.hasPrevious() && cIt.hasPrevious()) {
                    Cell cell = (Cell)cIt.previous();
                    Double pos = pIt.previous();
                    Node node = cell.getNode();
                    cell.beforeLayout();
                    double breadth = helper.computeBreadth(node);
                    if (breadth > mBreadth) {
                        mBreadth = breadth;
                    }
                    helper.layout(node, pos, breadth);
                    cell.afterLayout();
                }
                maxBreadth.set(mBreadth);
                virtualFlow.setNeedsViewportLayout(false);
            }
        };
        this.viewport.getStyleClass().add((Object)"viewport");
        this.clip = new Rectangle();
        this.clip.widthProperty().bind((ObservableValue)virtualFlow.widthProperty());
        this.clip.heightProperty().bind((ObservableValue)virtualFlow.heightProperty());
        this.clip.arcWidthProperty().bind((ObservableValue)virtualFlow.clipBorderRadiusProperty());
        this.clip.arcHeightProperty().bind((ObservableValue)virtualFlow.clipBorderRadiusProperty());
        virtualFlow.setClip((Node)this.clip);
        this.itemsChanged = this::onItemsChanged;
        this.listChanged = (observable, oldValue, newValue) -> this.onListChanged((ObservableList<? extends T>)oldValue, (ObservableList<? extends T>)newValue);
        this.factoryChanged = invalidated -> this.onFactoryChanged();
        this.stateChanged = (observable, oldValue, newValue) -> this.onStateChanged((FlowState<T, C>)oldValue, (FlowState<T, C>)newValue);
        this.orientationChanged = (observable, oldValue, newValue) -> this.onOrientationChanged((OrientationHelper)oldValue, (OrientationHelper)newValue);
        this.layoutRequestListener = (observable, oldValue, newValue) -> this.onLayoutRequest((Boolean)newValue);
        OrientationHelper helper = virtualFlow.getOrientationHelper();
        this.viewport.translateXProperty().bind((ObservableValue)helper.xPosBinding());
        this.viewport.translateYProperty().bind((ObservableValue)helper.yPosBinding());
        helper.computeEstimatedLength();
        this.getChildren().setAll((Object[])new Node[]{this.viewport});
        this.addListeners();
    }

    private void addListeners() {
        VirtualFlow virtualFlow = (VirtualFlow)this.getSkinnable();
        virtualFlow.getItems().addListener(this.itemsChanged);
        virtualFlow.itemsProperty().addListener(this.listChanged);
        virtualFlow.cellFactoryProperty().addListener(this.factoryChanged);
        virtualFlow.stateProperty().addListener(this.stateChanged);
        virtualFlow.orientationHelperProperty().addListener(this.orientationChanged);
        virtualFlow.needsViewportLayoutProperty().addListener(this.layoutRequestListener);
    }

    protected void onListChanged(ObservableList<? extends T> oldList, ObservableList<? extends T> newList) {
        if (oldList != null) {
            oldList.removeListener(this.itemsChanged);
        }
        VirtualFlow virtualFlow = (VirtualFlow)this.getSkinnable();
        FlowManager manager = virtualFlow.getViewportManager();
        if (newList != null) {
            newList.addListener(this.itemsChanged);
            virtualFlow.getOrientationHelper().computeEstimatedLength();
            manager.reset();
        }
    }

    protected void onItemsChanged(ListChangeListener.Change<? extends T> c) {
        VirtualFlow virtualFlow = (VirtualFlow)this.getSkinnable();
        this.manager.onListChange(c);
        OrientationHelper helper = virtualFlow.getOrientationHelper();
        helper.computeEstimatedLength();
    }

    protected void onFactoryChanged() {
        this.manager.reset();
        this.manager.setLastRange(IntegerRange.of((Integer)-1));
    }

    protected void onStateChanged(FlowState<T, C> oldValue, FlowState<T, C> newValue) {
        if (newValue == FlowState.EMPTY) {
            this.viewport.getChildren().clear();
            return;
        }
        if (newValue.haveCellsChanged()) {
            List<Node> nodes = newValue.getNodes();
            this.viewport.getChildren().setAll(nodes);
        }
    }

    protected void onOrientationChanged(OrientationHelper oldValue, OrientationHelper newValue) {
        if (newValue == null) {
            throw new IllegalStateException("The new provided OrientationHelper is null, you will encounter problems");
        }
        this.viewport.translateXProperty().bind((ObservableValue)newValue.xPosBinding());
        this.viewport.translateYProperty().bind((ObservableValue)newValue.yPosBinding());
    }

    protected void onLayoutRequest(Boolean newValue) {
        if (newValue.booleanValue()) {
            this.viewport.requestLayout();
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + 100.0 + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + 100.0 + bottomInset;
    }

    public void dispose() {
        VirtualFlow virtualFlow = (VirtualFlow)this.getSkinnable();
        virtualFlow.getItems().removeListener(this.itemsChanged);
        virtualFlow.itemsProperty().removeListener(this.listChanged);
        virtualFlow.cellFactoryProperty().removeListener(this.factoryChanged);
        virtualFlow.stateProperty().removeListener(this.stateChanged);
        virtualFlow.orientationHelperProperty().removeListener(this.orientationChanged);
        virtualFlow.needsViewportLayoutProperty().removeListener(this.layoutRequestListener);
        this.itemsChanged = null;
        this.listChanged = null;
        this.factoryChanged = null;
        this.stateChanged = null;
        this.orientationChanged = null;
        this.layoutRequestListener = null;
        this.manager = null;
        super.dispose();
    }
}

