/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow.paginated;

import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.virtualizedfx.flow.OrientationHelper;
import io.github.palexdev.virtualizedfx.flow.paginated.PaginatedVirtualFlow;

public interface PaginatedHelper
extends OrientationHelper {
    public double pageToPos(int var1);

    public void goToPage(int var1);

    public static class PaginatedVerticalHelper
    extends OrientationHelper.VerticalHelper
    implements PaginatedHelper {
        protected PaginatedVirtualFlow<?, ?> pFlow;

        public PaginatedVerticalHelper(PaginatedVirtualFlow<?, ?> virtualFlow) {
            super(virtualFlow);
            this.pFlow = virtualFlow;
        }

        @Override
        public int maxCells() {
            return this.pFlow.getCellsPerPage();
        }

        @Override
        public double maxVScroll() {
            return this.pageToPos(this.pFlow.getMaxPage());
        }

        @Override
        public double pageToPos(int page) {
            return (double)((page - 1) * this.pFlow.getCellsPerPage()) * this.pFlow.getCellSize();
        }

        @Override
        public void goToPage(int page) {
            super.scrollToPixel(this.pageToPos(page));
        }

        @Override
        public void scrollBy(double pixels) {
            throw new UnsupportedOperationException("The paginated flow cannot scroll by a given amount of pixels");
        }

        @Override
        public void scrollToPixel(double pixel) {
            throw new UnsupportedOperationException("The paginated flow cannot scroll to a given pixel");
        }

        @Override
        public void scrollToIndex(int index) {
            int clamped = NumberUtils.clamp((int)index, (int)1, (int)this.pFlow.getMaxPage());
            this.goToPage(clamped);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.pFlow = null;
        }
    }

    public static class PaginatedHorizontalHelper
    extends OrientationHelper.HorizontalHelper
    implements PaginatedHelper {
        protected PaginatedVirtualFlow<?, ?> pFlow;

        public PaginatedHorizontalHelper(PaginatedVirtualFlow<?, ?> virtualFlow) {
            super(virtualFlow);
            this.pFlow = virtualFlow;
        }

        @Override
        public int maxCells() {
            return this.pFlow.getCellsPerPage();
        }

        @Override
        public double maxHScroll() {
            return this.pageToPos(this.pFlow.getMaxPage());
        }

        @Override
        public double pageToPos(int page) {
            return (double)((page - 1) * this.pFlow.getCellsPerPage()) * this.pFlow.getCellSize();
        }

        @Override
        public void goToPage(int page) {
            super.scrollToPixel(this.pageToPos(page));
        }

        @Override
        public void scrollBy(double pixels) {
            throw new UnsupportedOperationException("The paginated flow cannot scroll by a given amount of pixels");
        }

        @Override
        public void scrollToPixel(double pixel) {
            throw new UnsupportedOperationException("The paginated flow cannot scroll to any given pixel");
        }

        @Override
        public void scrollToIndex(int index) {
            int clamped = NumberUtils.clamp((int)index, (int)1, (int)this.pFlow.getMaxPage());
            this.goToPage(clamped);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.pFlow = null;
        }
    }
}

