/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow.paginated;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableIntegerProperty;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.controls.VirtualScrollPane;
import io.github.palexdev.virtualizedfx.flow.OrientationHelper;
import io.github.palexdev.virtualizedfx.flow.VirtualFlow;
import io.github.palexdev.virtualizedfx.flow.paginated.PaginatedHelper;
import io.github.palexdev.virtualizedfx.flow.paginated.PaginatedVirtualFlowSkin;
import io.github.palexdev.virtualizedfx.utils.VSPUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Orientation;
import javafx.scene.control.Skin;

public class PaginatedVirtualFlow<T, C extends Cell<T>>
extends VirtualFlow<T, C> {
    private final String STYLE_CLASS = "paginated-virtual-flow";
    private final IntegerProperty currentPage = new SimpleIntegerProperty(1){

        public void set(int newValue) {
            int clamped = NumberUtils.clamp((int)newValue, (int)1, (int)PaginatedVirtualFlow.this.getMaxPage());
            super.set(clamped);
        }

        protected void invalidated() {
            int page = this.get();
            PaginatedVirtualFlow.this.changePage(page);
        }
    };
    private final ReadOnlyIntegerWrapper maxPage = new ReadOnlyIntegerWrapper(){

        public void set(int newValue) {
            int clamped = Math.max(1, newValue);
            super.set(clamped);
        }

        protected void invalidated() {
            int max = this.get();
            int curr = NumberUtils.clamp((int)PaginatedVirtualFlow.this.getCurrentPage(), (int)1, (int)max);
            PaginatedVirtualFlow.this.setCurrentPage(curr);
        }
    };
    private final StyleableIntegerProperty cellsPerPage = new StyleableIntegerProperty(StyleableProperties.CELLS_PER_PAGE, this, "cellsPerPage", 10){

        protected void invalidated() {
            PaginatedVirtualFlow.this.updateMaxPage();
            PaginatedVirtualFlow.this.changePage(PaginatedVirtualFlow.this.getCurrentPage());
            PaginatedVirtualFlow.this.requestViewportLayout();
        }
    };

    public PaginatedVirtualFlow() {
        this.initialize();
    }

    public PaginatedVirtualFlow(ObservableList<T> items, Function<T, C> cellFactory) {
        super(items, cellFactory);
        this.initialize();
    }

    public PaginatedVirtualFlow(ObservableList<T> items, Function<T, C> cellFactory, Orientation orientation) {
        super(items, cellFactory, orientation);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"paginated-virtual-flow");
        this.setOrientationHelperFactory(o -> o == Orientation.HORIZONTAL ? new PaginatedHelper.PaginatedHorizontalHelper(this) : new PaginatedHelper.PaginatedVerticalHelper(this));
    }

    public void goToPage(int page) {
        this.setCurrentPage(page);
    }

    protected void changePage(int page) {
        OrientationHelper helper = this.getOrientationHelper();
        if (!(helper instanceof PaginatedHelper)) {
            throw new IllegalStateException("The virtual flow's OrientationHelper is not of type PaginatedHelper!");
        }
        this.updateMaxPage();
        PaginatedHelper pHelper = (PaginatedHelper)helper;
        pHelper.goToPage(page);
    }

    public void updateMaxPage() {
        int items = this.getItems().size();
        int cpp = this.getCellsPerPage();
        int max = (int)Math.ceil((double)items / (double)cpp);
        this.setMaxPage(max);
    }

    public IntegerRange getRange() {
        return Optional.ofNullable(this.getOrientationHelper()).map(h -> {
            int first = h.firstVisible();
            int last = Math.min(first + h.maxCells() - 1, this.getItems().size() - 1);
            return IntegerRange.of((Integer)first, (Integer)last);
        }).orElseGet(() -> IntegerRange.of((Integer)-1));
    }

    public Map<Integer, C> getVisibleCells() {
        IntegerRange range = this.getRange();
        if (IntegerRange.of((Integer)-1).equals((Object)range)) {
            return Map.of();
        }
        return this.getIndexedCells().entrySet().stream().filter(e -> IntegerRange.inRangeOf((int)((Integer)e.getKey()), (IntegerRange)range)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void scrollToFirst() {
        this.setCurrentPage(1);
    }

    @Override
    public void scrollToLast() {
        int page = this.getMaxPage();
        this.goToPage(page);
    }

    @Override
    protected void cellSizeChanged() {
        OrientationHelper helper = this.getOrientationHelper();
        if (helper != null) {
            helper.computeEstimatedLength();
        }
        if (this.getWidth() != 0.0 && this.getHeight() != 0.0) {
            this.getViewportManager().init();
            this.goToPage(0);
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new PaginatedVirtualFlowSkin(this);
    }

    @Override
    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return PaginatedVirtualFlow.getClassCssMetaData();
    }

    @Override
    public VirtualScrollPane wrap() {
        return VSPUtils.wrap(this);
    }

    public int getCellsPerPage() {
        return this.cellsPerPage.get();
    }

    public StyleableIntegerProperty cellsPerPageProperty() {
        return this.cellsPerPage;
    }

    public void setCellsPerPage(int cellsPerPage) {
        this.cellsPerPage.set(cellsPerPage);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public int getCurrentPage() {
        return this.currentPage.get();
    }

    public IntegerProperty currentPageProperty() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage.set(currentPage);
    }

    public int getMaxPage() {
        return this.maxPage.get();
    }

    public ReadOnlyIntegerProperty maxPageProperty() {
        return this.maxPage.getReadOnlyProperty();
    }

    protected void setMaxPage(int maxPage) {
        this.maxPage.set(maxPage);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<PaginatedVirtualFlow<?, ?>> FACTORY = new StyleablePropertyFactory(VirtualFlow.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<PaginatedVirtualFlow<?, ?>, Number> CELLS_PER_PAGE;

        private StyleableProperties() {
        }

        static {
            CELLS_PER_PAGE = FACTORY.createSizeCssMetaData("-fx-cells-per-page", PaginatedVirtualFlow::cellsPerPageProperty, (Number)10);
            cssMetaDataList = StyleUtils.cssMetaDataList(VirtualFlow.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{CELLS_PER_PAGE});
        }
    }
}

