/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow.paginated;

import io.github.palexdev.mfxcore.utils.fx.NodeUtils;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.flow.VirtualFlow;
import io.github.palexdev.virtualizedfx.flow.VirtualFlowSkin;
import io.github.palexdev.virtualizedfx.flow.paginated.PaginatedVirtualFlow;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;

public class PaginatedVirtualFlowSkin<T, C extends Cell<T>>
extends VirtualFlowSkin<T, C> {
    public PaginatedVirtualFlowSkin(PaginatedVirtualFlow<T, C> virtualFlow) {
        super(virtualFlow);
        NodeUtils.waitForSkin(virtualFlow, virtualFlow::updateMaxPage, (boolean)false, (boolean)true);
    }

    protected PaginatedVirtualFlow<T, C> getFlow() {
        return (PaginatedVirtualFlow)this.getSkinnable();
    }

    protected double getLength() {
        PaginatedVirtualFlow<T, C> flow = this.getFlow();
        return (double)flow.getCellsPerPage() * flow.getCellSize();
    }

    @Override
    protected void onListChanged(ObservableList<? extends T> oldList, ObservableList<? extends T> newList) {
        this.getFlow().updateMaxPage();
        super.onListChanged(oldList, newList);
    }

    @Override
    protected void onItemsChanged(ListChangeListener.Change<? extends T> c) {
        this.getFlow().updateMaxPage();
        super.onItemsChanged(c);
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VirtualFlow)this.getSkinnable()).getOrientation();
        if (o == Orientation.HORIZONTAL) {
            return this.getLength();
        }
        return super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VirtualFlow)this.getSkinnable()).getOrientation();
        if (o == Orientation.VERTICAL) {
            return this.getLength();
        }
        return super.computeMinHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VirtualFlow)this.getSkinnable()).getOrientation();
        if (o == Orientation.HORIZONTAL) {
            return this.getLength();
        }
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VirtualFlow)this.getSkinnable()).getOrientation();
        if (o == Orientation.VERTICAL) {
            return this.getLength();
        }
        return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VirtualFlow)this.getSkinnable()).getOrientation();
        if (o == Orientation.HORIZONTAL) {
            return this.getLength();
        }
        return super.computeMaxWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VirtualFlow)this.getSkinnable()).getOrientation();
        if (o == Orientation.VERTICAL) {
            return this.getLength();
        }
        return super.computeMaxHeight(width, topInset, rightInset, bottomInset, leftInset);
    }
}

