/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.base.beans.Size;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.collections.ObservableGrid;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.virtualizedfx.grid.GridManager;
import io.github.palexdev.virtualizedfx.grid.VirtualGrid;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Orientation;
import javafx.scene.Node;

public interface GridHelper {
    public int firstRow();

    public int firstColumn();

    public int lastRow();

    public int lastColumn();

    public IntegerRange rowsRange();

    public IntegerRange columnsRange();

    public int maxRows();

    public int maxColumns();

    public double maxVScroll();

    public double maxHScroll();

    public Size computeEstimatedSize();

    public ReadOnlyObjectProperty<Size> estimatedSizeProperty();

    public DoubleBinding xPosBinding();

    public DoubleBinding yPosBinding();

    public boolean invalidatedPos();

    public void scrollToRow(int var1);

    public void scrollToColumn(int var1);

    public void scrollBy(double var1, Orientation var3);

    public void scrollTo(double var1, Orientation var3);

    public void layout(Node var1, double var2, double var4);

    public void dispose();

    public static class DefaultGridHelper
    extends AbstractHelper {
        private ChangeListener<? super Number> widthListener = (observable, oldValue, newValue) -> {
            double val = newValue.doubleValue();
            if (val > 0.0 && grid.getHeight() > 0.0) {
                this.manager.init();
            }
        };
        private ChangeListener<? super Number> heightListener = (observable, oldValue, newValue) -> {
            double val = newValue.doubleValue();
            if (val > 0.0 && grid.getWidth() > 0.0) {
                this.manager.init();
            }
        };
        private ChangeListener<? super Position> positionListener = (observable, oldValue, newValue) -> {
            ObservableGrid.Change change = grid.getItems().getChange();
            if (change != null && change != ObservableGrid.Change.EMPTY) {
                return;
            }
            if (oldValue.getX() != newValue.getX()) {
                this.manager.onHScroll();
            }
            if (oldValue.getY() != newValue.getY()) {
                this.manager.onVScroll();
            }
        };
        private DoubleBinding xPosBinding;
        private DoubleBinding yPosBinding;

        public DefaultGridHelper(VirtualGrid<?, ?> grid) {
            super(grid);
            grid.widthProperty().addListener(this.widthListener);
            grid.heightProperty().addListener(this.heightListener);
            grid.positionProperty().addListener(this.positionListener);
            ((ObjectProperty)grid.estimatedSizeProperty()).bind(this.estimatedSizeProperty());
        }

        @Override
        public int firstRow() {
            return NumberUtils.clamp((int)((int)Math.floor(this.grid.getVPos() / this.grid.getCellSize().getHeight())), (int)0, (int)(this.grid.getRowsNum() - 1));
        }

        @Override
        public int firstColumn() {
            return NumberUtils.clamp((int)((int)Math.floor(this.grid.getHPos() / this.grid.getCellSize().getWidth())), (int)0, (int)(this.grid.getColumnsNum() - 1));
        }

        @Override
        public int lastRow() {
            return NumberUtils.clamp((int)(this.firstRow() + this.maxRows() - 1), (int)0, (int)(this.grid.getRowsNum() - 1));
        }

        @Override
        public int lastColumn() {
            return NumberUtils.clamp((int)(this.firstColumn() + this.maxColumns() - 1), (int)0, (int)(this.grid.getColumnsNum() - 1));
        }

        @Override
        public IntegerRange rowsRange() {
            int rNum = Math.min(this.maxRows(), this.grid.getRowsNum());
            int last = this.lastRow();
            int first = Math.max(last - rNum + 1, 0);
            return IntegerRange.of((Integer)first, (Integer)last);
        }

        @Override
        public IntegerRange columnsRange() {
            int cNum = Math.min(this.maxColumns(), this.grid.getColumnsNum());
            int last = this.lastColumn();
            int first = Math.max(last - cNum + 1, 0);
            return IntegerRange.of((Integer)first, (Integer)last);
        }

        @Override
        public int maxRows() {
            return (int)(Math.ceil(this.grid.getHeight() / this.grid.getCellSize().getHeight()) + 1.0);
        }

        @Override
        public int maxColumns() {
            return (int)(Math.ceil(this.grid.getWidth() / this.grid.getCellSize().getWidth()) + 1.0);
        }

        @Override
        public double maxVScroll() {
            return ((Size)this.estimatedSize.get()).getHeight() - this.grid.getHeight();
        }

        @Override
        public double maxHScroll() {
            return ((Size)this.estimatedSize.get()).getWidth() - this.grid.getWidth();
        }

        @Override
        public Size computeEstimatedSize() {
            Size cellSize = this.grid.getCellSize();
            double width = (double)this.grid.getColumnsNum() * cellSize.getWidth();
            double height = (double)this.grid.getRowsNum() * cellSize.getHeight();
            Size size = Size.of((double)width, (double)height);
            this.estimatedSize.set((Object)size);
            return size;
        }

        @Override
        public DoubleBinding xPosBinding() {
            if (this.xPosBinding == null) {
                this.xPosBinding = Bindings.createDoubleBinding(() -> -this.grid.getHPos() % this.grid.getCellSize().getWidth(), (Observable[])new Observable[]{this.grid.positionProperty(), this.grid.cellSizeProperty()});
            }
            return this.xPosBinding;
        }

        @Override
        public DoubleBinding yPosBinding() {
            if (this.yPosBinding == null) {
                this.yPosBinding = Bindings.createDoubleBinding(() -> -this.grid.getVPos() % this.grid.getCellSize().getHeight(), (Observable[])new Observable[]{this.grid.positionProperty(), this.grid.cellSizeProperty()});
            }
            return this.yPosBinding;
        }

        @Override
        public void scrollToRow(int index) {
            double val = (double)index * this.grid.getCellSize().getHeight();
            double clampedVal = NumberUtils.clamp((double)val, (double)0.0, (double)this.maxVScroll());
            this.grid.setVPos(clampedVal);
        }

        @Override
        public void scrollToColumn(int index) {
            double val = (double)index * this.grid.getCellSize().getWidth();
            double clampedVal = NumberUtils.clamp((double)val, (double)0.0, (double)this.maxHScroll());
            this.grid.setHPos(clampedVal);
        }

        @Override
        public void scrollBy(double pixels, Orientation orientation) {
            if (orientation == Orientation.VERTICAL) {
                double newVal = NumberUtils.clamp((double)(this.grid.getVPos() + pixels), (double)0.0, (double)this.maxVScroll());
                this.grid.setVPos(newVal);
            } else {
                double newVal = NumberUtils.clamp((double)(this.grid.getHPos() + pixels), (double)0.0, (double)this.maxHScroll());
                this.grid.setHPos(newVal);
            }
        }

        @Override
        public void scrollTo(double pixel, Orientation orientation) {
            if (orientation == Orientation.VERTICAL) {
                double clampedVal = NumberUtils.clamp((double)pixel, (double)0.0, (double)this.maxVScroll());
                this.grid.setVPos(clampedVal);
            } else {
                double clampedVal = NumberUtils.clamp((double)pixel, (double)0.0, (double)this.maxHScroll());
                this.grid.setHPos(clampedVal);
            }
        }

        @Override
        public void layout(Node node, double x, double y) {
            Size cellSize = this.grid.getCellSize();
            node.resizeRelocate(x, y, cellSize.getWidth(), cellSize.getHeight());
        }

        @Override
        public void dispose() {
            this.grid.widthProperty().removeListener(this.widthListener);
            this.grid.heightProperty().removeListener(this.heightListener);
            this.grid.positionProperty().removeListener(this.positionListener);
            this.widthListener = null;
            this.heightListener = null;
            this.positionListener = null;
            if (this.xPosBinding != null) {
                this.xPosBinding.dispose();
            }
            if (this.yPosBinding != null) {
                this.yPosBinding.dispose();
            }
            this.xPosBinding = null;
            this.yPosBinding = null;
        }
    }

    public static abstract class AbstractHelper
    implements GridHelper {
        protected final VirtualGrid<?, ?> grid;
        protected final GridManager<?, ?> manager;
        protected final ObjectProperty<Size> estimatedSize = new SimpleObjectProperty((Object)Size.of((double)0.0, (double)0.0));

        public AbstractHelper(VirtualGrid<?, ?> grid) {
            this.grid = grid;
            this.manager = grid.getViewportManager();
        }

        @Override
        public boolean invalidatedPos() {
            Size size = (Size)this.estimatedSize.get();
            double x = Math.min(size.getWidth(), this.grid.getHPos());
            double y = Math.min(size.getHeight(), this.grid.getVPos());
            Position pos = Position.of((double)x, (double)y);
            boolean invalid = !this.grid.getPosition().equals((Object)pos);
            this.grid.setPosition(pos);
            return invalid;
        }

        @Override
        public ReadOnlyObjectProperty<Size> estimatedSizeProperty() {
            return this.estimatedSize;
        }
    }
}

