/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.beans.range.NumberRange;
import io.github.palexdev.mfxcore.base.properties.range.IntegerRangeProperty;
import io.github.palexdev.mfxcore.collections.ObservableGrid;
import io.github.palexdev.mfxcore.enums.GridChangeType;
import io.github.palexdev.virtualizedfx.beans.GridStateProperty;
import io.github.palexdev.virtualizedfx.cell.GridCell;
import io.github.palexdev.virtualizedfx.grid.GridHelper;
import io.github.palexdev.virtualizedfx.grid.GridState;
import io.github.palexdev.virtualizedfx.grid.VirtualGrid;

public class GridManager<T, C extends GridCell<T>> {
    private final VirtualGrid<T, C> grid;
    private final GridStateProperty<T, C> state = new GridStateProperty(GridState.EMPTY);
    private final IntegerRangeProperty lastRowsRange = new IntegerRangeProperty();
    private final IntegerRangeProperty lastColumnsRange = new IntegerRangeProperty();

    GridManager(VirtualGrid<T, C> grid) {
        this.grid = grid;
    }

    public boolean init() {
        if (this.grid.getCellFactory() == null || this.itemsEmpty()) {
            return false;
        }
        GridHelper helper = this.grid.getGridHelper();
        IntegerRange rowsRange = helper.rowsRange();
        IntegerRange columnsRange = helper.columnsRange();
        helper.computeEstimatedSize();
        GridState<T, C> oldState = this.getState();
        GridState<T, C> newState = new GridState<T, C>(this.grid, rowsRange, columnsRange);
        if (oldState == GridState.EMPTY) {
            for (Integer row : rowsRange) {
                newState.addRow(row);
            }
            newState.cellsChanged();
            this.setState(newState);
            this.setLastRowsRange((NumberRange<Integer>)rowsRange);
            this.setLastColumnsRange((NumberRange<Integer>)columnsRange);
            this.grid.requestViewportLayout();
            return true;
        }
        newState = oldState.init(rowsRange, columnsRange);
        if (newState == oldState) {
            return false;
        }
        newState.cellsChanged();
        this.setState(newState);
        this.setLastRowsRange((NumberRange<Integer>)rowsRange);
        this.setLastColumnsRange((NumberRange<Integer>)columnsRange);
        this.grid.requestViewportLayout();
        return true;
    }

    public void onVScroll() {
        IntegerRange lRange;
        GridState<T, C> state = this.getState();
        if (state == GridState.EMPTY || state.isEmpty() || this.grid.isEmpty()) {
            return;
        }
        GridHelper helper = this.grid.getGridHelper();
        int rows = helper.maxRows();
        int sFirstRow = helper.firstRow();
        int sLastRow = helper.lastRow();
        int sTrueFirstRow = Math.max(sLastRow - rows + 1, 0);
        IntegerRange sRange = IntegerRange.of((Integer)sTrueFirstRow, (Integer)sLastRow);
        if (!sRange.equals((Object)state.getRowsRange())) {
            this.setState(state.vScroll(sRange));
        }
        if (!(lRange = IntegerRange.of((Integer)sFirstRow, (Integer)sLastRow)).equals(this.getLastRowsRange())) {
            this.grid.requestViewportLayout();
        }
        this.setLastRowsRange((NumberRange<Integer>)lRange);
    }

    public void onHScroll() {
        IntegerRange lRange;
        GridState<T, C> state = this.getState();
        if (state == GridState.EMPTY || state.isEmpty()) {
            return;
        }
        GridHelper helper = this.grid.getGridHelper();
        int columns = helper.maxColumns();
        int sFirstColumn = helper.firstColumn();
        int sLastColumn = helper.lastColumn();
        int sTrueFirstColumn = Math.max(sLastColumn - columns + 1, 0);
        IntegerRange sRange = IntegerRange.of((Integer)sTrueFirstColumn, (Integer)sLastColumn);
        if (!sRange.equals((Object)state.getColumnsRange())) {
            this.setState(state.hScroll(sRange));
        }
        if (!(lRange = IntegerRange.of((Integer)sFirstColumn, (Integer)sLastColumn)).equals(this.getLastColumnsRange())) {
            this.grid.requestViewportLayout();
        }
        this.setLastColumnsRange((NumberRange<Integer>)lRange);
    }

    public void onChange(ObservableGrid.Change<T> change) {
        GridState<T, C> state = this.getState();
        if (this.itemsEmpty()) {
            this.clear();
            change.endChange();
            return;
        }
        if (state == GridState.EMPTY) {
            this.init();
            change.endChange();
            return;
        }
        if (change.getType() == GridChangeType.TRANSPOSE) {
            this.reset();
            change.endChange();
            return;
        }
        state = state.change(change);
        this.setState(state);
        this.grid.requestViewportLayout();
        this.setLastRowsRange((NumberRange<Integer>)state.getRowsRange());
        this.setLastColumnsRange((NumberRange<Integer>)state.getColumnsRange());
    }

    public void clear() {
        this.getState().clear();
        this.setState(GridState.EMPTY);
        this.setLastRowsRange((NumberRange<Integer>)IntegerRange.of((Integer)-1));
        this.setLastColumnsRange((NumberRange<Integer>)IntegerRange.of((Integer)-1));
        GridHelper helper = this.grid.getGridHelper();
        helper.computeEstimatedSize();
        helper.invalidatedPos();
    }

    public void reset() {
        this.clear();
        this.init();
    }

    protected boolean itemsEmpty() {
        return this.grid.isEmpty();
    }

    public GridState<T, C> getState() {
        return (GridState)this.state.get();
    }

    public GridStateProperty<T, C> stateProperty() {
        return this.state;
    }

    protected void setState(GridState<T, C> state) {
        this.state.set(state);
    }

    public NumberRange<Integer> getLastRowsRange() {
        return (NumberRange)this.lastRowsRange.get();
    }

    public IntegerRangeProperty lastRowsRangeProperty() {
        return this.lastRowsRange;
    }

    public void setLastRowsRange(NumberRange<Integer> lastRowsRange) {
        this.lastRowsRange.set(lastRowsRange);
    }

    public NumberRange<Integer> getLastColumnsRange() {
        return (NumberRange)this.lastColumnsRange.get();
    }

    public IntegerRangeProperty lastColumnsRangeProperty() {
        return this.lastColumnsRange;
    }

    public void setLastColumnsRange(NumberRange<Integer> lastColumnsRange) {
        this.lastColumnsRange.set(lastColumnsRange);
    }
}

