/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.Size;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.utils.GridUtils;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.cell.GridCell;
import io.github.palexdev.virtualizedfx.grid.GridHelper;
import io.github.palexdev.virtualizedfx.grid.VirtualGrid;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class GridRow<T, C extends GridCell<T>> {
    private final VirtualGrid<T, C> grid;
    private int index;
    private IntegerRange columns;
    private final Map<Integer, C> cells = new TreeMap<Integer, C>();
    private final Set<Double> positions = new TreeSet<Double>();
    private double position;
    private boolean reusablePositions = false;
    private boolean visible = true;

    public GridRow(VirtualGrid<T, C> grid, int index, IntegerRange columns) {
        this.grid = grid;
        this.index = index;
        this.columns = columns;
    }

    public static <T, C extends GridCell<T>> GridRow<T, C> of(VirtualGrid<T, C> virtualGrid, int index, IntegerRange columns) {
        return new GridRow<T, C>(virtualGrid, index, columns);
    }

    public GridRow<T, C> init() {
        if (this.index < 0 || IntegerRange.of((Integer)-1).equals((Object)this.columns)) {
            return this;
        }
        this.clear();
        for (Integer column : this.columns) {
            int linear = this.toLinear(this.index, column);
            Object item = this.grid.getItems().getElement(linear);
            GridCell cell = (GridCell)this.grid.getCellFactory().apply(item);
            cell.updateIndex(linear);
            cell.updateCoordinates(this.index, column);
            this.cells.put(column, cell);
        }
        return this;
    }

    protected void onInit(IntegerRange columns) {
        if (this.columns.equals((Object)columns)) {
            return;
        }
        HashMap<Integer, GridCell> tmp = new HashMap<Integer, GridCell>();
        Set range = IntegerRange.expandRangeToSet((IntegerRange)columns);
        int targetSize = columns.diff() + 1;
        for (Integer column : columns) {
            if (!this.cells.containsKey(column)) continue;
            tmp.put(column, (GridCell)this.cells.remove(column));
            range.remove(column);
        }
        ArrayDeque<Integer> reusable = new ArrayDeque<Integer>(this.cells.keySet());
        ArrayDeque remaining = new ArrayDeque(range);
        while (tmp.size() != targetSize) {
            GridCell cell;
            int rIndex = (Integer)remaining.removeFirst();
            Integer oIndex = (Integer)reusable.poll();
            int linear = this.toLinear(this.index, rIndex);
            Object item = this.grid.getItems().getElement(linear);
            if (oIndex != null) {
                cell = (GridCell)this.cells.remove(oIndex);
                cell.updateItem(item);
            } else {
                cell = (GridCell)this.grid.getCellFactory().apply(item);
            }
            cell.updateIndex(linear);
            cell.updateCoordinates(this.index, rIndex);
            tmp.put(rIndex, cell);
        }
        this.clear();
        this.cells.putAll(tmp);
        this.columns = columns;
    }

    protected void updateIndex(int index) {
        if (this.index == index) {
            return;
        }
        for (Map.Entry<Integer, C> e : this.cells.entrySet()) {
            int column = e.getKey();
            int linear = this.toLinear(index, column);
            GridCell cell = (GridCell)e.getValue();
            Object item = this.grid.getItems().getElement(linear);
            cell.updateItem(item);
            cell.updateIndex(linear);
            cell.updateCoordinates(index, column);
        }
        this.index = index;
        this.reusablePositions = true;
    }

    protected void onScroll(IntegerRange columns) {
        HashMap<Integer, GridCell> tmp = new HashMap<Integer, GridCell>();
        Set range = IntegerRange.expandRangeToSet((IntegerRange)columns);
        int targetSize = columns.diff() + 1;
        for (Integer column : columns) {
            if (!this.cells.containsKey(column)) continue;
            int linear = this.toLinear(this.index, column);
            GridCell cell = (GridCell)this.cells.remove(column);
            cell.updateIndex(linear);
            cell.updateCoordinates(this.index, column);
            tmp.put(column, cell);
            range.remove(column);
        }
        ArrayDeque<Integer> reusable = new ArrayDeque<Integer>(this.cells.keySet());
        ArrayDeque remaining = new ArrayDeque(range);
        while (tmp.size() != targetSize) {
            int rIndex = (Integer)remaining.removeFirst();
            int oIndex = (Integer)reusable.removeFirst();
            int linear = this.toLinear(this.index, rIndex);
            Object item = this.grid.getItems().getElement(linear);
            GridCell cell = (GridCell)this.cells.remove(oIndex);
            cell.updateItem(item);
            cell.updateIndex(linear);
            cell.updateCoordinates(this.index, rIndex);
            tmp.put(rIndex, cell);
        }
        this.clear();
        this.cells.putAll(tmp);
        this.columns = columns;
    }

    protected void onReplace() {
        this.cells.forEach((i, c) -> {
            int linear = this.toLinear(this.index, (int)i);
            Object item = this.grid.getItems().getElement(linear);
            c.updateItem(item);
        });
        this.reusablePositions = true;
    }

    protected void onReplace(int column, T item) {
        Optional.ofNullable((GridCell)this.cells.get(column)).ifPresent(cell -> cell.updateItem(item));
        this.reusablePositions = true;
    }

    protected void onDiagReplace(T item) {
        this.onReplace(this.index, item);
    }

    protected void onRowAdd(int newIndex) {
        this.partialUpdate(newIndex);
    }

    protected void onRowRemove(int newIndex) {
        this.partialUpdate(newIndex);
    }

    protected void onColumnAdd(int column, IntegerRange columns) {
        HashMap<Integer, GridCell> processed = new HashMap<Integer, GridCell>();
        HashSet<Integer> available = new HashSet<Integer>(this.cells.keySet());
        int targetSize = columns.diff() + 1;
        for (int i = ((Integer)columns.getMin()).intValue(); i < column; ++i) {
            GridCell cell = (GridCell)this.cells.remove(i);
            if (this.index != 0) {
                int linear = this.toLinear(this.index, i);
                cell.updateIndex(linear);
            }
            processed.put(i, cell);
            available.remove(i);
        }
        Iterator<Map.Entry<Integer, C>> it = this.cells.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, C> next = it.next();
            int cIndex = next.getKey();
            int newIndex = cIndex + 1;
            if (!IntegerRange.inRangeOf((int)newIndex, (IntegerRange)columns) || newIndex >= (Integer)columns.getMin() && newIndex < column) continue;
            int lIndex = this.index == 0 ? newIndex : this.toLinear(this.index, newIndex);
            GridCell cell = (GridCell)next.getValue();
            cell.updateIndex(lIndex);
            cell.updateCoordinates(this.index, newIndex);
            processed.put(newIndex, cell);
            available.remove(cIndex);
            it.remove();
        }
        if (processed.size() != targetSize) {
            GridCell cell;
            Integer oIndex = new ArrayDeque<Integer>(available).poll();
            int lIndex = this.index == 0 ? column : this.toLinear(this.index, column);
            Object item = this.grid.getItems().getElement(lIndex);
            if (oIndex != null) {
                cell = (GridCell)this.cells.remove(oIndex);
                cell.updateItem(item);
            } else {
                cell = (GridCell)this.grid.getCellFactory().apply(item);
            }
            cell.updateIndex(lIndex);
            cell.updateCoordinates(this.index, column);
            processed.put(column, cell);
        }
        this.clear();
        this.cells.putAll(processed);
        this.columns = columns;
    }

    protected void onColumnRemove(int column, IntegerRange columns) {
        GridCell cell;
        HashMap<Integer, GridCell> processed = new HashMap<Integer, GridCell>();
        HashSet<Integer> available = new HashSet<Integer>(this.cells.keySet());
        Set rangeSet = IntegerRange.expandRangeToSet((IntegerRange)columns);
        int start = Math.max((Integer)this.columns.getMin(), (Integer)columns.getMin());
        int end = Math.min((Integer)columns.getMax(), column);
        for (int i = start; i < end; ++i) {
            GridCell cell2 = (GridCell)this.cells.remove(i);
            if (this.index != 0) {
                int linear = this.toLinear(this.index, i);
                cell2.updateIndex(linear);
            }
            processed.put(i, cell2);
            available.remove(i);
            rangeSet.remove(i);
        }
        Iterator<Map.Entry<Integer, C>> it = this.cells.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, C> next = it.next();
            int cIndex = next.getKey();
            int newIndex = cIndex - 1;
            if (!IntegerRange.inRangeOf((int)newIndex, (IntegerRange)columns) || newIndex >= start && newIndex < end) continue;
            int lIndex = this.index == 0 ? newIndex : this.toLinear(this.index, newIndex);
            cell = (GridCell)next.getValue();
            cell.updateIndex(lIndex);
            cell.updateCoordinates(this.index, newIndex);
            processed.put(newIndex, cell);
            available.remove(cIndex);
            rangeSet.remove(newIndex);
            it.remove();
        }
        if (!rangeSet.isEmpty()) {
            Integer oIndex = new ArrayDeque<Integer>(available).poll();
            int nIndex = (Integer)new ArrayDeque(rangeSet).removeFirst();
            int lIndex = this.index == 0 ? nIndex : this.toLinear(this.index, nIndex);
            Object item = this.grid.getItems().getElement(lIndex);
            if (oIndex != null) {
                cell = (GridCell)this.cells.remove(oIndex);
                cell.updateItem(item);
            } else {
                cell = (GridCell)this.grid.getCellFactory().apply(item);
            }
            cell.updateIndex(lIndex);
            cell.updateCoordinates(this.index, nIndex);
            processed.put(nIndex, cell);
        }
        this.clear();
        this.cells.putAll(processed);
        this.columns = columns;
    }

    private void partialUpdate(int newIndex) {
        this.cells.forEach((i, c) -> {
            int linear = this.toLinear(newIndex, (int)i);
            c.updateIndex(linear);
            c.updateCoordinates(newIndex, (int)i);
        });
        this.index = newIndex;
        this.reusablePositions = true;
    }

    public void layoutCells(double position, boolean adjustColumns) {
        if (this.cells.isEmpty()) {
            return;
        }
        GridHelper helper = this.grid.getGridHelper();
        Size size = this.grid.getCellSize();
        double right = (double)this.columns.diff().intValue() * size.getWidth();
        if (adjustColumns) {
            right -= size.getWidth();
        }
        if (!this.canReusePositions() || this.positions.size() != this.columns.diff() + 1 || adjustColumns) {
            this.positions.clear();
            for (int i = 0; i < this.size(); ++i) {
                this.positions.add(right);
                right -= size.getWidth();
            }
        }
        ListIterator<C> cIt = new ArrayList<C>(this.cells.values()).listIterator(this.size());
        ListIterator<Double> pIt = new ArrayList<Double>(this.positions).listIterator(this.size());
        while (cIt.hasPrevious()) {
            GridCell cell = (GridCell)cIt.previous();
            Double pos = pIt.previous();
            Node node = cell.getNode();
            cell.beforeLayout();
            helper.layout(node, pos, position);
            cell.afterLayout();
        }
        this.position = position;
        this.reusablePositions = false;
    }

    protected void clear() {
        this.cells.values().forEach(Cell::dispose);
        this.cells.clear();
    }

    public int size() {
        return this.cells.size();
    }

    public int toLinear(int row, int column) {
        return GridUtils.subToInd((int)this.grid.getColumnsNum(), (int)row, (int)column);
    }

    public VirtualGrid<T, C> getVirtualGrid() {
        return this.grid;
    }

    public int getIndex() {
        return this.index;
    }

    public IntegerRange getColumns() {
        return this.columns;
    }

    protected Map<Integer, C> getCells() {
        return this.cells;
    }

    public Map<Integer, C> getCellsUnmodifiable() {
        return Collections.unmodifiableMap(this.cells);
    }

    public Map<Integer, C> getLinearCells() {
        return this.cells.entrySet().stream().collect(Collectors.toMap(e -> this.toLinear(this.index, (Integer)e.getKey()), Map.Entry::getValue));
    }

    protected Set<Double> getPositions() {
        return this.positions;
    }

    public Set<Double> getPositionsUnmodifiable() {
        return Collections.unmodifiableSet(this.positions);
    }

    public double getPosition() {
        return this.position;
    }

    public boolean canReusePositions() {
        return this.reusablePositions;
    }

    protected void setReusablePositions(boolean reusablePositions) {
        this.reusablePositions = reusablePositions;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void setVisible(boolean visible) {
        this.cells.values().forEach(c -> c.getNode().setVisible(visible));
        this.visible = visible;
    }
}

