/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.Size;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.collections.Grid;
import io.github.palexdev.mfxcore.collections.ObservableGrid;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.cell.GridCell;
import io.github.palexdev.virtualizedfx.enums.UpdateType;
import io.github.palexdev.virtualizedfx.grid.GridHelper;
import io.github.palexdev.virtualizedfx.grid.GridRow;
import io.github.palexdev.virtualizedfx.grid.VirtualGrid;
import io.github.palexdev.virtualizedfx.grid.paginated.PaginatedVirtualGrid;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class GridState<T, C extends GridCell<T>> {
    public static final GridState EMPTY = new GridState();
    private final VirtualGrid<T, C> grid;
    private final Map<Integer, GridRow<T, C>> rows = new TreeMap<Integer, GridRow<T, C>>();
    private final IntegerRange rowsRange;
    private final IntegerRange columnsRange;
    private int targetSize;
    private UpdateType type = UpdateType.INIT;
    private boolean cellsChanged;

    public GridState() {
        this.grid = null;
        this.rowsRange = IntegerRange.of((Integer)-1);
        this.columnsRange = IntegerRange.of((Integer)-1);
        this.targetSize = 0;
    }

    public GridState(VirtualGrid<T, C> grid, IntegerRange rowsRange, IntegerRange columnsRange) {
        this.grid = grid;
        this.rowsRange = rowsRange;
        this.columnsRange = columnsRange;
        this.targetSize = grid.getGridHelper().maxRows();
    }

    protected GridState<T, C> init(IntegerRange rowsRange, IntegerRange columnsRange) {
        if (this.rowsRange.equals((Object)rowsRange) && this.columnsRange.equals((Object)columnsRange)) {
            GridHelper helper = this.grid.getGridHelper();
            this.targetSize = helper.maxRows();
            return this;
        }
        GridState<T, C> newState = new GridState<T, C>(this.grid, rowsRange, columnsRange);
        Set range = IntegerRange.expandRangeToSet((IntegerRange)rowsRange);
        int targetSize = rowsRange.diff() + 1;
        for (Integer rowIndex : rowsRange) {
            GridRow<T, C> row = this.rows.remove(rowIndex);
            if (row == null) continue;
            row.onInit(columnsRange);
            newState.addRow(rowIndex, row);
            range.remove(rowIndex);
        }
        ArrayDeque<Integer> reusable = new ArrayDeque<Integer>(this.rows.keySet());
        ArrayDeque remaining = new ArrayDeque(range);
        while (newState.size() != targetSize) {
            int rIndex = (Integer)remaining.removeFirst();
            Integer oIndex = (Integer)reusable.poll();
            if (oIndex != null) {
                GridRow<T, C> row = this.rows.remove(oIndex);
                row.updateIndex(rIndex);
                newState.addRow(rIndex, row);
                continue;
            }
            newState.addRow(rIndex);
        }
        this.clear();
        return newState;
    }

    protected GridState<T, C> vScroll(IntegerRange rowsRange) {
        if (this.rowsRange.equals((Object)rowsRange)) {
            return this;
        }
        GridState<T, C> newState = new GridState<T, C>(this.grid, rowsRange, this.columnsRange);
        newState.type = UpdateType.SCROLL;
        Set range = IntegerRange.expandRangeToSet((IntegerRange)rowsRange);
        for (Integer rowIndex : rowsRange) {
            GridRow<T, C> row = this.rows.remove(rowIndex);
            if (row == null) continue;
            newState.addRow(rowIndex, row);
            range.remove(rowIndex);
        }
        ArrayDeque<Integer> reusable = new ArrayDeque<Integer>(this.rows.keySet());
        ArrayDeque remaining = new ArrayDeque(range);
        while (!remaining.isEmpty()) {
            int rIndex = (Integer)remaining.removeFirst();
            Integer oIndex = (Integer)reusable.poll();
            if (oIndex == null) {
                this.grid.requestViewportLayout();
                continue;
            }
            GridRow<T, C> row = this.rows.remove(oIndex);
            row.updateIndex(rIndex);
            row.setReusablePositions(false);
            newState.addRow(rIndex, row);
        }
        return newState;
    }

    protected GridState<T, C> hScroll(IntegerRange columnsRange) {
        if (this.columnsRange.equals((Object)columnsRange)) {
            return this;
        }
        GridState<T, C> newState = new GridState<T, C>(this.grid, this.rowsRange, columnsRange);
        newState.type = UpdateType.SCROLL;
        Iterator<Map.Entry<Integer, GridRow<T, C>>> it = this.rows.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, GridRow<T, C>> next = it.next();
            Integer index = next.getKey();
            GridRow<T, C> row = next.getValue();
            row.onScroll(columnsRange);
            newState.addRow(index, row);
            it.remove();
        }
        return newState;
    }

    protected GridState<T, C> change(ObservableGrid.Change<T> change) {
        int cellsNum = this.totalSize();
        GridState<T, C> state = this;
        switch (change.getType()) {
            case REPLACE_ELEMENT: {
                Grid.Coordinates coordinates = change.getCoordinates();
                Optional.ofNullable(this.rows.get(coordinates.getRow())).ifPresent(row -> row.onReplace(coordinates.getColumn(), change.getAdded().get(0)));
                break;
            }
            case REPLACE_DIAGONAL: {
                ArrayDeque diag = new ArrayDeque(change.getAdded());
                this.rows.values().forEach(row -> row.onDiagReplace(diag.poll()));
                break;
            }
            case REPLACE_ROW: {
                int row2 = change.getCoordinates().getRow();
                Optional.ofNullable(this.rows.get(row2)).ifPresent(GridRow::onReplace);
                break;
            }
            case REPLACE_COLUMN: {
                int index = change.getCoordinates().getColumn();
                ArrayDeque col = new ArrayDeque(change.getAdded().subList((Integer)this.columnsRange.getMin(), (Integer)this.columnsRange.getMax()));
                this.rows.values().forEach(row -> row.onReplace(index, col.poll()));
                break;
            }
            case ADD_ROW: {
                GridRow<T, C> row3;
                GridHelper helper = this.grid.getGridHelper();
                int index = change.getCoordinates().getRow();
                IntegerRange range = helper.rowsRange();
                if (range.equals((Object)this.rowsRange) && index > (Integer)this.rowsRange.getMax() && this.rowsFilled()) break;
                state = new GridState<T, C>(this.grid, range, this.columnsRange);
                HashSet<Integer> available = new HashSet<Integer>(this.rows.keySet());
                for (int i = ((Integer)range.getMin()).intValue(); i < index; ++i) {
                    GridRow<T, C> row4 = this.rows.remove(i);
                    row4.setReusablePositions(true);
                    state.addRow(i, row4);
                    available.remove(i);
                }
                Iterator<Map.Entry<Integer, GridRow<T, C>>> it = this.rows.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, GridRow<T, C>> next = it.next();
                    int rIndex = next.getKey();
                    int newIndex = rIndex + 1;
                    if (!IntegerRange.inRangeOf((int)newIndex, (IntegerRange)range) || newIndex >= (Integer)range.getMin() && newIndex < index) continue;
                    GridRow<T, C> row5 = next.getValue();
                    row5.onRowAdd(newIndex);
                    state.addRow(newIndex, row5);
                    available.remove(rIndex);
                    it.remove();
                }
                Integer oIndex = new ArrayDeque<Integer>(available).poll();
                if (oIndex != null) {
                    row3 = this.rows.remove(oIndex);
                    row3.updateIndex(index);
                } else {
                    row3 = GridRow.of(this.grid, index, this.columnsRange).init();
                }
                state.addRow(index, row3);
                break;
            }
            case REMOVE_ROW: {
                GridRow<T, C> row6;
                int start;
                GridHelper helper = this.grid.getGridHelper();
                int index = change.getCoordinates().getRow();
                IntegerRange range = helper.rowsRange();
                if (range.equals((Object)this.rowsRange) && index > (Integer)range.getMax()) break;
                state = new GridState<T, C>(this.grid, range, this.columnsRange);
                HashSet<Integer> available = new HashSet<Integer>(this.rows.keySet());
                Set rangeSet = IntegerRange.expandRangeToSet((IntegerRange)range);
                for (int i = start = Math.max((Integer)range.getMin(), (Integer)this.rowsRange.getMin()); i < index; ++i) {
                    GridRow<T, C> row7 = this.rows.remove(i);
                    row7.setReusablePositions(true);
                    state.addRow(i, row7);
                    available.remove(i);
                    rangeSet.remove(i);
                }
                Iterator<Map.Entry<Integer, GridRow<T, C>>> it = this.rows.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, GridRow<T, C>> next = it.next();
                    int rIndex = next.getKey();
                    int newIndex = rIndex - 1;
                    if (!IntegerRange.inRangeOf((int)newIndex, (IntegerRange)range) || newIndex >= start && newIndex < index) continue;
                    GridRow<T, C> row8 = next.getValue();
                    row8.onRowRemove(newIndex);
                    state.addRow(newIndex, row8);
                    available.remove(rIndex);
                    rangeSet.remove(newIndex);
                    it.remove();
                }
                if (rangeSet.isEmpty()) {
                    this.clear();
                    break;
                }
                Integer oIndex = new ArrayDeque<Integer>(available).poll();
                int nIndex = (Integer)new ArrayDeque(rangeSet).removeFirst();
                if (oIndex != null) {
                    row6 = this.rows.remove(oIndex);
                    row6.updateIndex(nIndex);
                } else {
                    row6 = GridRow.of(this.grid, nIndex, this.columnsRange).init();
                }
                state.addRow(nIndex, row6);
                break;
            }
            case ADD_COLUMN: {
                GridHelper helper = this.grid.getGridHelper();
                IntegerRange range = helper.columnsRange();
                int index = change.getCoordinates().getColumn();
                state = new GridState<T, C>(this.grid, this.rowsRange, range);
                Iterator<Map.Entry<Integer, GridRow<T, C>>> it = this.rows.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, GridRow<T, C>> next = it.next();
                    int rIndex = next.getKey();
                    GridRow<T, C> row9 = next.getValue();
                    row9.onColumnAdd(index, range);
                    state.addRow(rIndex, row9);
                    it.remove();
                }
                break;
            }
            case REMOVE_COLUMN: {
                GridHelper helper = this.grid.getGridHelper();
                IntegerRange range = helper.columnsRange();
                int index = change.getCoordinates().getColumn();
                state = new GridState<T, C>(this.grid, this.rowsRange, this.columnsRange);
                Iterator<Map.Entry<Integer, GridRow<T, C>>> it = this.rows.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, GridRow<T, C>> next = it.next();
                    Integer rIndex = next.getKey();
                    GridRow<T, C> row10 = next.getValue();
                    row10.onColumnRemove(index, range);
                    state.addRow(rIndex, row10);
                    it.remove();
                }
                break;
            }
        }
        state.type = UpdateType.CHANGE;
        if (state.totalSize() != cellsNum) {
            state.cellsChanged();
        }
        change.endChange();
        return state;
    }

    public void layoutRows() {
        if (this.isEmpty()) {
            return;
        }
        if (this.grid instanceof PaginatedVirtualGrid) {
            this.layoutPaginatedRows();
            return;
        }
        GridHelper helper = this.grid.getGridHelper();
        Size size = this.grid.getCellSize();
        int gRows = this.grid.getRowsNum();
        int gColumns = this.grid.getColumnsNum();
        int firstRow = helper.firstRow();
        int lastRow = firstRow + helper.maxRows() - 1;
        boolean adjustRows = lastRow > gRows - 1 && this.rowsFilled();
        int firstColumn = helper.firstColumn();
        int lastColumn = firstColumn + helper.maxColumns() - 1;
        boolean adjustColumns = lastColumn > gColumns - 1 && this.columnsFilled();
        double bottom = (double)this.rowsRange.diff().intValue() * size.getHeight();
        if (adjustRows) {
            bottom -= size.getHeight();
        }
        ListIterator<GridRow<T, C>> it = new ArrayList<GridRow<T, C>>(this.rows.values()).listIterator(this.size());
        while (it.hasPrevious()) {
            GridRow<T, C> row = it.previous();
            row.layoutCells(bottom, adjustColumns);
            bottom -= size.getHeight();
        }
    }

    public void layoutPaginatedRows() {
        PaginatedVirtualGrid pGrid = (PaginatedVirtualGrid)this.grid;
        GridHelper helper = pGrid.getGridHelper();
        Size size = pGrid.getCellSize();
        int gColumns = pGrid.getColumnsNum();
        int firstRow = helper.firstRow();
        int lastRow = Math.min(firstRow + helper.maxRows() - 1, pGrid.getRowsNum() - 1);
        IntegerRange range = IntegerRange.of((Integer)firstRow, (Integer)lastRow);
        int firstColumn = helper.firstColumn();
        int lastColumn = firstColumn + helper.maxColumns() - 1;
        boolean adjustColumns = lastColumn > gColumns - 1 && this.columnsFilled();
        double pos = 0.0;
        for (int i = firstRow; i <= lastRow; ++i) {
            GridRow<T, C> row = this.rows.get(i);
            row.layoutCells(pos, adjustColumns);
            pos += size.getHeight();
            row.setVisible(true);
        }
        this.rows.entrySet().stream().filter(e -> !IntegerRange.inRangeOf((int)((Integer)e.getKey()), (IntegerRange)range)).forEach(e -> ((GridRow)e.getValue()).setVisible(false));
    }

    protected void addRow(int index) {
        this.rows.put(index, GridRow.of(this.grid, index, this.columnsRange).init());
    }

    protected void addRow(int index, GridRow<T, C> row) {
        this.rows.put(index, row);
    }

    protected void clear() {
        this.rows.values().forEach(GridRow::clear);
        this.rows.clear();
    }

    public List<Node> getNodes() {
        return this.rows.values().stream().flatMap(row -> row.getCells().values().stream()).map(Cell::getNode).collect(Collectors.toUnmodifiableList());
    }

    public List<C> getCells() {
        return this.rows.values().stream().flatMap(row -> row.getCells().values().stream()).collect(Collectors.toList());
    }

    public Map<Integer, C> getIndexedCells() {
        return this.rows.values().stream().flatMap(row -> row.getLinearCells().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean rowsFilled() {
        if (this.grid instanceof PaginatedVirtualGrid) {
            return this.rows.values().stream().allMatch(GridRow::isVisible);
        }
        return this.size() >= this.targetSize;
    }

    public boolean columnsFilled() {
        GridHelper helper = this.grid.getGridHelper();
        int targetColumns = helper.maxColumns();
        return this.rows.values().stream().allMatch(row -> row.size() >= targetColumns);
    }

    public int size() {
        return this.rows.size();
    }

    public int totalSize() {
        return this.rows.values().stream().mapToInt(GridRow::size).sum();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    protected Map<Integer, GridRow<T, C>> getRows() {
        return this.rows;
    }

    public Map<Integer, GridRow<T, C>> getRowsUnmodifiable() {
        return Collections.unmodifiableMap(this.rows);
    }

    public IntegerRange getRowsRange() {
        return this.rowsRange;
    }

    public IntegerRange getColumnsRange() {
        return this.columnsRange;
    }

    public int getTargetSize() {
        return this.targetSize;
    }

    public UpdateType getType() {
        return this.type;
    }

    public boolean haveCellsChanged() {
        return this.cellsChanged;
    }

    protected void cellsChanged() {
        this.cellsChanged = true;
    }
}

