/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.base.beans.Size;
import io.github.palexdev.mfxcore.base.beans.range.NumberRange;
import io.github.palexdev.mfxcore.base.properties.PositionProperty;
import io.github.palexdev.mfxcore.base.properties.functional.FunctionProperty;
import io.github.palexdev.mfxcore.base.properties.functional.SupplierProperty;
import io.github.palexdev.mfxcore.base.properties.range.IntegerRangeProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableSizeProperty;
import io.github.palexdev.mfxcore.collections.ObservableGrid;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.cell.GridCell;
import io.github.palexdev.virtualizedfx.controls.VirtualScrollPane;
import io.github.palexdev.virtualizedfx.grid.GridHelper;
import io.github.palexdev.virtualizedfx.grid.GridManager;
import io.github.palexdev.virtualizedfx.grid.GridState;
import io.github.palexdev.virtualizedfx.grid.VirtualGridSkin;
import io.github.palexdev.virtualizedfx.utils.VSPUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Pair;

public class VirtualGrid<T, C extends GridCell<T>>
extends Control
implements VirtualScrollPane.Wrappable {
    private final String STYLE_CLASS = "virtual-grid";
    private final GridManager<T, C> manager = new GridManager(this);
    private final ObjectProperty<ObservableGrid<T>> items = new SimpleObjectProperty<ObservableGrid<T>>(new ObservableGrid()){

        public void set(ObservableGrid<T> newValue) {
            super.set((Object)(newValue == null ? new ObservableGrid() : newValue));
        }
    };
    private final FunctionProperty<T, C> cellFactory = new FunctionProperty();
    private final PositionProperty position = new PositionProperty(Position.of((double)0.0, (double)0.0)){

        public void set(Position newValue) {
            if (newValue == null) {
                super.set((Object)Position.of((double)0.0, (double)0.0));
                return;
            }
            GridHelper helper = VirtualGrid.this.getGridHelper();
            if (helper == null) {
                super.set((Object)newValue);
                return;
            }
            double x = NumberUtils.clamp((double)newValue.getX(), (double)0.0, (double)helper.maxHScroll());
            double y = NumberUtils.clamp((double)newValue.getY(), (double)0.0, (double)helper.maxVScroll());
            newValue.setX(x);
            newValue.setY(y);
            super.set((Object)newValue);
        }
    };
    private final ReadOnlyObjectWrapper<GridHelper> gridHelper = new ReadOnlyObjectWrapper<GridHelper>(){

        public void set(GridHelper newValue) {
            GridHelper oldValue = (GridHelper)this.get();
            if (oldValue != null) {
                oldValue.dispose();
            }
            super.set((Object)newValue);
        }
    };
    private final SupplierProperty<GridHelper> gridHelperSupplier = new SupplierProperty<GridHelper>(){

        protected void invalidated() {
            GridHelper helper = (GridHelper)((Supplier)this.get()).get();
            VirtualGrid.this.setGridHelper(helper);
        }
    };
    private final ObjectProperty<Size> estimatedSize = new SimpleObjectProperty((Object)Size.of((double)0.0, (double)0.0));
    private final ReadOnlyBooleanWrapper needsViewportLayout = new ReadOnlyBooleanWrapper(false);
    private final StyleableSizeProperty cellSize = new StyleableSizeProperty(StyleableProperties.CELL_SIZE, this, "cellSize", Size.of((double)100.0, (double)100.0)){

        protected void invalidated() {
            VirtualGrid.this.onCellSizeChanged();
        }
    };
    private final StyleableDoubleProperty clipBorderRadius = new StyleableDoubleProperty(StyleableProperties.CLIP_BORDER_RADIUS, (Object)this, "clipBorderRadius", Double.valueOf(0.0));

    public VirtualGrid() {
        this.initialize();
    }

    public VirtualGrid(ObservableGrid<T> items, Function<T, C> cellFactory) {
        this.initialize();
        this.setItems(items);
        this.setCellFactory(cellFactory);
    }

    private void initialize() {
        this.getStyleClass().add((Object)"virtual-grid");
        this.setGridHelperSupplier(() -> new GridHelper.DefaultGridHelper(this));
        this.setGridHelper(this.getGridHelperSupplier().get());
    }

    public void requestViewportLayout() {
        this.setNeedsViewportLayout(true);
    }

    protected void onCellSizeChanged() {
        GridHelper helper = this.getGridHelper();
        helper.computeEstimatedSize();
        if (this.getWidth() != 0.0 && this.getHeight() != 0.0) {
            if (!this.manager.init()) {
                this.requestViewportLayout();
            } else {
                this.setPosition(0.0, 0.0);
            }
        }
    }

    public ObservableGrid<T> init() {
        return this.getItems().init();
    }

    public ObservableGrid<T> init(int rows, int columns) {
        return this.getItems().init(rows, columns);
    }

    public ObservableGrid<T> init(int rows, int columns, T val) {
        return this.getItems().init(rows, columns, val);
    }

    public ObservableGrid<T> init(int rows, int columns, BiFunction<Integer, Integer, T> valFunction) {
        return this.getItems().init(rows, columns, valFunction);
    }

    public int getRowsNum() {
        return this.getItems().getRowsNum();
    }

    public int getColumnsNum() {
        return this.getItems().getColumnsNum();
    }

    public void clear() {
        this.getItems().clear();
    }

    public int totalSize() {
        return this.getItems().totalSize();
    }

    public Pair<Integer, Integer> size() {
        return this.getItems().size();
    }

    public boolean isEmpty() {
        return this.getItems().isEmpty();
    }

    public Size getEstimatedSize() {
        return (Size)this.estimatedSize.get();
    }

    public ReadOnlyObjectProperty<Size> estimatedSizeProperty() {
        return this.estimatedSize;
    }

    public GridState<T, C> getState() {
        return this.manager.getState();
    }

    public ReadOnlyObjectProperty<GridState<T, C>> stateProperty() {
        return this.manager.stateProperty().getReadOnlyProperty();
    }

    public NumberRange<Integer> getLastRowsRange() {
        return this.manager.getLastRowsRange();
    }

    public IntegerRangeProperty lastRowsRangeProperty() {
        return this.manager.lastRowsRangeProperty();
    }

    public NumberRange<Integer> getLastColumnsRange() {
        return this.manager.getLastColumnsRange();
    }

    public IntegerRangeProperty lastColumnsRangeProperty() {
        return this.manager.lastColumnsRangeProperty();
    }

    public Map<Integer, C> getIndexedCells() {
        return this.getState().getIndexedCells();
    }

    public void scrollToFirstRow() {
        this.scrollToRow(0);
    }

    public void scrollToLastRow() {
        this.scrollToRow(this.getItems().getRowsNum() - 1);
    }

    public void scrollToRow(int index) {
        this.getGridHelper().scrollToRow(index);
    }

    public void scrollToFirstColumn() {
        this.scrollToColumn(0);
    }

    public void scrollToLastColumn() {
        this.scrollToColumn(this.getItems().getColumnsNum() - 1);
    }

    public void scrollToColumn(int index) {
        this.getGridHelper().scrollToColumn(index);
    }

    public void scrollBy(double pixels, Orientation orientation) {
        this.getGridHelper().scrollBy(pixels, orientation);
    }

    public void scrollTo(double pixel, Orientation orientation) {
        this.getGridHelper().scrollTo(pixel, orientation);
    }

    protected Skin<?> createDefaultSkin() {
        return new VirtualGridSkin(this);
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return VirtualGrid.getClassCssMetaData();
    }

    @Override
    public VirtualScrollPane wrap() {
        return VSPUtils.wrap(this);
    }

    public Size getCellSize() {
        return (Size)this.cellSize.get();
    }

    public StyleableSizeProperty cellSizeProperty() {
        return this.cellSize;
    }

    public void setCellSize(Size cellSize) {
        this.cellSize.set((Object)cellSize);
    }

    public double getClipBorderRadius() {
        return this.clipBorderRadius.get();
    }

    public StyleableDoubleProperty clipBorderRadiusProperty() {
        return this.clipBorderRadius;
    }

    public void setClipBorderRadius(double clipBorderRadius) {
        this.clipBorderRadius.set(clipBorderRadius);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    protected GridManager<T, C> getViewportManager() {
        return this.manager;
    }

    public ObservableGrid<T> getItems() {
        return (ObservableGrid)this.items.get();
    }

    public ObjectProperty<ObservableGrid<T>> itemsProperty() {
        return this.items;
    }

    public void setItems(ObservableGrid<T> items) {
        this.items.set(items);
    }

    public Function<T, C> getCellFactory() {
        return (Function)this.cellFactory.get();
    }

    public FunctionProperty<T, C> cellFactoryProperty() {
        return this.cellFactory;
    }

    public void setCellFactory(Function<T, C> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    public void setVPos(double vPos) {
        this.setPosition(this.getHPos(), vPos);
    }

    public double getVPos() {
        return this.getPosition().getY();
    }

    public void setHPos(double hPos) {
        this.setPosition(hPos, this.getVPos());
    }

    public double getHPos() {
        return this.getPosition().getX();
    }

    public Position getPosition() {
        return (Position)this.position.get();
    }

    public PositionProperty positionProperty() {
        return this.position;
    }

    public void setPosition(double x, double y) {
        this.setPosition(Position.of((double)x, (double)y));
    }

    public void setPosition(Position position) {
        this.position.set((Object)position);
    }

    public GridHelper getGridHelper() {
        return (GridHelper)this.gridHelper.get();
    }

    public ReadOnlyObjectProperty<GridHelper> gridHelperProperty() {
        return this.gridHelper.getReadOnlyProperty();
    }

    protected void setGridHelper(GridHelper helper) {
        this.gridHelper.set((Object)helper);
    }

    public Supplier<GridHelper> getGridHelperSupplier() {
        return (Supplier)this.gridHelperSupplier.get();
    }

    public SupplierProperty<GridHelper> gridHelperSupplierProperty() {
        return this.gridHelperSupplier;
    }

    public void setGridHelperSupplier(Supplier<GridHelper> gridHelperSupplier) {
        this.gridHelperSupplier.set(gridHelperSupplier);
    }

    public boolean isNeedsViewportLayout() {
        return this.needsViewportLayout.get();
    }

    public ReadOnlyBooleanProperty needsViewportLayoutProperty() {
        return this.needsViewportLayout.getReadOnlyProperty();
    }

    protected void setNeedsViewportLayout(boolean needsViewportLayout) {
        this.needsViewportLayout.set(needsViewportLayout);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<VirtualGrid<?, ?>> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<VirtualGrid<?, ?>, Size> CELL_SIZE;
        private static final CssMetaData<VirtualGrid<?, ?>, Number> CLIP_BORDER_RADIUS;

        private StyleableProperties() {
        }

        static {
            CELL_SIZE = new CssMetaData<VirtualGrid<?, ?>, Size>("-fx-cell-size", StyleableSizeProperty.SizeConverter.getInstance(), Size.of((double)100.0, (double)100.0)){

                public boolean isSettable(VirtualGrid<?, ?> styleable) {
                    return !styleable.cellSizeProperty().isBound();
                }

                public StyleableProperty<Size> getStyleableProperty(VirtualGrid<?, ?> styleable) {
                    return styleable.cellSizeProperty();
                }
            };
            CLIP_BORDER_RADIUS = FACTORY.createSizeCssMetaData("-fx-clip-border-radius", VirtualGrid::clipBorderRadiusProperty, (Number)0.0);
            cssMetaDataList = StyleUtils.cssMetaDataList((List)Control.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{CELL_SIZE, CLIP_BORDER_RADIUS});
        }
    }
}

