/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.beans.range.NumberRange;
import io.github.palexdev.mfxcore.collections.ObservableGrid;
import io.github.palexdev.virtualizedfx.cell.GridCell;
import io.github.palexdev.virtualizedfx.grid.GridHelper;
import io.github.palexdev.virtualizedfx.grid.GridManager;
import io.github.palexdev.virtualizedfx.grid.GridState;
import io.github.palexdev.virtualizedfx.grid.VirtualGrid;
import java.util.List;
import java.util.function.Function;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;

public class VirtualGridSkin<T, C extends GridCell<T>>
extends SkinBase<VirtualGrid<T, C>> {
    protected final Pane viewport;
    private final Rectangle clip;
    protected GridManager<T, C> manager;
    private final double DEFAULT_SIZE = 100.0;
    private ChangeListener<? super ObservableGrid.Change<T>> itemsChanged;
    private ChangeListener<? super ObservableGrid<T>> gridChanged;
    private ChangeListener<? super Function<T, C>> factoryChanged;
    private ChangeListener<? super GridState<T, C>> stateChanged;
    private ChangeListener<? super GridHelper> helperChanged;
    private ChangeListener<? super Boolean> layoutRequestListener;

    public VirtualGridSkin(final VirtualGrid<T, C> grid) {
        super(grid);
        this.manager = grid.getViewportManager();
        this.viewport = new Pane(){

            protected void layoutChildren() {
                GridHelper helper = grid.getGridHelper();
                if (helper == null) {
                    throw new IllegalStateException("GridHelper is null, cannot proceed with layout");
                }
                if (!grid.isNeedsViewportLayout()) {
                    return;
                }
                if (helper.invalidatedPos()) {
                    return;
                }
                GridState state = grid.getState();
                state.layoutRows();
                grid.setNeedsViewportLayout(false);
            }
        };
        this.viewport.getStyleClass().add((Object)"viewport");
        this.clip = new Rectangle();
        this.clip.widthProperty().bind((ObservableValue)grid.widthProperty());
        this.clip.heightProperty().bind((ObservableValue)grid.heightProperty());
        this.clip.arcWidthProperty().bind((ObservableValue)grid.clipBorderRadiusProperty());
        this.clip.arcHeightProperty().bind((ObservableValue)grid.clipBorderRadiusProperty());
        grid.setClip((Node)this.clip);
        this.gridChanged = (observable, oldValue, newValue) -> this.onGridChanged((ObservableGrid<T>)oldValue, (ObservableGrid<T>)newValue);
        this.itemsChanged = (observable, oldValue, newValue) -> this.onItemsChanged((ObservableGrid.Change<T>)newValue);
        this.factoryChanged = (observable, oldValue, newValue) -> this.onFactoryChanged((Function<T, C>)newValue);
        this.stateChanged = (observable, oldValue, newValue) -> this.onStateChanged((GridState<T, C>)oldValue, (GridState<T, C>)newValue);
        this.helperChanged = (observable, oldValue, newValue) -> this.onHelperChanged((GridHelper)newValue);
        this.layoutRequestListener = (observable, oldValue, newValue) -> this.onLayoutRequest((boolean)newValue);
        GridHelper helper = grid.getGridHelper();
        this.viewport.translateXProperty().bind((ObservableValue)helper.xPosBinding());
        this.viewport.translateYProperty().bind((ObservableValue)helper.yPosBinding());
        helper.computeEstimatedSize();
        this.getChildren().setAll((Object[])new Node[]{this.viewport});
        this.addListeners();
    }

    private void addListeners() {
        VirtualGrid virtualGrid = (VirtualGrid)this.getSkinnable();
        virtualGrid.getItems().addListener(this.itemsChanged);
        virtualGrid.itemsProperty().addListener(this.gridChanged);
        virtualGrid.cellFactoryProperty().addListener(this.factoryChanged);
        virtualGrid.stateProperty().addListener(this.stateChanged);
        virtualGrid.gridHelperProperty().addListener(this.helperChanged);
        virtualGrid.needsViewportLayoutProperty().addListener(this.layoutRequestListener);
    }

    protected void onItemsChanged(ObservableGrid.Change<T> change) {
        VirtualGrid grid = (VirtualGrid)this.getSkinnable();
        this.manager.onChange(change);
        GridHelper helper = grid.getGridHelper();
        helper.computeEstimatedSize();
    }

    protected void onGridChanged(ObservableGrid<T> oldValue, ObservableGrid<T> newValue) {
        if (oldValue != null) {
            oldValue.removeListener(this.itemsChanged);
        }
        if (newValue != null) {
            newValue.addListener(this.itemsChanged);
            this.manager.reset();
        }
    }

    protected void onFactoryChanged(Function<T, C> newValue) {
        if (newValue == null) {
            throw new IllegalStateException("The new provided cell factory is null, you will encounter problems");
        }
        this.manager.reset();
        this.manager.setLastRowsRange((NumberRange<Integer>)IntegerRange.of((Integer)-1));
        this.manager.setLastColumnsRange((NumberRange<Integer>)IntegerRange.of((Integer)-1));
    }

    protected void onStateChanged(GridState<T, C> oldValue, GridState<T, C> newValue) {
        if (newValue == GridState.EMPTY) {
            this.viewport.getChildren().clear();
            return;
        }
        if (newValue.haveCellsChanged()) {
            List<Node> nodes = newValue.getNodes();
            this.viewport.getChildren().setAll(nodes);
        }
    }

    protected void onHelperChanged(GridHelper newValue) {
        if (newValue == null) {
            throw new IllegalStateException("The new provided GridHelper is null, you will encounter problems");
        }
        this.viewport.translateXProperty().bind((ObservableValue)newValue.xPosBinding());
        this.viewport.translateYProperty().bind((ObservableValue)newValue.yPosBinding());
    }

    protected void onLayoutRequest(boolean newValue) {
        if (newValue) {
            this.viewport.requestLayout();
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + 100.0 + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + 100.0 + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        VirtualGrid virtualGrid = (VirtualGrid)this.getSkinnable();
        return leftInset + (double)virtualGrid.getColumnsNum() * virtualGrid.getCellSize().getWidth() + rightInset;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        VirtualGrid virtualGrid = (VirtualGrid)this.getSkinnable();
        return topInset + (double)virtualGrid.getRowsNum() * virtualGrid.getCellSize().getHeight() + bottomInset;
    }

    public void dispose() {
        VirtualGrid virtualGrid = (VirtualGrid)this.getSkinnable();
        virtualGrid.getItems().removeListener(this.itemsChanged);
        virtualGrid.itemsProperty().removeListener(this.gridChanged);
        virtualGrid.cellFactoryProperty().removeListener(this.factoryChanged);
        virtualGrid.stateProperty().removeListener(this.stateChanged);
        virtualGrid.gridHelperProperty().removeListener(this.helperChanged);
        virtualGrid.needsViewportLayoutProperty().removeListener(this.layoutRequestListener);
        this.itemsChanged = null;
        this.gridChanged = null;
        this.factoryChanged = null;
        this.stateChanged = null;
        this.helperChanged = null;
        this.layoutRequestListener = null;
        this.manager = null;
        super.dispose();
    }
}

