/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid.paginated;

import io.github.palexdev.virtualizedfx.grid.GridHelper;
import io.github.palexdev.virtualizedfx.grid.paginated.PaginatedVirtualGrid;
import javafx.geometry.Orientation;

public interface PaginatedHelper
extends GridHelper {
    public double pageToPos(int var1);

    public void goToPage(int var1);

    public static class PaginatedGridHelper
    extends GridHelper.DefaultGridHelper
    implements PaginatedHelper {
        protected PaginatedVirtualGrid<?, ?> pGrid;

        public PaginatedGridHelper(PaginatedVirtualGrid<?, ?> virtualGrid) {
            super(virtualGrid);
            this.pGrid = virtualGrid;
        }

        @Override
        public int maxRows() {
            return this.pGrid.getRowsPerPage();
        }

        @Override
        public double maxVScroll() {
            return this.pageToPos(this.pGrid.getMaxPage());
        }

        @Override
        public double pageToPos(int page) {
            return (double)((page - 1) * this.pGrid.getRowsPerPage()) * this.pGrid.getCellSize().getHeight();
        }

        @Override
        public void goToPage(int page) {
            super.scrollTo(this.pageToPos(page), Orientation.VERTICAL);
        }

        @Override
        public void scrollBy(double pixels, Orientation orientation) {
            throw new UnsupportedOperationException("The paginated grid cannot scroll by a given amount of pixels");
        }

        @Override
        public void scrollTo(double pixel, Orientation orientation) {
            throw new UnsupportedOperationException("The paginated grid cannot scroll to a given pixel position as it may be wrong");
        }

        @Override
        public void scrollToRow(int index) {
            throw new UnsupportedOperationException("The paginated grid cannot scroll to a given row index");
        }

        @Override
        public void dispose() {
            super.dispose();
            this.pGrid = null;
        }
    }
}

