/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid.paginated;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableIntegerProperty;
import io.github.palexdev.mfxcore.collections.ObservableGrid;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.cell.GridCell;
import io.github.palexdev.virtualizedfx.controls.VirtualScrollPane;
import io.github.palexdev.virtualizedfx.grid.GridHelper;
import io.github.palexdev.virtualizedfx.grid.VirtualGrid;
import io.github.palexdev.virtualizedfx.grid.paginated.PaginatedHelper;
import io.github.palexdev.virtualizedfx.grid.paginated.PaginatedVirtualGridSkin;
import io.github.palexdev.virtualizedfx.utils.VSPUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.control.Skin;

public class PaginatedVirtualGrid<T, C extends GridCell<T>>
extends VirtualGrid<T, C> {
    private final String STYLE_CLASS = "paginated-virtual-grid";
    private final IntegerProperty currentPage = new SimpleIntegerProperty(1){

        public void set(int newValue) {
            int clamped = NumberUtils.clamp((int)newValue, (int)1, (int)PaginatedVirtualGrid.this.getMaxPage());
            super.set(clamped);
        }

        protected void invalidated() {
            int page = this.get();
            PaginatedVirtualGrid.this.changePage(page);
        }
    };
    private final ReadOnlyIntegerWrapper maxPage = new ReadOnlyIntegerWrapper(){

        public void set(int newValue) {
            int clamped = Math.max(1, newValue);
            super.set(clamped);
        }

        protected void invalidated() {
            int max = this.get();
            int curr = NumberUtils.clamp((int)PaginatedVirtualGrid.this.getCurrentPage(), (int)1, (int)max);
            PaginatedVirtualGrid.this.setCurrentPage(curr);
        }
    };
    private final StyleableIntegerProperty rowsPerPage = new StyleableIntegerProperty(StyleableProperties.ROWS_PER_PAGE, this, "rowsPerPage", 5){

        protected void invalidated() {
            PaginatedVirtualGrid.this.updateMaxPage();
            PaginatedVirtualGrid.this.changePage(PaginatedVirtualGrid.this.getCurrentPage());
            PaginatedVirtualGrid.this.requestViewportLayout();
        }
    };

    public PaginatedVirtualGrid() {
        this.initialize();
    }

    public PaginatedVirtualGrid(ObservableGrid<T> items, Function<T, C> cellFactory) {
        super(items, cellFactory);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"paginated-virtual-grid");
        this.setGridHelperSupplier(() -> new PaginatedHelper.PaginatedGridHelper(this));
    }

    public void goToPage(int page) {
        this.setCurrentPage(page);
    }

    public void goToFirstPage() {
        this.goToPage(1);
    }

    public void goToLastPage() {
        this.goToPage(this.getMaxPage());
    }

    public void updateMaxPage() {
        int rows = this.getRowsNum();
        int rpp = this.getRowsPerPage();
        int max = (int)Math.ceil((double)rows / (double)rpp);
        this.setMaxPage(max);
    }

    protected void changePage(int page) {
        GridHelper helper = this.getGridHelper();
        if (!(helper instanceof PaginatedHelper)) {
            throw new IllegalStateException("The grid's helper is not of type PaginatedHelper!");
        }
        this.updateMaxPage();
        PaginatedHelper pHelper = (PaginatedHelper)helper;
        pHelper.goToPage(page);
    }

    public IntegerRange getRowsRange() {
        return Optional.ofNullable(this.getGridHelper()).map(h -> {
            int firstRow = h.firstRow();
            int lastRow = Math.min(firstRow + h.maxRows() - 1, this.getRowsNum() - 1);
            return IntegerRange.of((Integer)firstRow, (Integer)lastRow);
        }).orElseGet(() -> IntegerRange.of((Integer)-1));
    }

    public Map<Integer, C> getIndexedVisibleCells() {
        IntegerRange range = this.getRowsRange();
        if (IntegerRange.of((Integer)-1).equals((Object)range)) {
            return Map.of();
        }
        return this.getIndexedCells().entrySet().stream().filter(e -> IntegerRange.inRangeOf((int)((Integer)e.getKey()), (IntegerRange)range)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void scrollToFirstRow() {
        throw new UnsupportedOperationException("The paginated grid cannot scroll to a desired row");
    }

    @Override
    public void scrollToLastRow() {
        throw new UnsupportedOperationException("The paginated grid cannot scroll to a desired row");
    }

    @Override
    protected void onCellSizeChanged() {
        GridHelper helper = this.getGridHelper();
        if (helper != null) {
            helper.computeEstimatedSize();
        }
        if (this.getWidth() != 0.0 && this.getHeight() != 0.0) {
            if (!this.getViewportManager().init()) {
                this.requestViewportLayout();
            } else {
                this.goToPage(1);
                this.scrollToColumn(0);
            }
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new PaginatedVirtualGridSkin(this);
    }

    @Override
    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return PaginatedVirtualGrid.getClassCssMetaData();
    }

    @Override
    public VirtualScrollPane wrap() {
        return VSPUtils.wrap(this);
    }

    public int getRowsPerPage() {
        return this.rowsPerPage.get();
    }

    public StyleableIntegerProperty rowsPerPageProperty() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage.set(rowsPerPage);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public int getCurrentPage() {
        return this.currentPage.get();
    }

    public IntegerProperty currentPageProperty() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage.set(currentPage);
    }

    public int getMaxPage() {
        return this.maxPage.get();
    }

    public ReadOnlyIntegerProperty maxPageProperty() {
        return this.maxPage.getReadOnlyProperty();
    }

    protected void setMaxPage(int maxPage) {
        this.maxPage.set(maxPage);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<PaginatedVirtualGrid<?, ?>> FACTORY = new StyleablePropertyFactory(VirtualGrid.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<PaginatedVirtualGrid<?, ?>, Number> ROWS_PER_PAGE;

        private StyleableProperties() {
        }

        static {
            ROWS_PER_PAGE = FACTORY.createSizeCssMetaData("-fx-rows-per-page", PaginatedVirtualGrid::rowsPerPageProperty, (Number)5);
            cssMetaDataList = StyleUtils.cssMetaDataList(VirtualGrid.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{ROWS_PER_PAGE});
        }
    }
}

