/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid.paginated;

import io.github.palexdev.mfxcore.collections.ObservableGrid;
import io.github.palexdev.mfxcore.utils.fx.NodeUtils;
import io.github.palexdev.virtualizedfx.cell.GridCell;
import io.github.palexdev.virtualizedfx.grid.VirtualGridSkin;
import io.github.palexdev.virtualizedfx.grid.paginated.PaginatedVirtualGrid;

public class PaginatedVirtualGridSkin<T, C extends GridCell<T>>
extends VirtualGridSkin<T, C> {
    public PaginatedVirtualGridSkin(PaginatedVirtualGrid<T, C> virtualGrid) {
        super(virtualGrid);
        NodeUtils.waitForScene(virtualGrid, virtualGrid::updateMaxPage, (boolean)false, (boolean)true);
    }

    protected PaginatedVirtualGrid<T, C> getGrid() {
        return (PaginatedVirtualGrid)this.getSkinnable();
    }

    protected double getLength() {
        PaginatedVirtualGrid<T, C> grid = this.getGrid();
        return (double)grid.getRowsPerPage() * grid.getCellSize().getHeight();
    }

    @Override
    protected void onGridChanged(ObservableGrid<T> oldValue, ObservableGrid<T> newValue) {
        this.getGrid().updateMaxPage();
        super.onGridChanged(oldValue, newValue);
    }

    @Override
    protected void onItemsChanged(ObservableGrid.Change<T> change) {
        this.getGrid().updateMaxPage();
        super.onItemsChanged(change);
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.getLength();
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.getLength();
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.getLength();
    }
}

