/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table;

import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TableCache<T> {
    private final VirtualTable<T> table;
    private final Map<TableColumn<T, ? extends TableCell<T>>, Set<TableCell<T>>> cache = new HashMap<TableColumn<T, ? extends TableCell<T>>, Set<TableCell<T>>>();

    public TableCache(VirtualTable<T> table) {
        this.table = table;
    }

    @SafeVarargs
    public final TableCache<T> cache(TableColumn<T, ? extends TableCell<T>> column, TableCell<T> ... cells) {
        if (cells.length == 0) {
            return this;
        }
        Set cached = this.cache.computeIfAbsent(column, c -> new HashSet());
        Collections.addAll(cached, cells);
        return this;
    }

    public TableCache<T> cache(TableColumn<T, ? extends TableCell<T>> column, Collection<TableCell<T>> cells) {
        if (cells.isEmpty()) {
            return this;
        }
        Set cached = this.cache.computeIfAbsent(column, c -> new HashSet());
        cached.addAll(cells);
        return this;
    }

    public TableCell<T> take(TableColumn<T, ? extends TableCell<T>> column) {
        return Optional.ofNullable(this.cache.get(column)).map(s -> {
            if (s.isEmpty()) {
                return null;
            }
            Iterator it = s.iterator();
            TableCell cell = (TableCell)it.next();
            it.remove();
            return cell;
        }).orElse(null);
    }

    public Optional<TableCell<T>> tryTake(TableColumn<T, ? extends TableCell<T>> column) {
        return Optional.ofNullable(this.cache.get(column)).map(s -> {
            if (s.isEmpty()) {
                return null;
            }
            Iterator it = s.iterator();
            TableCell cell = (TableCell)it.next();
            it.remove();
            return cell;
        });
    }

    public TableCache<T> remove(TableColumn<T, ? extends TableCell<T>> column, TableCell<T> cell) {
        Optional.ofNullable(this.cache.get(column)).ifPresent(cells -> {
            cells.remove(cell);
            if (cells.isEmpty()) {
                this.cache.remove(column);
            }
        });
        return this;
    }

    public TableCache<T> clear() {
        this.cache.values().stream().flatMap(Collection::stream).forEach(Cell::dispose);
        this.cache.clear();
        return this;
    }

    public TableCache<T> clear(TableColumn<T, ? extends TableCell<T>> column) {
        Set<TableCell<TableCell>> removed = this.cache.remove(column);
        if (removed != null) {
            removed.forEach(Cell::dispose);
        }
        return this;
    }

    public VirtualTable<T> getTable() {
        return this.table;
    }

    public Map<TableColumn<T, ? extends TableCell<T>>, Set<TableCell<T>>> getCacheUnmodifiable() {
        return Collections.unmodifiableMap(this.cache);
    }
}

