/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.base.beans.Size;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.properties.SizeProperty;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.LayoutUtils;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.TableManager;
import io.github.palexdev.virtualizedfx.table.TableRow;
import io.github.palexdev.virtualizedfx.table.TableState;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public interface TableHelper {
    public int firstRow();

    public int firstColumn();

    public int lastRow();

    public int lastColumn();

    public int maxRows();

    public int maxColumns();

    public IntegerRange rowsRange();

    public IntegerRange columnsRange();

    public double maxVScroll();

    public double maxHScroll();

    public Size computeEstimatedSize();

    public ReadOnlyObjectProperty<Size> estimatedSizeProperty();

    public boolean isLayoutInitialized();

    public ReadOnlyBooleanProperty layoutInitializedProperty();

    public double getViewportHeight();

    public DoubleBinding xPosBinding();

    public double horizontalOffset();

    public DoubleBinding yPosBinding();

    public double verticalOffset();

    public boolean invalidatedPos();

    public void scrollToRow(int var1);

    public void scrollToColumn(int var1);

    public void scrollBy(double var1, Orientation var3);

    public void scrollTo(double var1, Orientation var3);

    public void autosizeColumn(TableColumn<?, ? extends TableCell<?>> var1);

    public void autosizeColumns();

    public Map<Orientation, List<Double>> computePositions(TableState<?> var1, boolean var2, boolean var3);

    public void layout();

    public void dispose();

    public static class VariableTableHelper
    extends FixedTableHelper {
        public VariableTableHelper(VirtualTable<?> table) {
            super(table);
        }

        @Override
        public int firstColumn() {
            return Math.min(0, this.table.getColumns().size() - 1);
        }

        @Override
        public int lastColumn() {
            return this.table.getColumns().size() - 1;
        }

        @Override
        public int maxColumns() {
            return this.table.getColumns().size();
        }

        @Override
        public IntegerRange columnsRange() {
            if (this.table.getColumns().isEmpty()) {
                return IntegerRange.of((Integer)-1);
            }
            return IntegerRange.of((Integer)this.firstColumn(), (Integer)this.lastColumn());
        }

        @Override
        public DoubleBinding xPosBinding() {
            if (this.xPosBinding == null) {
                this.xPosBinding = Bindings.createDoubleBinding(() -> -this.table.getHPos(), (Observable[])new Observable[]{this.table.positionProperty()});
            }
            return this.xPosBinding;
        }

        @Override
        public void scrollToColumn(int index) {
            TableColumn column = this.table.getColumn(index);
            Region region = column.getRegion();
            if (this.table.getSkin() == null || region.getScene() == null || region.getWidth() <= 0.0) {
                super.scrollToColumn(index);
            }
            double minX = region.getBoundsInParent().getMinX();
            double clampedVal = NumberUtils.clamp((double)minX, (double)0.0, (double)this.maxHScroll());
            this.table.setHPos(clampedVal);
        }

        @Override
        public void autosizeColumn(TableColumn<?, ? extends TableCell<?>> column) {
            TableState state = this.table.getState();
            if (state.isEmptyAll()) {
                return;
            }
            double extra = this.table.getExtraAutosizeWidth();
            Region region = column.getRegion();
            ObservableList columns = this.table.getColumns();
            int cIndex = this.table.getColumnIndex(column);
            Collection rows = state.getRows().values();
            double targetW = rows.stream().mapToDouble(r -> r.getWidthOf(cIndex)).max().orElseGet(() -> ((Region)region).getWidth());
            if (cIndex == columns.size() - 1) {
                double colW = LayoutUtils.boundWidth((Node)region);
                double totalW = columns.stream().map(TableColumn::getRegion).mapToDouble(Region::getWidth).sum() - colW;
                if (totalW < this.table.getWidth()) {
                    targetW = Math.max(targetW, this.table.getWidth() - totalW);
                    region.setPrefWidth(targetW);
                    this.computeEstimatedSize();
                    this.computePositions(state, true, false);
                    this.layout();
                    return;
                }
            }
            region.setPrefWidth(targetW + extra);
            this.computeEstimatedSize();
            this.computePositions(state, true, false);
            this.layout();
        }

        @Override
        public void autosizeColumns() {
            this.table.getColumns().forEach(this::autosizeColumn);
        }

        @Override
        public Map<Orientation, List<Double>> computePositions(TableState<?> state, boolean forceXComputation, boolean forceYComputation) {
            if (state.isEmptyAll()) {
                return this.positions;
            }
            IntegerRange rowsRange = state.getRowsRange();
            IntegerRange columnsRange = state.getColumnsRange();
            double cellH = this.table.getCellHeight();
            List xPositions = this.positions.computeIfAbsent(Orientation.HORIZONTAL, o -> new ArrayList());
            if (forceXComputation || xPositions.isEmpty() || xPositions.size() != columnsRange.diff() + 1) {
                xPositions.clear();
                double pos = 0.0;
                for (Integer cIndex : columnsRange) {
                    TableColumn column = this.table.getColumn(cIndex);
                    Region region = column.getRegion();
                    xPositions.add(pos);
                    double colW = LayoutUtils.boundWidth((Node)region);
                    pos += colW;
                }
            }
            List yPositions = this.positions.computeIfAbsent(Orientation.VERTICAL, o -> new ArrayList());
            Integer rRangeDiff = rowsRange.diff();
            if (!state.isEmpty() && (forceYComputation || yPositions.isEmpty() || yPositions.size() != rRangeDiff + 1)) {
                yPositions.clear();
                yPositions.addAll(DoubleStream.iterate((double)rRangeDiff.intValue() * cellH, x -> x - cellH).limit(rRangeDiff + 1).boxed().collect(Collectors.toList()));
            }
            return this.positions;
        }

        @Override
        public void layout() {
            TableState state = this.table.getState();
            if (state.isEmptyAll()) {
                this.layoutInitialized.set(false);
                return;
            }
            if (!this.table.isNeedsViewportLayout() || this.invalidatedPos()) {
                return;
            }
            Map<Orientation, List<Double>> positions = this.computePositions(state, false, false);
            double colH = this.table.getColumnSize().getHeight();
            IntegerRange columnsRange = state.getColumnsRange();
            List<Double> xPositions = positions.get(Orientation.HORIZONTAL);
            int xI = 0;
            double totalW = 0.0;
            for (Integer cIndex : columnsRange) {
                TableColumn column = this.table.getColumn(cIndex);
                Region region = column.getRegion();
                double colW = LayoutUtils.boundWidth((Node)region);
                Double xPos = xPositions.get(xI);
                totalW += colW;
                if (cIndex.equals(columnsRange.getMax()) && totalW < this.table.getWidth()) {
                    region.resizeRelocate(xPos.doubleValue(), 0.0, this.table.getWidth() - totalW + colW, colH);
                } else {
                    region.resizeRelocate(xPos.doubleValue(), 0.0, colW, colH);
                }
                ++xI;
            }
            if (!state.isEmpty()) {
                double cellH = this.table.getCellHeight();
                double yOffset = this.verticalOffset();
                List<Double> yPositions = positions.get(Orientation.VERTICAL);
                int yI = yPositions.size() - 1;
                for (TableRow row : state.getRows().values()) {
                    xI = 0;
                    Double yPos = yPositions.get(yI);
                    double rowW = this.table.getEstimatedSize().getWidth();
                    row.resizeRelocate(0.0, yPos + yOffset, rowW, cellH);
                    ArrayList cells = new ArrayList(row.getCells().values());
                    for (int i = 0; i < cells.size(); ++i) {
                        TableCell cell = (TableCell)cells.get(i);
                        TableColumn column = this.table.getColumn(i);
                        Node node = cell.getNode();
                        cell.beforeLayout();
                        node.resizeRelocate(xPositions.get(xI).doubleValue(), 0.0, column.getRegion().getWidth(), cellH);
                        cell.afterLayout();
                        ++xI;
                    }
                    --yI;
                }
                this.layoutInitialized.set(totalW > 0.0);
            }
        }
    }

    public static class FixedTableHelper
    extends AbstractHelper {
        protected final Map<Orientation, List<Double>> positions = new HashMap<Orientation, List<Double>>();

        public FixedTableHelper(VirtualTable<?> table) {
            super(table);
        }

        @Override
        public int firstRow() {
            return NumberUtils.clamp((int)((int)Math.floor(this.table.getVPos() / this.table.getCellHeight())), (int)0, (int)(this.table.getItems().size() - 1));
        }

        @Override
        public int lastRow() {
            return NumberUtils.clamp((int)(this.firstRow() + this.maxRows() - 1), (int)0, (int)(this.table.getItems().size() - 1));
        }

        @Override
        public int firstColumn() {
            return NumberUtils.clamp((int)((int)Math.floor(this.table.getHPos() / this.table.getColumnSize().getWidth())), (int)0, (int)(this.table.getColumns().size() - 1));
        }

        @Override
        public int lastColumn() {
            return NumberUtils.clamp((int)(this.firstColumn() + this.maxColumns() - 1), (int)0, (int)(this.table.getColumns().size() - 1));
        }

        @Override
        public int maxRows() {
            return (int)(Math.ceil(this.getViewportHeight() / this.table.getCellHeight()) + 1.0);
        }

        @Override
        public int maxColumns() {
            return (int)(Math.ceil(this.table.getWidth() / this.table.getColumnSize().getWidth()) + 1.0);
        }

        @Override
        public IntegerRange rowsRange() {
            int rNum = Math.min(this.maxRows(), this.table.getItems().size());
            int last = this.lastRow();
            int first = Math.max(0, last - rNum + 1);
            return IntegerRange.of((Integer)first, (Integer)last);
        }

        @Override
        public IntegerRange columnsRange() {
            if (this.table.getColumns().isEmpty()) {
                return IntegerRange.of((Integer)-1);
            }
            int cNum = Math.min(this.maxColumns(), this.table.getColumns().size());
            int last = this.lastColumn();
            int first = Math.max(0, last - cNum + 1);
            return IntegerRange.of((Integer)first, (Integer)last);
        }

        @Override
        public double maxVScroll() {
            return this.estimatedSize.getHeight() - this.getViewportHeight();
        }

        @Override
        public double maxHScroll() {
            return this.estimatedSize.getWidth() - this.table.getWidth();
        }

        @Override
        public Size computeEstimatedSize() {
            double cellHeight = this.table.getCellHeight();
            double length = (double)this.table.getItems().size() * cellHeight;
            double breadth = this.table.getColumns().stream().mapToDouble(c -> c.getRegion().getWidth()).sum();
            Size size = Size.of((double)breadth, (double)length);
            this.estimatedSize.set((Object)size);
            return size;
        }

        @Override
        public DoubleBinding xPosBinding() {
            if (this.xPosBinding == null) {
                this.xPosBinding = Bindings.createDoubleBinding(() -> -this.table.getHPos() % this.table.getColumnSize().getWidth(), (Observable[])new Observable[]{this.table.positionProperty(), this.table.columnSizeProperty()});
            }
            return this.xPosBinding;
        }

        @Override
        public DoubleBinding yPosBinding() {
            if (this.yPosBinding == null) {
                this.yPosBinding = Bindings.createDoubleBinding(() -> -this.table.getVPos() % this.table.getCellHeight(), (Observable[])new Observable[]{this.table.positionProperty(), this.table.cellHeightProperty()});
            }
            return this.yPosBinding;
        }

        @Override
        public void scrollToRow(int index) {
            double val = (double)index * this.table.getCellHeight();
            double clampedVal = NumberUtils.clamp((double)val, (double)0.0, (double)this.maxVScroll());
            this.table.setVPos(clampedVal);
        }

        @Override
        public void scrollToColumn(int index) {
            double val = (double)index * this.table.getColumnSize().getWidth();
            double clampedVal = NumberUtils.clamp((double)val, (double)0.0, (double)this.maxHScroll());
            this.table.setHPos(clampedVal);
        }

        @Override
        public void scrollBy(double pixels, Orientation orientation) {
            if (orientation == Orientation.VERTICAL) {
                double newVal = NumberUtils.clamp((double)(this.table.getVPos() + pixels), (double)0.0, (double)this.maxVScroll());
                this.table.setVPos(newVal);
            } else {
                double newVal = NumberUtils.clamp((double)(this.table.getHPos() + pixels), (double)0.0, (double)this.maxHScroll());
                this.table.setHPos(newVal);
            }
        }

        @Override
        public void scrollTo(double pixel, Orientation orientation) {
            if (orientation == Orientation.VERTICAL) {
                double clampedVal = NumberUtils.clamp((double)pixel, (double)0.0, (double)this.maxVScroll());
                this.table.setVPos(clampedVal);
            } else {
                double clampedVal = NumberUtils.clamp((double)pixel, (double)0.0, (double)this.maxHScroll());
                this.table.setHPos(clampedVal);
            }
        }

        @Override
        public void autosizeColumn(TableColumn<?, ? extends TableCell<?>> column) {
            throw new UnsupportedOperationException("Fixed Layout Mode for columns doesn't support columns auto-sizing");
        }

        @Override
        public void autosizeColumns() {
            throw new UnsupportedOperationException("Fixed Layout Mode for columns doesn't support columns auto-sizing");
        }

        @Override
        public Map<Orientation, List<Double>> computePositions(TableState<?> state, boolean forceXComputation, boolean forceYComputation) {
            IntegerRange rowsRange = state.getRowsRange();
            IntegerRange columnsRange = state.getColumnsRange();
            double colW = this.table.getColumnSize().getWidth();
            double cellH = this.table.getCellHeight();
            List xPositions = this.positions.computeIfAbsent(Orientation.HORIZONTAL, o -> new ArrayList());
            Integer cRangeDiff = columnsRange.diff();
            if (forceXComputation || xPositions.isEmpty() || xPositions.size() != cRangeDiff + 1) {
                xPositions.clear();
                xPositions.addAll(DoubleStream.iterate((double)cRangeDiff.intValue() * colW, x -> x - colW).limit(cRangeDiff + 1).boxed().collect(Collectors.toList()));
            }
            List yPositions = this.positions.computeIfAbsent(Orientation.VERTICAL, o -> new ArrayList());
            Integer rRangeDiff = rowsRange.diff();
            if (forceYComputation || yPositions.isEmpty() || yPositions.size() != rRangeDiff + 1) {
                yPositions.clear();
                yPositions.addAll(DoubleStream.iterate((double)rRangeDiff.intValue() * cellH, x -> x - cellH).limit(rRangeDiff + 1).boxed().collect(Collectors.toList()));
            }
            return this.positions;
        }

        @Override
        public void layout() {
            TableState state = this.table.getState();
            if (state.isEmptyAll()) {
                this.layoutInitialized.set(false);
                return;
            }
            if (!this.table.isNeedsViewportLayout() || this.invalidatedPos()) {
                return;
            }
            Map<Orientation, List<Double>> positions = this.computePositions(state, false, false);
            double colW = this.table.getColumnSize().getWidth();
            double colH = this.table.getColumnSize().getHeight();
            IntegerRange columnsRange = state.getColumnsRange();
            double xOffset = this.horizontalOffset();
            List<Double> xPositions = positions.get(Orientation.HORIZONTAL);
            int xI = xPositions.size() - 1;
            double totalW = 0.0;
            for (Integer cIndex : columnsRange) {
                totalW += colW;
                TableColumn column = this.table.getColumn(cIndex);
                Region region = column.getRegion();
                Double xPos = xPositions.get(xI);
                if (cIndex.equals(columnsRange.getMax()) && totalW < this.table.getWidth()) {
                    region.resizeRelocate(xPos + xOffset, 0.0, this.table.getWidth() - totalW + colW, colH);
                } else {
                    region.resizeRelocate(xPos + xOffset, 0.0, colW, colH);
                }
                --xI;
            }
            if (!state.isEmpty()) {
                double cellH = this.table.getCellHeight();
                double yOffset = this.verticalOffset();
                List<Double> yPositions = positions.get(Orientation.VERTICAL);
                int yI = yPositions.size() - 1;
                for (TableRow row : state.getRows().values()) {
                    xI = xPositions.size() - 1;
                    Double yPos = yPositions.get(yI);
                    double rowW = this.table.getEstimatedSize().getWidth();
                    row.resizeRelocate(xOffset, yPos + yOffset, rowW, cellH);
                    ArrayList cells = new ArrayList(row.getCells().values());
                    for (int i = 0; i < cells.size(); ++i) {
                        TableCell cell = (TableCell)cells.get(i);
                        TableColumn column = this.table.getColumn(i);
                        Node node = cell.getNode();
                        cell.beforeLayout();
                        node.resizeRelocate(xPositions.get(xI).doubleValue(), 0.0, column.getRegion().getWidth(), cellH);
                        cell.afterLayout();
                        --xI;
                    }
                    --yI;
                }
                this.layoutInitialized.set(totalW > 0.0);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.xPosBinding != null) {
                this.xPosBinding.dispose();
            }
            if (this.yPosBinding != null) {
                this.yPosBinding.dispose();
            }
            this.xPosBinding = null;
            this.yPosBinding = null;
        }
    }

    public static abstract class AbstractHelper
    implements TableHelper {
        protected final VirtualTable<?> table;
        protected final TableManager<?> manager;
        protected ChangeListener<? super Number> widthListener;
        protected ChangeListener<? super Number> heightListener;
        protected ChangeListener<? super Position> positionListener;
        protected final SizeProperty estimatedSize = new SizeProperty(Size.of((double)0.0, (double)0.0));
        protected final ReadOnlyBooleanWrapper layoutInitialized = new ReadOnlyBooleanWrapper(false);
        protected DoubleBinding xPosBinding;
        protected DoubleBinding yPosBinding;

        public AbstractHelper(VirtualTable<?> table) {
            this.table = table;
            this.manager = table.getViewportManager();
            this.widthListener = (o, ov, nv) -> this.onWidthChanged((Number)ov, (Number)nv);
            this.heightListener = (o, ov, nv) -> this.onHeightChanged((Number)ov, (Number)nv);
            this.positionListener = (o, ov, nv) -> this.onPositionChanged((Position)ov, (Position)nv);
            table.widthProperty().addListener(this.widthListener);
            table.heightProperty().addListener(this.heightListener);
            table.positionProperty().addListener(this.positionListener);
            ((SizeProperty)table.estimatedSizeProperty()).bind((ObservableValue)this.estimatedSize);
        }

        protected void onWidthChanged(Number ov, Number nv) {
            double val = nv.doubleValue();
            if (val > 0.0 && this.table.getHeight() > 0.0) {
                this.manager.init();
            }
        }

        protected void onHeightChanged(Number ov, Number nv) {
            double val = nv.doubleValue();
            if (val > 0.0 && this.table.getWidth() > 0.0) {
                this.manager.init();
            }
        }

        protected void onPositionChanged(Position ov, Position nv) {
            if (this.manager.isProcessingChange()) {
                return;
            }
            if (ov.getX() != nv.getX()) {
                this.manager.onHScroll();
            }
            if (ov.getY() != nv.getY()) {
                this.manager.onVScroll();
            }
        }

        @Override
        public double getViewportHeight() {
            double columnsHeight = this.table.getColumnSize().getHeight();
            double tableHeight = this.table.getHeight();
            return Math.max(0.0, tableHeight - columnsHeight);
        }

        @Override
        public double horizontalOffset() {
            int columnsNum = this.table.getColumns().size();
            int maxColumns = this.maxColumns();
            int firstColumn = this.firstColumn();
            int lastColumn = firstColumn + maxColumns - 1;
            return lastColumn > columnsNum - 1 && this.table.getState().columnsFilled() ? -this.table.getColumnSize().getWidth() : 0.0;
        }

        @Override
        public double verticalOffset() {
            int rowsNum = this.table.getItems().size();
            int maxRows = this.maxRows();
            int firstRow = this.firstRow();
            int lastRow = firstRow + maxRows - 1;
            return lastRow > rowsNum - 1 && this.table.getState().rowsFilled() ? -this.table.getCellHeight() : 0.0;
        }

        @Override
        public boolean invalidatedPos() {
            double eWidth = this.estimatedSize.getWidth();
            double eHeight = this.estimatedSize.getHeight();
            double x = Math.min(eWidth, this.table.getHPos());
            double y = Math.min(eHeight, this.table.getVPos());
            Position pos = Position.of((double)x, (double)y);
            boolean invalid = !this.table.getPosition().equals((Object)pos);
            this.table.setPosition(pos);
            return invalid;
        }

        @Override
        public ReadOnlyObjectProperty<Size> estimatedSizeProperty() {
            return this.estimatedSize.getReadOnlyProperty();
        }

        @Override
        public boolean isLayoutInitialized() {
            return this.layoutInitialized.get();
        }

        @Override
        public ReadOnlyBooleanProperty layoutInitializedProperty() {
            return this.layoutInitialized.getReadOnlyProperty();
        }

        @Override
        public void dispose() {
            this.table.widthProperty().removeListener(this.widthListener);
            this.table.heightProperty().removeListener(this.heightListener);
            this.table.positionProperty().removeListener(this.positionListener);
            this.widthListener = null;
            this.heightListener = null;
            this.positionListener = null;
        }
    }
}

