/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.beans.range.NumberRange;
import io.github.palexdev.mfxcore.base.properties.range.IntegerRangeProperty;
import io.github.palexdev.mfxcore.utils.fx.ListChangeHelper;
import io.github.palexdev.virtualizedfx.beans.TableStateProperty;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.TableHelper;
import io.github.palexdev.virtualizedfx.table.TableState;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import java.util.List;
import javafx.collections.ListChangeListener;

public class TableManager<T> {
    private final VirtualTable<T> table;
    private final TableStateProperty<T> state = new TableStateProperty(TableState.empty());
    private final IntegerRangeProperty lastRowsRange = new IntegerRangeProperty();
    private final IntegerRangeProperty lastColumnsRange = new IntegerRangeProperty();
    private boolean processingChange = false;

    TableManager(VirtualTable<T> table) {
        this.table = table;
    }

    public boolean init() {
        if (this.columnsEmpty()) {
            this.setState(TableState.empty());
            return false;
        }
        if (this.itemsEmpty()) {
            this.setState(TableState.emptyItems(this.table));
            this.table.requestViewportLayout();
            return true;
        }
        TableHelper helper = this.table.getTableHelper();
        IntegerRange rowsRange = helper.rowsRange();
        IntegerRange columnsRange = helper.columnsRange();
        helper.computeEstimatedSize();
        TableState<T> oldState = this.getState();
        TableState<T> newState = new TableState<T>(this.table, rowsRange, columnsRange);
        if (oldState.isEmpty()) {
            for (Integer row : rowsRange) {
                newState.addRow(row);
            }
            newState.rowsChanged();
            this.setState(newState);
            this.setLastRowsRange((NumberRange<Integer>)rowsRange);
            this.setLastColumnsRange((NumberRange<Integer>)columnsRange);
            this.table.requestViewportLayout();
            return true;
        }
        newState = oldState.init(rowsRange, columnsRange);
        if (newState == oldState) {
            return false;
        }
        newState.rowsChanged();
        this.setState(newState);
        this.setLastRowsRange((NumberRange<Integer>)rowsRange);
        this.setLastColumnsRange((NumberRange<Integer>)columnsRange);
        this.table.requestViewportLayout();
        return true;
    }

    public void onVScroll() {
        IntegerRange lRange;
        TableState<T> state = this.getState();
        if (state.isEmpty() || this.itemsEmpty()) {
            return;
        }
        TableHelper helper = this.table.getTableHelper();
        int rows = helper.maxRows();
        int sFirstRow = helper.firstRow();
        int sLastRow = helper.lastRow();
        int sTrueFirstRow = Math.max(sLastRow - rows + 1, 0);
        IntegerRange sRange = IntegerRange.of((Integer)sTrueFirstRow, (Integer)sLastRow);
        if (!sRange.equals((Object)state.getRowsRange())) {
            this.setState(state.vScroll(sRange));
        }
        if (!(lRange = IntegerRange.of((Integer)sFirstRow, (Integer)sLastRow)).equals(this.getLastRowsRange())) {
            this.table.requestViewportLayout();
        }
        this.setLastRowsRange((NumberRange<Integer>)lRange);
    }

    public void onHScroll() {
        IntegerRange lRange;
        TableState<T> state = this.getState();
        if (this.columnsEmpty()) {
            return;
        }
        TableHelper helper = this.table.getTableHelper();
        int columns = helper.maxColumns();
        int sFirstColumn = helper.firstColumn();
        int sLastColumn = helper.lastColumn();
        int sTrueFirstColumn = Math.max(sLastColumn - columns + 1, 0);
        IntegerRange sRange = IntegerRange.of((Integer)sTrueFirstColumn, (Integer)sLastColumn);
        if (!sRange.equals((Object)state.getColumnsRange())) {
            this.setState(state.hScroll(sRange));
        }
        if (!(lRange = IntegerRange.of((Integer)sFirstColumn, (Integer)sLastColumn)).equals(this.getLastColumnsRange())) {
            this.table.requestViewportLayout();
        }
        this.setLastColumnsRange((NumberRange<Integer>)lRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(ListChangeListener.Change<? extends T> change) {
        try {
            this.processingChange = true;
            TableState<T> oState = this.getState();
            if (this.itemsEmpty()) {
                this.clear();
                return;
            }
            if (oState.isEmpty()) {
                this.init();
                return;
            }
            List changes = ListChangeHelper.instance().processChange(change);
            TableState<T> nState = oState.change(changes);
            if (nState != oState) {
                this.setState(nState);
                this.table.requestViewportLayout();
                this.setLastRowsRange((NumberRange<Integer>)nState.getRowsRange());
                this.setLastColumnsRange((NumberRange<Integer>)nState.getColumnsRange());
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        finally {
            this.processingChange = false;
        }
    }

    public void onColumnChangedFactory(TableColumn<T, ? extends TableCell<T>> column) {
        TableState<T> state = this.getState();
        this.setState(state.columnChangedFactory(column));
        this.table.requestViewportLayout();
    }

    public void clear() {
        TableHelper helper = this.table.getTableHelper();
        this.getState().clear();
        this.setState(TableState.emptyItems(this.table));
        helper.computeEstimatedSize();
        helper.invalidatedPos();
    }

    public void reset() {
        this.clear();
        this.init();
    }

    private boolean itemsEmpty() {
        return this.table.getItems().isEmpty();
    }

    private boolean columnsEmpty() {
        return this.table.getColumns().isEmpty();
    }

    public TableState<T> getState() {
        return (TableState)this.state.get();
    }

    public TableStateProperty<T> stateProperty() {
        return this.state;
    }

    protected void setState(TableState<T> state) {
        this.state.set(state);
    }

    public NumberRange<Integer> getLastRowsRange() {
        return (NumberRange)this.lastRowsRange.get();
    }

    public IntegerRangeProperty lastRowsRangeProperty() {
        return this.lastRowsRange;
    }

    protected void setLastRowsRange(NumberRange<Integer> lastRowsRange) {
        this.lastRowsRange.set(lastRowsRange);
    }

    public NumberRange<Integer> getLastColumnsRange() {
        return (NumberRange)this.lastColumnsRange.get();
    }

    public IntegerRangeProperty lastColumnsRangeProperty() {
        return this.lastColumnsRange;
    }

    protected void setLastColumnsRange(NumberRange<Integer> lastColumnsRange) {
        this.lastColumnsRange.set(lastColumnsRange);
    }

    public boolean isProcessingChange() {
        return this.processingChange;
    }
}

