/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.table.TableCache;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public abstract class TableRow<T>
extends Region {
    private final String STYLE_CLASS = "table-row";
    protected final VirtualTable<T> table;
    protected int index;
    protected IntegerRange columns;
    protected final Map<Integer, TableCell<T>> cells = new TreeMap<Integer, TableCell<T>>();

    public TableRow(VirtualTable<T> table, int index, IntegerRange columns) {
        this.table = table;
        this.index = index;
        this.columns = columns;
        this.getStyleClass().add((Object)"table-row");
    }

    protected abstract TableRow<T> init();

    protected abstract void updateColumns(IntegerRange var1);

    protected abstract void updateItem();

    protected abstract void updateIndex(int var1);

    protected abstract void updateFull(int var1);

    protected abstract void updateColumnFactory(int var1);

    protected abstract double getWidthOf(int var1);

    protected abstract void cellsChanged();

    protected void clear() {
        this.cells.forEach((i, c) -> {
            c.dispose();
            if (this.table.isColumnsCacheEnabled()) {
                TableCache cache = this.table.getTableCache();
                Optional.ofNullable(this.getColumn((int)i)).ifPresent(col -> cache.remove((TableColumn)col, (TableCell)c));
            }
        });
        this.cells.clear();
    }

    public int size() {
        return this.cells.size();
    }

    public TableColumn<T, ? extends TableCell<T>> getColumn(int cIndex) {
        return this.table.getColumn(cIndex);
    }

    protected void layoutChildren() {
    }

    public VirtualTable<T> getTable() {
        return this.table;
    }

    public int getIndex() {
        return this.index;
    }

    public IntegerRange getColumns() {
        return this.columns;
    }

    protected final Map<Integer, TableCell<T>> getCells() {
        return this.cells;
    }

    public Map<Integer, TableCell<T>> getCellsUnmodifiable() {
        return Collections.unmodifiableMap(this.cells);
    }

    public List<Node> getCellsAsNodes() {
        return this.cells.values().stream().map(Cell::getNode).collect(Collectors.toList());
    }
}

