/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.utils.fx.ListChangeHelper;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.enums.UpdateType;
import io.github.palexdev.virtualizedfx.table.TableCache;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.TableHelper;
import io.github.palexdev.virtualizedfx.table.TableRow;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import io.github.palexdev.virtualizedfx.table.paginated.PaginatedVirtualTable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public class TableState<T> {
    private final VirtualTable<T> table;
    private final IntegerRange rowsRange;
    private final IntegerRange columnsRange;
    private final Map<Integer, TableRow<T>> rows = new TreeMap<Integer, TableRow<T>>();
    private final int targetSize;
    private UpdateType type = UpdateType.INIT;
    private boolean rowsChanged;
    private Boolean hidden = null;

    private TableState() {
        this.table = null;
        this.rowsRange = IntegerRange.of((Integer)-1);
        this.columnsRange = IntegerRange.of((Integer)-1);
        this.targetSize = 0;
    }

    public TableState(VirtualTable<T> table, IntegerRange rowsRange, IntegerRange columnsRange) {
        this.table = table;
        this.rowsRange = rowsRange;
        this.columnsRange = columnsRange;
        this.targetSize = table.getTableHelper().maxRows();
    }

    protected TableState<T> init(IntegerRange rowsRange, IntegerRange columnsRange) {
        if (this.rowsRange.equals((Object)rowsRange) && this.columnsRange.equals((Object)columnsRange)) {
            return this;
        }
        TableState<T> newState = new TableState<T>(this.table, rowsRange, columnsRange);
        Set range = IntegerRange.expandRangeToSet((IntegerRange)rowsRange);
        int rowsNum = this.size();
        int targetSize = rowsRange.diff() + 1;
        for (Integer rowIndex : rowsRange) {
            TableRow<T> row = this.rows.remove(rowIndex);
            if (row == null) continue;
            row.updateColumns(columnsRange);
            newState.addRow(rowIndex, row);
            range.remove(rowIndex);
        }
        ArrayDeque<Integer> reusable = new ArrayDeque<Integer>(this.rows.keySet());
        ArrayDeque remaining = new ArrayDeque(range);
        while (newState.size() != targetSize) {
            int rIndex = (Integer)remaining.removeFirst();
            Integer oIndex = (Integer)reusable.poll();
            if (oIndex != null) {
                TableRow<T> row = this.rows.remove(oIndex);
                row.updateFull(rIndex);
                newState.addRow(rIndex, row);
                continue;
            }
            newState.addRow(rIndex);
        }
        if (newState.size() != rowsNum) {
            newState.rowsChanged();
        }
        this.clear();
        return newState;
    }

    protected TableState<T> vScroll(IntegerRange rowsRange) {
        if (this.rowsRange.equals((Object)rowsRange)) {
            return this;
        }
        TableState<T> newState = new TableState<T>(this.table, rowsRange, this.columnsRange);
        newState.type = UpdateType.SCROLL;
        Set range = IntegerRange.expandRangeToSet((IntegerRange)rowsRange);
        for (Integer rowIndex : rowsRange) {
            TableRow<T> row = this.rows.remove(rowIndex);
            if (row == null) continue;
            newState.addRow(rowIndex, row);
            range.remove(rowIndex);
        }
        ArrayDeque<Integer> reusable = new ArrayDeque<Integer>(this.rows.keySet());
        ArrayDeque remaining = new ArrayDeque(range);
        while (!remaining.isEmpty()) {
            int rIndex = (Integer)remaining.removeFirst();
            Integer oIndex = (Integer)reusable.poll();
            if (oIndex == null) {
                this.table.requestViewportLayout();
                continue;
            }
            TableRow<T> row = this.rows.remove(oIndex);
            row.updateFull(rIndex);
            newState.addRow(rIndex, row);
        }
        return newState;
    }

    protected TableState<T> hScroll(IntegerRange columnsRange) {
        if (this.columnsRange.equals((Object)columnsRange)) {
            return this;
        }
        TableState<T> newState = new TableState<T>(this.table, this.rowsRange, columnsRange);
        newState.type = UpdateType.SCROLL;
        Iterator<Map.Entry<Integer, TableRow<T>>> it = this.rows.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, TableRow<T>> next = it.next();
            Integer index = next.getKey();
            TableRow<T> row = next.getValue();
            row.updateColumns(columnsRange);
            newState.addRow(index, row);
            it.remove();
        }
        return newState;
    }

    protected TableState<T> change(List<ListChangeHelper.Change> changes) {
        TableState<T> newState = this;
        for (ListChangeHelper.Change change : changes) {
            newState = newState.processChange(change);
        }
        return newState;
    }

    protected TableState<T> processChange(ListChangeHelper.Change change) {
        TableHelper helper = this.table.getTableHelper();
        TableState<T> state = this;
        int rowsNum = this.rows.size();
        switch (change.getType()) {
            case PERMUTATION: {
                this.rows.values().forEach(TableRow::updateItem);
                break;
            }
            case REPLACE: {
                IntegerRange rowsRange = helper.rowsRange();
                if (change.getFrom() > (Integer)rowsRange.getMax()) break;
                state = new TableState<T>(this.table, rowsRange, this.columnsRange);
                ArrayDeque<Integer> available = new ArrayDeque<Integer>(this.rows.keySet());
                for (Integer i : rowsRange) {
                    if (!change.hasChanged(i.intValue())) {
                        state.addRow(i, this.rows.remove(i));
                        available.remove(i);
                        continue;
                    }
                    Integer index = (Integer)available.poll();
                    if (index != null) {
                        TableRow<T> row = this.rows.remove(index);
                        row.updateFull(i);
                        state.addRow(i, row);
                        continue;
                    }
                    state.addRow(i);
                    state.rowsChanged();
                }
                this.clear();
                break;
            }
            case ADD: {
                boolean rowsFilled = this.rowsFilled();
                if (rowsFilled && change.getFrom() > (Integer)this.rowsRange.getMax()) break;
                int first = helper.firstRow();
                int last = helper.lastRow();
                IntegerRange rowsRange = IntegerRange.of((Integer)first, (Integer)last);
                state = new TableState<T>(this.table, rowsRange, this.columnsRange);
                Set available = IntegerRange.expandRangeToSet((IntegerRange)rowsRange);
                HashSet<Integer> processed = new HashSet<Integer>();
                for (int i = first; i < change.getFrom(); ++i) {
                    state.addRow(i, this.rows.remove(i));
                    available.remove(i);
                    processed.add(i);
                }
                int from = Math.max(change.getFrom(), first);
                int targetSize = this.computeTargetSize(state.targetSize);
                int lastValid = -1;
                Deque<Integer> keys = this.getKeysDequeue();
                while (!available.isEmpty() || processed.size() != targetSize) {
                    TableRow<T> row;
                    int newIndex;
                    Integer index = keys.poll();
                    if (processed.contains(index)) continue;
                    if (index != null && IntegerRange.inRangeOf((int)(newIndex = index + change.size()), (IntegerRange)rowsRange) && !change.hasChanged(newIndex) && available.contains(newIndex)) {
                        row = this.rows.remove(index);
                        row.updateIndex(newIndex);
                        state.addRow(newIndex, row);
                        available.remove(newIndex);
                        processed.add(index);
                        continue;
                    }
                    int fIndex = index == null ? lastValid-- : index;
                    row = this.rows.remove(fIndex);
                    if (row != null) {
                        row.updateFull(from);
                        state.addRow(from, row);
                    } else {
                        state.addRow(from);
                        state.rowsChanged();
                    }
                    available.remove(from);
                    processed.add(fIndex);
                    ++from;
                }
                if (!(this.table instanceof PaginatedVirtualTable)) break;
                state.addRows(this.rows);
                this.rows.clear();
                break;
            }
            case REMOVE: {
                if (change.getFrom() > (Integer)this.rowsRange.getMax()) break;
                int max = Math.min((Integer)this.rowsRange.getMin() + this.targetSize - 1, this.table.getItems().size() - 1);
                int min = Math.max(0, max - this.targetSize + 1);
                IntegerRange rowsRange = IntegerRange.of((Integer)min, (Integer)max);
                state = new TableState<T>(this.table, rowsRange, this.columnsRange);
                Set pUpdate = IntegerRange.expandRangeToSet((IntegerRange)this.rowsRange);
                pUpdate.removeAll(change.getIndexes());
                List<Integer> changeIndexes = change.getIndexes().stream().sorted().collect(Collectors.toList());
                for (Integer index : pUpdate) {
                    int newIndex = index - this.findShift(changeIndexes, index);
                    if (newIndex < (Integer)this.rowsRange.getMin()) continue;
                    TableRow<T> row = this.rows.remove(index);
                    row.updateIndex(newIndex);
                    state.addRow(newIndex, row);
                }
                Set fUpdate = IntegerRange.expandRangeToSet((IntegerRange)rowsRange);
                fUpdate.removeAll(state.rows.keySet());
                ArrayDeque<Integer> available = new ArrayDeque<Integer>(this.rows.keySet());
                for (Integer index : fUpdate) {
                    int rowIndex = (Integer)available.removeFirst();
                    TableRow<T> row = this.rows.remove(rowIndex);
                    row.updateFull(index);
                    state.addRow(index, row);
                }
                this.clear();
            }
        }
        state.type = UpdateType.CHANGE;
        if (state.size() != rowsNum) {
            state.rowsChanged();
        }
        return state;
    }

    protected TableState<T> columnChangedFactory(TableColumn<T, ? extends TableCell<T>> column) {
        if (this.isEmpty()) {
            return this;
        }
        int cIndex = this.table.getColumnIndex(column);
        if (!IntegerRange.inRangeOf((int)cIndex, (IntegerRange)this.columnsRange)) {
            return this;
        }
        TableCache<T> cache = this.table.getTableCache();
        cache.clear(column);
        TableState<T> newState = new TableState<T>(this.table, this.rowsRange, this.columnsRange);
        Iterator<Map.Entry<Integer, TableRow<T>>> it = this.rows.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, TableRow<T>> next = it.next();
            Integer index = next.getKey();
            TableRow<T> row = next.getValue();
            row.updateColumnFactory(cIndex);
            newState.addRow(index, row);
            it.remove();
        }
        return newState;
    }

    protected int findShift(List<Integer> indexes, int index) {
        int shift = Collections.binarySearch(indexes, index);
        return shift > -1 ? shift : -(shift + 1);
    }

    protected void addRow(int index) {
        BiFunction<Integer, IntegerRange, TableRow<Integer>> factory = this.table.getRowFactory();
        this.rows.put(index, factory.apply(index, this.columnsRange).init());
    }

    protected void addRow(int index, TableRow<T> row) {
        this.rows.put(index, row);
    }

    protected void addRows(Map<Integer, TableRow<T>> rows) {
        this.rows.putAll(rows);
    }

    protected Deque<Integer> getKeysDequeue() {
        if (this.table instanceof PaginatedVirtualTable && this.anyHidden()) {
            ArrayDeque<Integer> deque = new ArrayDeque<Integer>();
            LinkedHashSet<Integer> keys = new LinkedHashSet<Integer>(this.rows.keySet());
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                Integer index = (Integer)it.next();
                TableRow<T> row = this.rows.get(index);
                if (!row.isVisible()) continue;
                deque.add(index);
                it.remove();
            }
            deque.addAll(keys);
            return deque;
        }
        return new ArrayDeque<Integer>(this.rows.keySet());
    }

    protected int computeTargetSize(int expectedSize) {
        PaginatedVirtualTable pTable;
        if (this.table instanceof PaginatedVirtualTable && (pTable = (PaginatedVirtualTable)this.table).getCurrentPage() == pTable.getMaxPage()) {
            int remainder = pTable.getItems().size() % pTable.getRowsPerPage();
            return remainder != 0 ? remainder : expectedSize;
        }
        return Math.min(this.table.getItems().size(), expectedSize);
    }

    protected void clear() {
        this.rows.values().forEach(TableRow::clear);
        this.rows.clear();
    }

    public boolean rowsFilled() {
        if (this.table instanceof PaginatedVirtualTable) {
            return this.rows.values().stream().allMatch(Node::isVisible);
        }
        return this.size() >= this.targetSize;
    }

    public boolean columnsFilled() {
        TableHelper helper = this.table.getTableHelper();
        int targetColumns = helper.maxColumns();
        return this.rows.values().stream().allMatch(row -> row.size() >= targetColumns);
    }

    public int size() {
        return this.rows.size();
    }

    public int totalSize() {
        return this.rows.values().stream().mapToInt(TableRow::size).sum();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public boolean isEmptyAll() {
        return this.rows.isEmpty() && IntegerRange.of((Integer)-1).equals((Object)this.columnsRange);
    }

    public boolean anyHidden() {
        if (this.hidden == null) {
            TableHelper helper = this.table.getTableHelper();
            int firstRow = helper.firstRow();
            int lastRow = Math.min(firstRow + helper.maxRows() - 1, this.table.getItems().size() - 1);
            IntegerRange range = IntegerRange.of((Integer)firstRow, (Integer)lastRow);
            this.hidden = this.rows.keySet().stream().anyMatch(i -> !IntegerRange.inRangeOf((int)i, (IntegerRange)range));
        }
        return this.hidden;
    }

    static <T> TableState<T> empty() {
        return new TableState<T>();
    }

    static <T> TableState<T> emptyItems(VirtualTable<T> table) {
        return new TableState<T>(table, IntegerRange.of((Integer)-1), table.getTableHelper().columnsRange());
    }

    public VirtualTable<T> getTable() {
        return this.table;
    }

    protected Map<Integer, TableRow<T>> getRows() {
        return this.rows;
    }

    public Map<Integer, TableRow<T>> getRowsUnmodifiable() {
        return Collections.unmodifiableMap(this.rows);
    }

    public List<Region> getColumnsAsNodes() {
        if (IntegerRange.of((Integer)-1).equals((Object)this.columnsRange)) {
            return List.of();
        }
        return IntStream.rangeClosed((Integer)this.columnsRange.getMin(), (Integer)this.columnsRange.getMax()).mapToObj(this.table::getColumn).map(TableColumn::getRegion).collect(Collectors.toList());
    }

    public IntegerRange getRowsRange() {
        return this.rowsRange;
    }

    public IntegerRange getColumnsRange() {
        return this.columnsRange;
    }

    public int getTargetSize() {
        return this.targetSize;
    }

    public UpdateType getType() {
        return this.type;
    }

    public boolean haveRowsChanged() {
        return this.rowsChanged;
    }

    protected void rowsChanged() {
        this.rowsChanged = true;
    }
}

