/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.base.beans.Size;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.beans.range.NumberRange;
import io.github.palexdev.mfxcore.base.properties.PositionProperty;
import io.github.palexdev.mfxcore.base.properties.SizeProperty;
import io.github.palexdev.mfxcore.base.properties.functional.BiFunctionProperty;
import io.github.palexdev.mfxcore.base.properties.functional.SupplierProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableSizeProperty;
import io.github.palexdev.mfxcore.observables.When;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.PropUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.beans.TableStateProperty;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.controls.VirtualScrollPane;
import io.github.palexdev.virtualizedfx.enums.ColumnsLayoutMode;
import io.github.palexdev.virtualizedfx.table.TableCache;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.TableHelper;
import io.github.palexdev.virtualizedfx.table.TableManager;
import io.github.palexdev.virtualizedfx.table.TableRow;
import io.github.palexdev.virtualizedfx.table.TableState;
import io.github.palexdev.virtualizedfx.table.VirtualTableSkin;
import io.github.palexdev.virtualizedfx.table.defaults.DefaultTableRow;
import io.github.palexdev.virtualizedfx.utils.VSPUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class VirtualTable<T>
extends Control
implements VirtualScrollPane.Wrappable {
    private final String STYLE_CLASS = "virtual-table";
    private final TableManager<T> manager = new TableManager(this);
    private final TableCache<T> cache = new TableCache(this);
    private final ObjectProperty<ObservableList<T>> items = PropUtils.mappedObjectProperty(val -> val != null ? val : FXCollections.observableArrayList());
    private final ObservableList<TableColumn<T, ? extends TableCell<T>>> columns = FXCollections.observableArrayList();
    private final BiFunctionProperty<Integer, IntegerRange, TableRow<T>> rowFactory = new BiFunctionProperty<Integer, IntegerRange, TableRow<T>>(){

        protected void invalidated() {
            VirtualTable.this.onRowFactoryChanged();
        }
    };
    private final PositionProperty position = new PositionProperty(Position.of((double)0.0, (double)0.0)){

        public void set(Position newValue) {
            if (newValue == null) {
                super.set((Object)Position.of((double)0.0, (double)0.0));
                return;
            }
            TableHelper helper = VirtualTable.this.getTableHelper();
            if (helper == null) {
                super.set((Object)newValue);
                return;
            }
            double x = NumberUtils.clamp((double)newValue.getX(), (double)0.0, (double)helper.maxHScroll());
            double y = NumberUtils.clamp((double)newValue.getY(), (double)0.0, (double)helper.maxVScroll());
            newValue.setX(x);
            newValue.setY(y);
            super.set((Object)newValue);
        }
    };
    private final ReadOnlyObjectWrapper<TableHelper> tableHelper = new ReadOnlyObjectWrapper<TableHelper>(){

        public void set(TableHelper newValue) {
            TableHelper oldValue = (TableHelper)this.get();
            if (oldValue != null) {
                oldValue.dispose();
            }
            super.set((Object)newValue);
        }
    };
    private final SupplierProperty<TableHelper> tableHelperSupplier = new SupplierProperty<TableHelper>(){

        protected void invalidated() {
            TableHelper helper = (TableHelper)((Supplier)this.get()).get();
            VirtualTable.this.setTableHelper(helper);
        }
    };
    private final SizeProperty estimatedSize = new SizeProperty(Size.of((double)0.0, (double)0.0));
    private final ReadOnlyBooleanWrapper needsViewportLayout = new ReadOnlyBooleanWrapper(false);
    private final Map<TableColumn<T, ? extends TableCell<T>>, Integer> idxColumns = new HashMap<TableColumn<T, ? extends TableCell<T>>, Integer>();
    private boolean updateRequested = false;
    private final StyleableDoubleProperty cellHeight = new StyleableDoubleProperty(StyleableProperties.CELL_HEIGHT, this, "cellHeight", 32.0){

        protected void invalidated() {
            VirtualTable.this.onCellHeightChanged();
        }
    };
    private final StyleableSizeProperty columnSize = new StyleableSizeProperty(StyleableProperties.COLUMN_SIZE, this, "columnSize", Size.of((double)100.0, (double)32.0)){

        protected void invalidated() {
            VirtualTable.this.onColumnSizeChanged();
        }
    };
    private final StyleableObjectProperty<ColumnsLayoutMode> columnsLayoutMode = new StyleableObjectProperty<ColumnsLayoutMode>(StyleableProperties.COLUMNS_LAYOUT_MODE, (Object)this, "columnsLayoutMode", ColumnsLayoutMode.FIXED){

        protected void invalidated() {
            TableHelper helper = VirtualTable.this.getTableHelperSupplier().get();
            VirtualTable.this.setTableHelper(helper);
            VirtualTable.this.manager.reset();
        }
    };
    private final StyleableDoubleProperty clipBorderRadius = new StyleableDoubleProperty(StyleableProperties.CLIP_BORDER_RADIUS, (Object)this, "clipBorderRadius", Double.valueOf(0.0));
    private final StyleableBooleanProperty enableColumnsCache = new StyleableBooleanProperty(StyleableProperties.ENABLE_COLUMNS_CACHE, this, "enableColumnsCache", true){

        protected void invalidated() {
            boolean val = this.get();
            if (!val) {
                VirtualTable.this.cache.clear();
            }
        }
    };
    private final StyleableDoubleProperty extraAutosizeWidth = new StyleableDoubleProperty(StyleableProperties.EXTRA_AUTOSIZE_WIDTH, (Object)this, "extraAutosizeWidth", Double.valueOf(10.0));

    public VirtualTable() {
        this(FXCollections.observableArrayList(), FXCollections.observableArrayList());
    }

    public VirtualTable(ObservableList<T> items, TableColumn<T, ? extends TableCell<T>> ... columns) {
        this(items, FXCollections.observableArrayList((Object[])columns));
    }

    public VirtualTable(ObservableList<T> items, ObservableList<TableColumn<T, ? extends TableCell<T>>> columns) {
        this.setItems(items);
        this.columns.setAll(columns);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"virtual-table");
        this.setTableHelperSupplier(() -> this.getColumnsLayoutMode() == ColumnsLayoutMode.FIXED ? new TableHelper.FixedTableHelper(this) : new TableHelper.VariableTableHelper(this));
        this.setTableHelper(this.getTableHelperSupplier().get());
        this.defaultRowFactory();
        this.columns.addListener(this::onColumnsChanged);
    }

    public void requestViewportLayout() {
        this.setNeedsViewportLayout(true);
    }

    public void autosizeColumn(int index) {
        try {
            TableColumn<T, TableCell<T>> column = this.getColumn(index);
            if (column == null) {
                return;
            }
            this.autosizeColumn(column);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void autosizeColumn(TableColumn<T, ? extends TableCell<T>> column) {
        TableHelper helper = this.getTableHelper();
        if (helper == null) {
            return;
        }
        When.onChanged((ObservableValue)helper.layoutInitializedProperty()).condition((o, n) -> n).then((o, n) -> helper.autosizeColumn(column)).oneShot(true).executeNow(helper::isLayoutInitialized).listen();
    }

    public void autosizeColumns() {
        TableHelper helper = this.getTableHelper();
        if (helper == null) {
            return;
        }
        When.onChanged((ObservableValue)helper.layoutInitializedProperty()).condition((o, n) -> n).then((o, n) -> helper.autosizeColumns()).oneShot(true).executeNow(helper::isLayoutInitialized).listen();
    }

    public void defaultRowFactory() {
        this.setRowFactory((index, columns) -> new DefaultTableRow(this, (int)index, (IntegerRange)columns));
    }

    protected void onRowFactoryChanged() {
        BiFunction<Integer, IntegerRange, TableRow<T>> factory = this.getRowFactory();
        if (factory == null) {
            TableState<T> state = this.getState();
            state.clear();
            TableState newState = new TableState(this, IntegerRange.of((Integer)-1), state.getColumnsRange());
            newState.rowsChanged();
            ((TableStateProperty)this.stateProperty()).set(newState);
            return;
        }
        this.manager.reset();
    }

    protected void onCellHeightChanged() {
        TableHelper helper = this.getTableHelper();
        helper.computeEstimatedSize();
        if (this.getWidth() != 0.0 && this.getHeight() != 0.0) {
            if (!this.manager.init()) {
                this.requestViewportLayout();
            } else {
                this.setPosition(0.0, 0.0);
            }
        }
    }

    protected void onColumnSizeChanged() {
        TableHelper helper = this.getTableHelper();
        helper.computeEstimatedSize();
        helper.computePositions(this.getState(), true, false);
        this.manager.reset();
    }

    protected void onColumnsChanged(ListChangeListener.Change<? extends TableColumn<T, ? extends TableCell<T>>> c) {
        Skin skin;
        boolean rebuildMap = false;
        while (c.next()) {
            if (c.wasPermutated()) {
                rebuildMap = true;
            }
            if (c.wasRemoved()) {
                c.getRemoved().forEach(this.idxColumns::remove);
                rebuildMap = true;
            }
            if (!c.wasAdded()) continue;
            List added = c.getAddedSubList();
            int from = c.getFrom();
            int to = from + added.size();
            int j = 0;
            for (int i = from; i < to; ++i) {
                TableColumn column = (TableColumn)added.get(j);
                this.idxColumns.put(column, i);
                ++j;
            }
        }
        if (rebuildMap) {
            for (int i = 0; i < this.columns.size(); ++i) {
                TableColumn column = (TableColumn)this.columns.get(i);
                this.idxColumns.put(column, i);
            }
        }
        if ((skin = this.getSkin()) != null) {
            this.manager.reset();
        }
    }

    public void onColumnChangedFactory(TableColumn<T, ? extends TableCell<T>> column) {
        this.manager.onColumnChangedFactory(column);
    }

    public void updateTable(boolean reset) {
        try {
            this.updateRequested = true;
            if (reset) {
                if (this.getSkin() == null) {
                    return;
                }
                this.manager.reset();
            } else {
                TableState<T> state = this.getState();
                if (state.isEmpty()) {
                    return;
                }
                state.getRowsUnmodifiable().values().forEach(TableRow::updateItem);
            }
        }
        finally {
            this.updateRequested = false;
        }
    }

    public Size getEstimatedSize() {
        return (Size)this.estimatedSize.get();
    }

    public ReadOnlyObjectProperty<Size> estimatedSizeProperty() {
        return this.estimatedSize;
    }

    public TableState<T> getState() {
        return this.manager.getState();
    }

    public ReadOnlyObjectProperty<TableState<T>> stateProperty() {
        return this.manager.stateProperty();
    }

    public NumberRange<Integer> getLastRowsRange() {
        return this.manager.getLastRowsRange();
    }

    public ReadOnlyObjectProperty<NumberRange<Integer>> lastRowsRangeProperty() {
        return this.manager.lastRowsRangeProperty();
    }

    public NumberRange<Integer> getLastColumnsRange() {
        return this.manager.getLastColumnsRange();
    }

    public ReadOnlyObjectProperty<NumberRange<Integer>> lastColumnsRangeProperty() {
        return this.manager.lastColumnsRangeProperty();
    }

    public boolean isProcessingChange() {
        return this.manager.isProcessingChange();
    }

    public void scrollToFirstRow() {
        this.scrollToRow(0);
    }

    public void scrollToLastRow() {
        this.scrollToRow(this.getItems().size() - 1);
    }

    public void scrollToRow(int index) {
        this.getTableHelper().scrollToRow(index);
    }

    public void scrollToFirstColumn() {
        this.scrollToColumn(0);
    }

    public void scrollToLastColumn() {
        this.scrollToColumn(this.getColumns().size() - 1);
    }

    public void scrollToColumn(int index) {
        this.getTableHelper().scrollToColumn(index);
    }

    public void scrollBy(double pixels, Orientation orientation) {
        this.getTableHelper().scrollBy(pixels, orientation);
    }

    public void scrollTo(double pixel, Orientation orientation) {
        this.getTableHelper().scrollTo(pixel, orientation);
    }

    protected Skin<?> createDefaultSkin() {
        return new VirtualTableSkin(this);
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return VirtualTable.getClassCssMetaData();
    }

    @Override
    public VirtualScrollPane wrap() {
        return VSPUtils.wrap(this);
    }

    public double getCellHeight() {
        return this.cellHeight.get();
    }

    public StyleableDoubleProperty cellHeightProperty() {
        return this.cellHeight;
    }

    public void setCellHeight(double cellHeight) {
        this.cellHeight.set(cellHeight);
    }

    public Size getColumnSize() {
        return (Size)this.columnSize.get();
    }

    public StyleableSizeProperty columnSizeProperty() {
        return this.columnSize;
    }

    public void setColumnSize(Size columnSize) {
        this.columnSize.set((Object)columnSize);
    }

    public ColumnsLayoutMode getColumnsLayoutMode() {
        return (ColumnsLayoutMode)((Object)this.columnsLayoutMode.get());
    }

    public StyleableObjectProperty<ColumnsLayoutMode> columnsLayoutModeProperty() {
        return this.columnsLayoutMode;
    }

    public void setColumnsLayoutMode(ColumnsLayoutMode columnsLayoutMode) {
        this.columnsLayoutMode.set((Object)columnsLayoutMode);
    }

    public double getClipBorderRadius() {
        return this.clipBorderRadius.get();
    }

    public StyleableDoubleProperty clipBorderRadiusProperty() {
        return this.clipBorderRadius;
    }

    public void setClipBorderRadius(double clipBorderRadius) {
        this.clipBorderRadius.set(clipBorderRadius);
    }

    public boolean isColumnsCacheEnabled() {
        return this.enableColumnsCache.get();
    }

    public StyleableBooleanProperty enableColumnsCacheProperty() {
        return this.enableColumnsCache;
    }

    public void setEnableColumnsCache(boolean enableColumnsCache) {
        this.enableColumnsCache.set(enableColumnsCache);
    }

    public double getExtraAutosizeWidth() {
        return this.extraAutosizeWidth.get();
    }

    public StyleableDoubleProperty extraAutosizeWidthProperty() {
        return this.extraAutosizeWidth;
    }

    public void setExtraAutosizeWidth(double extraAutosizeWidth) {
        this.extraAutosizeWidth.set(extraAutosizeWidth);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    protected TableManager<T> getViewportManager() {
        return this.manager;
    }

    public TableCache<T> getTableCache() {
        return this.cache;
    }

    public ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    public void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    public TableColumn<T, ? extends TableCell<T>> getColumn(int index) {
        try {
            return (TableColumn)this.columns.get(index);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int getColumnIndex(TableColumn<T, ? extends TableCell<T>> column) {
        return Optional.ofNullable(this.idxColumns.get(column)).orElseGet(() -> this.columns.indexOf((Object)column));
    }

    public ObservableList<TableColumn<T, ? extends TableCell<T>>> getColumns() {
        return this.columns;
    }

    public Map<TableColumn<T, ? extends TableCell<T>>, Integer> getIndexedColumns() {
        return Collections.unmodifiableMap(this.idxColumns);
    }

    public BiFunction<Integer, IntegerRange, TableRow<T>> getRowFactory() {
        return (BiFunction)this.rowFactory.get();
    }

    public BiFunctionProperty<Integer, IntegerRange, TableRow<T>> rowFactoryProperty() {
        return this.rowFactory;
    }

    public void setRowFactory(BiFunction<Integer, IntegerRange, TableRow<T>> rowFactory) {
        this.rowFactory.set(rowFactory);
    }

    public void setVPos(double vPos) {
        this.setPosition(this.getHPos(), vPos);
    }

    public double getVPos() {
        return this.getPosition().getY();
    }

    public void setHPos(double hPos) {
        this.setPosition(hPos, this.getVPos());
    }

    public double getHPos() {
        return this.getPosition().getX();
    }

    public Position getPosition() {
        return (Position)this.position.get();
    }

    public PositionProperty positionProperty() {
        return this.position;
    }

    public void setPosition(double x, double y) {
        this.setPosition(Position.of((double)x, (double)y));
    }

    public void setPosition(Position position) {
        this.position.set((Object)position);
    }

    public TableHelper getTableHelper() {
        return (TableHelper)this.tableHelper.get();
    }

    public ReadOnlyObjectProperty<TableHelper> tableHelperProperty() {
        return this.tableHelper.getReadOnlyProperty();
    }

    public void setTableHelper(TableHelper tableHelper) {
        this.tableHelper.set((Object)tableHelper);
    }

    public Supplier<TableHelper> getTableHelperSupplier() {
        return (Supplier)this.tableHelperSupplier.get();
    }

    public SupplierProperty<TableHelper> tableHelperSupplierProperty() {
        return this.tableHelperSupplier;
    }

    public void setTableHelperSupplier(Supplier<TableHelper> tableHelperSupplier) {
        this.tableHelperSupplier.set(tableHelperSupplier);
    }

    public boolean isNeedsViewportLayout() {
        return this.needsViewportLayout.get();
    }

    public ReadOnlyBooleanProperty needsViewportLayoutProperty() {
        return this.needsViewportLayout.getReadOnlyProperty();
    }

    protected void setNeedsViewportLayout(boolean needsViewportLayout) {
        this.needsViewportLayout.set(needsViewportLayout);
    }

    public boolean isUpdateRequested() {
        return this.updateRequested;
    }

    protected void setUpdateRequested(boolean updateRequested) {
        this.updateRequested = updateRequested;
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<VirtualTable<?>> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<VirtualTable<?>, Number> CELL_HEIGHT;
        private static final CssMetaData<VirtualTable<?>, Size> COLUMN_SIZE;
        private static final CssMetaData<VirtualTable<?>, ColumnsLayoutMode> COLUMNS_LAYOUT_MODE;
        private static final CssMetaData<VirtualTable<?>, Number> CLIP_BORDER_RADIUS;
        private static final CssMetaData<VirtualTable<?>, Boolean> ENABLE_COLUMNS_CACHE;
        private static final CssMetaData<VirtualTable<?>, Number> EXTRA_AUTOSIZE_WIDTH;

        private StyleableProperties() {
        }

        static {
            CELL_HEIGHT = FACTORY.createSizeCssMetaData("-fx-cell-height", VirtualTable::cellHeightProperty, (Number)32.0);
            COLUMN_SIZE = new CssMetaData<VirtualTable<?>, Size>("-fx-column-size", StyleableSizeProperty.SizeConverter.getInstance(), Size.of((double)100.0, (double)32.0)){

                public boolean isSettable(VirtualTable<?> styleable) {
                    return !styleable.columnSizeProperty().isBound();
                }

                public StyleableProperty<Size> getStyleableProperty(VirtualTable<?> styleable) {
                    return styleable.columnSizeProperty();
                }
            };
            COLUMNS_LAYOUT_MODE = FACTORY.createEnumCssMetaData(ColumnsLayoutMode.class, "-fx-columns-layout-mode", VirtualTable::columnsLayoutModeProperty, (Enum)ColumnsLayoutMode.FIXED);
            CLIP_BORDER_RADIUS = FACTORY.createSizeCssMetaData("-fx-clip-border-radius", VirtualTable::clipBorderRadiusProperty, (Number)0.0);
            ENABLE_COLUMNS_CACHE = FACTORY.createBooleanCssMetaData("-fx-enable-columns-cache", VirtualTable::enableColumnsCacheProperty, true);
            EXTRA_AUTOSIZE_WIDTH = FACTORY.createSizeCssMetaData("-fx-extra-autosize-width", VirtualTable::extraAutosizeWidthProperty, (Number)10.0);
            cssMetaDataList = StyleUtils.cssMetaDataList((List)Control.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{CELL_HEIGHT, COLUMN_SIZE, COLUMNS_LAYOUT_MODE, CLIP_BORDER_RADIUS, ENABLE_COLUMNS_CACHE, EXTRA_AUTOSIZE_WIDTH});
        }
    }
}

