/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.utils.fx.LayoutUtils;
import io.github.palexdev.virtualizedfx.enums.ColumnsLayoutMode;
import io.github.palexdev.virtualizedfx.table.TableHelper;
import io.github.palexdev.virtualizedfx.table.TableManager;
import io.github.palexdev.virtualizedfx.table.TableRow;
import io.github.palexdev.virtualizedfx.table.TableState;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class VirtualTableSkin<T>
extends SkinBase<VirtualTable<T>> {
    private final Pane viewport;
    private final Rectangle clip;
    private final Pane cContainer;
    private final Pane rContainer;
    private final Rectangle rClip;
    protected TableManager<T> manager;
    protected final double DEFAULT_SIZE = 100.0;
    private ListChangeListener<? super T> itemsChanged;
    private ChangeListener<? super ObservableList<T>> listChanged;
    private ChangeListener<? super TableState<T>> stateChanged;
    private ChangeListener<? super TableHelper> helperChanged;
    private ChangeListener<? super Boolean> layoutRequestListener;

    public VirtualTableSkin(final VirtualTable<T> table) {
        super(table);
        this.manager = table.getViewportManager();
        this.cContainer = new Pane(){

            protected void layoutChildren() {
                if (table.getColumnsLayoutMode() == ColumnsLayoutMode.VARIABLE) {
                    TableHelper helper = table.getTableHelper();
                    if (helper == null) {
                        throw new IllegalStateException("Could not lay out columns as TableHelper is null");
                    }
                    helper.computePositions(table.getState(), true, false);
                    helper.computeEstimatedSize();
                    table.requestViewportLayout();
                    helper.computePositions(table.getState(), true, false);
                    helper.layout();
                    VirtualTableSkin.this.layoutCompleted();
                }
            }
        };
        this.cContainer.getStyleClass().add((Object)"columns-container");
        this.rContainer = new Pane(){

            protected void layoutChildren() {
            }
        };
        this.rContainer.getStyleClass().add((Object)"rows-container");
        this.viewport = new Pane(){

            protected void layoutChildren() {
                VirtualTable table = (VirtualTable)VirtualTableSkin.this.getSkinnable();
                double w = table.getEstimatedSize().getWidth();
                double h = table.getHeight();
                double cH = table.getColumnSize().getHeight();
                double rH = Math.max(h - cH, LayoutUtils.boundHeight((Node)VirtualTableSkin.this.rContainer));
                Position cPos = LayoutUtils.computePosition((Region)table, (Node)VirtualTableSkin.this.cContainer, (double)0.0, (double)0.0, (double)w, (double)cH, (double)0.0, (Insets)Insets.EMPTY, (HPos)HPos.LEFT, (VPos)VPos.TOP);
                VirtualTableSkin.this.cContainer.resizeRelocate(cPos.getX(), cPos.getY(), w, cH);
                Position rPos = LayoutUtils.computePosition((Region)table, (Node)VirtualTableSkin.this.rContainer, (double)0.0, (double)cH, (double)w, (double)rH, (double)0.0, (Insets)Insets.EMPTY, (HPos)HPos.LEFT, (VPos)VPos.TOP);
                VirtualTableSkin.this.rContainer.resizeRelocate(rPos.getX(), rPos.getY(), w, rH);
                TableHelper helper = table.getTableHelper();
                if (helper == null) {
                    throw new IllegalStateException("Cannot process layout request as TableHelper is null");
                }
                helper.layout();
                VirtualTableSkin.this.layoutCompleted();
            }
        };
        this.viewport.getStyleClass().add((Object)"viewport");
        this.clip = new Rectangle();
        this.clip.widthProperty().bind((ObservableValue)this.viewport.widthProperty());
        this.clip.heightProperty().bind((ObservableValue)this.viewport.heightProperty());
        this.clip.translateXProperty().bind((ObservableValue)this.viewport.translateXProperty().multiply(-1));
        this.clip.arcWidthProperty().bind((ObservableValue)table.clipBorderRadiusProperty());
        this.clip.arcHeightProperty().bind((ObservableValue)table.clipBorderRadiusProperty());
        this.viewport.setClip((Node)this.clip);
        this.rClip = new Rectangle();
        this.rClip.widthProperty().bind((ObservableValue)this.rContainer.widthProperty());
        this.rClip.heightProperty().bind((ObservableValue)this.rContainer.heightProperty());
        this.rClip.translateXProperty().bind((ObservableValue)this.viewport.translateXProperty().multiply(-1));
        this.rClip.translateYProperty().bind((ObservableValue)this.rContainer.translateYProperty().multiply(-1));
        this.rContainer.setClip((Node)this.rClip);
        this.itemsChanged = this::onItemsChanged;
        this.listChanged = (observable, oldValue, newValue) -> this.onListChanged((ObservableList<T>)oldValue, (ObservableList<T>)newValue);
        this.stateChanged = (observable, oldValue, newValue) -> this.onStateChanged((TableState<T>)oldValue, (TableState<T>)newValue);
        this.helperChanged = (observable, oldValue, newValue) -> this.onHelperChanged((TableHelper)newValue);
        this.layoutRequestListener = (observable, oldValue, newValue) -> this.onLayoutRequest((boolean)newValue);
        TableHelper helper = table.getTableHelper();
        this.viewport.translateXProperty().bind((ObservableValue)helper.xPosBinding());
        this.rContainer.translateYProperty().bind((ObservableValue)helper.yPosBinding());
        helper.computeEstimatedSize();
        this.viewport.getChildren().addAll((Object[])new Node[]{this.cContainer, this.rContainer});
        this.getChildren().addAll((Object[])new Node[]{this.viewport});
        this.addListeners();
    }

    private void addListeners() {
        VirtualTable table = (VirtualTable)this.getSkinnable();
        table.getItems().addListener(this.itemsChanged);
        table.itemsProperty().addListener(this.listChanged);
        table.stateProperty().addListener(this.stateChanged);
        table.tableHelperProperty().addListener(this.helperChanged);
        table.needsViewportLayoutProperty().addListener(this.layoutRequestListener);
    }

    protected void onItemsChanged(ListChangeListener.Change<? extends T> change) {
        VirtualTable table = (VirtualTable)this.getSkinnable();
        this.manager.onChange(change);
        TableHelper helper = table.getTableHelper();
        helper.computeEstimatedSize();
    }

    protected void onListChanged(ObservableList<T> oldValue, ObservableList<T> newValue) {
        if (oldValue != null) {
            oldValue.removeListener(this.itemsChanged);
        }
        TableHelper helper = ((VirtualTable)this.getSkinnable()).getTableHelper();
        if (newValue != null) {
            newValue.addListener(this.itemsChanged);
            helper.computeEstimatedSize();
            this.manager.reset();
        }
    }

    protected void onStateChanged(TableState<T> oldValue, TableState<T> newValue) {
        if (IntegerRange.of((Integer)-1).equals((Object)newValue.getColumnsRange())) {
            this.cContainer.getChildren().clear();
        } else if (!oldValue.getColumnsRange().equals((Object)newValue.getColumnsRange()) || this.cContainer.getChildren().isEmpty()) {
            this.cContainer.getChildren().setAll(newValue.getColumnsAsNodes());
        }
        if (newValue.isEmpty()) {
            this.rContainer.getChildren().clear();
        } else if (newValue.haveRowsChanged()) {
            Collection<TableRow<T>> rows = newValue.getRows().values();
            this.rContainer.getChildren().setAll(rows);
        }
    }

    protected void onHelperChanged(TableHelper newValue) {
        if (newValue == null) {
            throw new IllegalStateException("The new provided TableHelper is null, you will encounter problems");
        }
        this.viewport.translateXProperty().bind((ObservableValue)newValue.xPosBinding());
        this.rContainer.translateYProperty().bind((ObservableValue)newValue.yPosBinding());
    }

    protected void onLayoutRequest(boolean newValue) {
        if (newValue) {
            this.viewport.requestLayout();
        }
    }

    protected void layoutCompleted() {
        ((VirtualTable)this.getSkinnable()).setNeedsViewportLayout(false);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + 100.0 + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + 100.0 + bottomInset;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        VirtualTable table = (VirtualTable)this.getSkinnable();
        Position vPos = LayoutUtils.computePosition((Region)table, (Node)this.viewport, (double)0.0, (double)0.0, (double)w, (double)h, (double)0.0, (Insets)Insets.EMPTY, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.viewport.resizeRelocate(vPos.getX(), vPos.getY(), w + this.snappedLeftInset() + this.snappedRightInset(), h + this.snappedTopInset() + this.snappedBottomInset());
    }

    public void dispose() {
        VirtualTable table = (VirtualTable)this.getSkinnable();
        table.getItems().removeListener(this.itemsChanged);
        table.itemsProperty().removeListener(this.listChanged);
        table.stateProperty().removeListener(this.stateChanged);
        table.tableHelperProperty().removeListener(this.helperChanged);
        table.needsViewportLayoutProperty().removeListener(this.layoutRequestListener);
        this.itemsChanged = null;
        this.listChanged = null;
        this.stateChanged = null;
        this.helperChanged = null;
        this.layoutRequestListener = null;
        this.manager = null;
        super.dispose();
    }
}

