/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table.defaults;

import io.github.palexdev.mfxcore.base.beans.range.DoubleRange;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.bindings.AbstractSource;
import io.github.palexdev.mfxcore.base.bindings.ExternalSource;
import io.github.palexdev.mfxcore.base.bindings.MFXBindings;
import io.github.palexdev.mfxcore.base.bindings.Mapper;
import io.github.palexdev.mfxcore.base.bindings.MappingSource;
import io.github.palexdev.mfxcore.base.properties.functional.FunctionProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.mfxcore.enums.Zone;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.mfxcore.utils.resize.RegionDragResizer;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.enums.ColumnsLayoutMode;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.TableState;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import io.github.palexdev.virtualizedfx.table.defaults.DefaultTableColumnSkin;
import io.github.palexdev.virtualizedfx.table.defaults.SimpleTableCell;
import java.util.List;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.HPos;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public class DefaultTableColumn<T, C extends TableCell<T>>
extends Labeled
implements TableColumn<T, C> {
    private final String STYLE_CLASS = "table-column";
    private final VirtualTable<T> table;
    private final FunctionProperty<T, C> cellFactory = new FunctionProperty();
    private final BooleanProperty inViewport = new SimpleBooleanProperty(false){

        public void set(boolean newValue) {
            boolean oldValue = this.get();
            super.set(newValue);
            if (oldValue != newValue) {
                DefaultTableColumn.this.onVisibilityChanged(oldValue, newValue);
            }
        }

        public boolean isBound() {
            MFXBindings bindings = MFXBindings.instance();
            return super.isBound() || bindings.isBound((ObservableValue)this) && !bindings.isIgnoreBinding((ObservableValue)this);
        }
    };
    private final StyleableObjectProperty<HPos> iconAlignment = new StyleableObjectProperty(StyleableProperties.ICON_ALIGNMENT, (Object)this, "iconAlignment", (Object)HPos.RIGHT);
    private final StyleableBooleanProperty enableOverlay = new StyleableBooleanProperty(StyleableProperties.ENABLE_OVERLAY, (Object)this, "enableOverlay", true);
    private final StyleableBooleanProperty overlayOnHeader = new StyleableBooleanProperty(StyleableProperties.OVERLAY_ON_HEADER, (Object)this, "overlayOnHeader", false);

    public DefaultTableColumn(VirtualTable<T> table) {
        this(table, "");
    }

    public DefaultTableColumn(VirtualTable<T> table, String text) {
        super(text);
        this.table = table;
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{"table-column"});
        this.defaultCellFactory();
        this.setupRegionDragResizer();
        MFXBindings bindings = MFXBindings.instance();
        MappingSource mainSource = MappingSource.of(this.table.stateProperty()).setTargetUpdater(Mapper.of(val -> {
            VirtualTable<T> table = this.getTable();
            if (table == null || this.getScene() == null || this.getParent() == null) {
                return false;
            }
            if (table.getColumnsLayoutMode() == ColumnsLayoutMode.FIXED) {
                TableState<T> state = table.getState();
                if (state.isEmptyAll()) {
                    return false;
                }
                int index = table.getIndexedColumns().getOrDefault(this, -2);
                return IntegerRange.inRangeOf((int)index, (IntegerRange)state.getColumnsRange());
            }
            try {
                double tW = table.getWidth();
                double hPos = table.getHPos();
                DoubleRange viewBounds = DoubleRange.of((Double)hPos, (Double)(hPos + tW));
                double x = this.getBoundsInParent().getMinX();
                double w = this.getWidth();
                return x + w >= (Double)viewBounds.getMin() && x <= (Double)viewBounds.getMax();
            }
            catch (Exception ex) {
                return false;
            }
        }), (o, n) -> this.inViewport.set(n.booleanValue()));
        bindings.bind((ObservableValue)this.inViewport).source((AbstractSource)mainSource).addInvalidatingSource(ExternalSource.of(this.table.stateProperty(), (o, n) -> {
            if (this.table.getColumnsLayoutMode() != ColumnsLayoutMode.FIXED) {
                return;
            }
            bindings.invTarget((ObservableValue)this.inViewport);
        })).addInvalidatingSource(ExternalSource.of((ObservableValue)this.boundsInParentProperty(), (o, n) -> {
            if (this.table.getColumnsLayoutMode() == ColumnsLayoutMode.VARIABLE) {
                return;
            }
            if (o.getMinX() != n.getMinX()) {
                bindings.invTarget((ObservableValue)this.inViewport);
            }
        })).addInvalidatingSource(ExternalSource.of((ObservableValue)this.table.positionProperty(), (o, n) -> {
            if (o.getX() != n.getX()) {
                bindings.invTarget((ObservableValue)this.inViewport);
            }
        })).addInvalidatingSource(ExternalSource.of((ObservableValue)this.table.needsViewportLayoutProperty(), (o, n) -> {
            if (!n.booleanValue()) {
                bindings.invTarget((ObservableValue)this.inViewport);
            }
        })).get();
    }

    public void defaultCellFactory() {
        this.setCellFactory(t -> new SimpleTableCell<Object, Object>(t, e -> e));
    }

    protected void setupRegionDragResizer() {
        final PseudoClass dragged = PseudoClass.getPseudoClass((String)"dragged");
        RegionDragResizer rdr = new RegionDragResizer((Region)this, (node, x, y, w, h) -> {
            node.setPrefWidth(w);
            this.table.requestViewportLayout();
        }){

            protected void handleDragged(MouseEvent event) {
                if (DefaultTableColumn.this.table == null || DefaultTableColumn.this.table.getColumnsLayoutMode() == ColumnsLayoutMode.FIXED) {
                    return;
                }
                super.handleDragged(event);
                DefaultTableColumn.this.pseudoClassStateChanged(dragged, true);
            }

            protected void handleMoved(MouseEvent event) {
                if (DefaultTableColumn.this.table == null || DefaultTableColumn.this.table.getColumnsLayoutMode() == ColumnsLayoutMode.FIXED) {
                    return;
                }
                super.handleMoved(event);
            }

            protected void handlePressed(MouseEvent event) {
                if (DefaultTableColumn.this.table == null || DefaultTableColumn.this.table.getColumnsLayoutMode() == ColumnsLayoutMode.FIXED) {
                    return;
                }
                super.handlePressed(event);
            }

            protected void handleReleased(MouseEvent event) {
                super.handleReleased(event);
                DefaultTableColumn.this.pseudoClassStateChanged(dragged, false);
            }
        };
        rdr.setAllowedZones(new Zone[]{Zone.CENTER_RIGHT});
        rdr.makeResizable();
    }

    protected Skin<?> createDefaultSkin() {
        return new DefaultTableColumnSkin(this);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return DefaultTableColumn.getClassCssMetaData();
    }

    @Override
    public Region getRegion() {
        return this;
    }

    @Override
    public VirtualTable<T> getTable() {
        return this.table;
    }

    @Override
    public Function<T, C> getCellFactory() {
        return (Function)this.cellFactory.get();
    }

    @Override
    public FunctionProperty<T, C> cellFactoryProperty() {
        return this.cellFactory;
    }

    @Override
    public void setCellFactory(Function<T, C> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    @Override
    public boolean isInViewport() {
        return this.inViewport.get();
    }

    @Override
    public ReadOnlyBooleanProperty inViewportProperty() {
        return this.inViewport;
    }

    public HPos getIconAlignment() {
        return (HPos)this.iconAlignment.get();
    }

    public StyleableObjectProperty<HPos> iconAlignmentProperty() {
        return this.iconAlignment;
    }

    public void setIconAlignment(HPos iconAlignment) {
        this.iconAlignment.set((Object)iconAlignment);
    }

    public boolean isEnableOverlay() {
        return this.enableOverlay.get();
    }

    public StyleableBooleanProperty enableOverlayProperty() {
        return this.enableOverlay;
    }

    public void setEnableOverlay(boolean enableOverlay) {
        this.enableOverlay.set(enableOverlay);
    }

    public boolean isOverlayOnHeader() {
        return this.overlayOnHeader.get();
    }

    public StyleableBooleanProperty overlayOnHeaderProperty() {
        return this.overlayOnHeader;
    }

    public void setOverlayOnHeader(boolean overlayOnHeader) {
        this.overlayOnHeader.set(overlayOnHeader);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<DefaultTableColumn<?, ?>> FACTORY = new StyleablePropertyFactory(Labeled.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<DefaultTableColumn<?, ?>, HPos> ICON_ALIGNMENT;
        private static final CssMetaData<DefaultTableColumn<?, ?>, Boolean> ENABLE_OVERLAY;
        private static final CssMetaData<DefaultTableColumn<?, ?>, Boolean> OVERLAY_ON_HEADER;

        private StyleableProperties() {
        }

        public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
            return cssMetaDataList;
        }

        static {
            ICON_ALIGNMENT = FACTORY.createEnumCssMetaData(HPos.class, "-fx-icon-alignment", DefaultTableColumn::iconAlignmentProperty, (Enum)HPos.RIGHT);
            ENABLE_OVERLAY = FACTORY.createBooleanCssMetaData("-fx-enable-overlay", DefaultTableColumn::enableOverlayProperty, true);
            OVERLAY_ON_HEADER = FACTORY.createBooleanCssMetaData("-fx-overlay-on-header", DefaultTableColumn::overlayOnHeaderProperty, false);
            cssMetaDataList = StyleUtils.cssMetaDataList((List)Labeled.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{ICON_ALIGNMENT, ENABLE_OVERLAY, OVERLAY_ON_HEADER});
        }
    }
}

