/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table.defaults;

import io.github.palexdev.mfxcore.base.bindings.MFXBindings;
import io.github.palexdev.mfxcore.utils.fx.LayoutUtils;
import io.github.palexdev.mfxcore.utils.fx.TextUtils;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.controls.BoundLabel;
import io.github.palexdev.virtualizedfx.enums.ColumnsLayoutMode;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import io.github.palexdev.virtualizedfx.table.defaults.DefaultTableColumn;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class DefaultTableColumnSkin<T, C extends TableCell<T>>
extends SkinBase<DefaultTableColumn<T, C>> {
    private final HBox box;
    private final BoundLabel label;
    private final Region overlay;

    public DefaultTableColumnSkin(DefaultTableColumn<T, C> column) {
        super(column);
        this.label = new BoundLabel(column);
        this.label.graphicProperty().unbind();
        this.label.setGraphic(null);
        this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.box = new HBox(new Node[]{this.label});
        this.box.setAlignment(Pos.CENTER);
        this.box.spacingProperty().bind((ObservableValue)this.label.graphicTextGapProperty());
        this.initIcon();
        this.overlay = new Region();
        this.overlay.getStyleClass().add((Object)"overlay");
        this.overlay.setManaged(false);
        this.getChildren().addAll((Object[])new Node[]{this.box, this.overlay});
        this.addListeners();
    }

    private void addListeners() {
        DefaultTableColumn column = (DefaultTableColumn)this.getSkinnable();
        column.graphicProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.box.getChildren().remove(oldValue);
            }
            this.initIcon();
        });
        column.iconAlignmentProperty().addListener(invalidated -> this.initIcon());
        column.cellFactoryProperty().addListener(invalidated -> {
            VirtualTable table = column.getTable();
            table.onColumnChangedFactory(column);
        });
        VirtualTable table = column.getTable();
        InvalidationListener layoutListener = invalidated -> column.requestLayout();
        table.heightProperty().addListener(layoutListener);
        table.columnsLayoutModeProperty().addListener(layoutListener);
        table.columnSizeProperty().addListener(layoutListener);
    }

    private void initIcon() {
        DefaultTableColumn column = (DefaultTableColumn)this.getSkinnable();
        Node icon = column.getGraphic();
        if (icon == null) {
            return;
        }
        this.box.getChildren().remove((Object)icon);
        HPos iconAlignment = column.getIconAlignment();
        if (iconAlignment == HPos.LEFT) {
            this.box.getChildren().add(0, (Object)icon);
        } else {
            this.box.getChildren().add((Object)icon);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        DefaultTableColumn column = (DefaultTableColumn)this.getSkinnable();
        VirtualTable table = column.getTable();
        double cw = table.getColumnSize().getWidth();
        if (table.getColumnsLayoutMode() == ColumnsLayoutMode.VARIABLE && cw > 0.0) {
            return Math.max(LayoutUtils.boundWidth((Node)this.box), cw);
        }
        return super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        DefaultTableColumn column = (DefaultTableColumn)this.getSkinnable();
        VirtualTable table = column.getTable();
        Node icon = column.getGraphic();
        double gap = column.getGraphicTextGap();
        if (table.getColumnsLayoutMode() == ColumnsLayoutMode.VARIABLE) {
            return leftInset + TextUtils.computeLabelWidth((Label)this.label) + (icon != null ? icon.prefWidth(-1.0) + gap : 0.0) + rightInset;
        }
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        DefaultTableColumn column = (DefaultTableColumn)this.getSkinnable();
        super.layoutChildren(x, y, w, h);
        VirtualTable table = column.getTable();
        double oW = this.snappedRightInset() + w + this.snappedLeftInset();
        double oH = table != null ? table.getHeight() : 0.0;
        double oY = column.isOverlayOnHeader() ? 0.0 : h;
        this.overlay.resizeRelocate(0.0, oY, oW, oH);
    }

    public void dispose() {
        DefaultTableColumn column = (DefaultTableColumn)this.getSkinnable();
        MFXBindings.instance().dispose((ObservableValue)column.inViewportProperty());
        super.dispose();
    }
}

