/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table.defaults;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.table.TableCache;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.TableRow;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javafx.scene.Node;

public class DefaultTableRow<T>
extends TableRow<T> {
    public DefaultTableRow(VirtualTable<T> table, int index, IntegerRange columns) {
        super(table, index, columns);
    }

    public static <T> DefaultTableRow<T> of(VirtualTable<T> table, int index, IntegerRange columns) {
        return new DefaultTableRow<T>(table, index, columns);
    }

    @Override
    protected TableRow<T> init() {
        if (this.index < 0 || IntegerRange.of((Integer)-1).equals((Object)this.columns)) {
            return this;
        }
        this.clear();
        for (Integer cIndex : this.columns) {
            TableColumn column = this.getColumn(cIndex);
            Object item = this.table.getItems().get(this.index);
            TableCell<Object> cell = this.takeFromCacheOrCreate(column, item);
            cell.updateIndex(cIndex);
            this.cells.put(cIndex, cell);
        }
        this.cellsChanged();
        return this;
    }

    @Override
    protected void updateColumns(IntegerRange columns) {
        if (this.columns.equals((Object)columns)) {
            return;
        }
        HashMap<Integer, TableCell<Object>> tmp = new HashMap<Integer, TableCell<Object>>();
        Set range = IntegerRange.expandRangeToSet((IntegerRange)columns);
        int targetSize = columns.diff() + 1;
        for (Integer column : columns) {
            if (!this.cells.containsKey(column)) continue;
            tmp.put(column, (TableCell)this.cells.remove(column));
            range.remove(column);
        }
        ArrayDeque remaining = new ArrayDeque(range);
        Object item = this.table.getItems().get(this.index);
        while (tmp.size() != targetSize) {
            int rIndex = (Integer)remaining.removeFirst();
            TableColumn column = this.getColumn(rIndex);
            TableCell<Object> cell = this.takeFromCacheOrCreate(column, item);
            cell.updateIndex(rIndex);
            tmp.put(rIndex, cell);
        }
        Iterator it = this.cells.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            this.cacheCell((Integer)next.getKey(), (TableCell)next.getValue());
            it.remove();
        }
        this.cells.putAll(tmp);
        this.columns = columns;
        this.cellsChanged();
    }

    @Override
    protected void updateItem() {
        Object item = this.table.getItems().get(this.index);
        this.cells.values().forEach(c -> c.updateItem(item));
    }

    @Override
    protected void updateIndex(int index) {
        if (this.index == index) {
            return;
        }
        this.index = index;
        this.cells.values().forEach(c -> c.updateRow(index, this));
    }

    @Override
    protected void updateFull(int index) {
        this.index = index;
        Object item = this.table.getItems().get(index);
        this.cells.values().forEach(c -> {
            c.updateRow(index, this);
            c.updateItem(item);
        });
    }

    @Override
    protected void updateColumnFactory(int cIndex) {
        TableCell oldCell = (TableCell)this.cells.remove(cIndex);
        if (oldCell != null) {
            oldCell.dispose();
        }
        Object item = this.table.getItems().get(this.index);
        TableColumn column = this.table.getColumn(cIndex);
        TableCell cell = column.getCellFactory().apply(item);
        cell.updateIndex(cIndex);
        cell.updateColumn(column);
        cell.updateRow(this.index, this);
        this.cells.put(cIndex, cell);
        this.cellsChanged();
    }

    @Override
    protected double getWidthOf(int cIndex) {
        return Optional.ofNullable((TableCell)this.cells.get(cIndex)).map(c -> c.getNode().prefWidth(-1.0)).orElse(0.0);
    }

    @Override
    protected void cellsChanged() {
        List<Node> nodes = this.getCellsAsNodes();
        this.getChildren().setAll(nodes);
    }

    protected TableCell<T> takeFromCacheOrCreate(TableColumn<T, ? extends TableCell<T>> column, T item) {
        Supplier<TableCell> creator = () -> {
            TableCell cell = (TableCell)column.getCellFactory().apply(item);
            cell.updateColumn(column);
            cell.updateRow(this.index, this);
            return cell;
        };
        if (!this.table.isColumnsCacheEnabled()) {
            return creator.get();
        }
        TableCache<T> cache = this.table.getTableCache();
        Optional<TableCell<TableCell>> optCell = cache.tryTake(column);
        optCell.ifPresent(c -> {
            c.updateColumn(column);
            c.updateRow(this.index, this);
            c.updateItem(item);
        });
        return optCell.orElseGet(creator);
    }

    protected void cacheCell(int index, TableCell<T> cell) {
        if (!this.table.isColumnsCacheEnabled()) {
            cell.dispose();
            return;
        }
        TableCache cache = this.table.getTableCache();
        TableColumn column = this.getColumn(index);
        cell.updateRow(-1, null);
        cell.updateColumn(null);
        cache.cache(column, cell);
    }
}

