/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table.defaults;

import io.github.palexdev.mfxcore.observables.When;
import io.github.palexdev.mfxcore.utils.converters.FunctionalStringConverter;
import io.github.palexdev.virtualizedfx.cell.MappingTableCell;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.enums.ColumnsLayoutMode;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.TableRow;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import io.github.palexdev.virtualizedfx.table.defaults.DefaultTableRow;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class SimpleTableCell<T, E>
extends HBox
implements MappingTableCell<T, E> {
    private final String STYLE_CLASS = "vtable-cell";
    private final ReadOnlyObjectWrapper<TableColumn<T, ? extends TableCell<T>>> column = new ReadOnlyObjectWrapper();
    private final ReadOnlyObjectWrapper<TableRow<T>> row = new ReadOnlyObjectWrapper();
    private final ObjectProperty<T> item = new SimpleObjectProperty();
    private final IntegerProperty index = new SimpleIntegerProperty();
    private Function<T, E> extractor;
    private StringConverter<E> converter;
    protected final Label label;
    protected When<Boolean> ivwWhen;

    public SimpleTableCell(T item, Function<T, E> extractor) {
        this(item, extractor, FunctionalStringConverter.to(Objects::toString));
    }

    public SimpleTableCell(T item, Function<T, E> extractor, StringConverter<E> converter) {
        this.extractor = extractor;
        this.converter = converter;
        this.setItem(item);
        this.label = new Label();
        this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        SimpleTableCell.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.getChildren().setAll((Object[])new Node[]{this.label});
        this.init();
    }

    protected void init() {
        this.getStyleClass().add((Object)"vtable-cell");
        this.invalidate();
        this.columnProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null && this.ivwWhen != null) {
                this.ivwWhen.dispose();
            }
            if (newValue != null) {
                VirtualTable table = newValue.getTable();
                if (table == null || table.getColumnsLayoutMode() == ColumnsLayoutMode.FIXED) {
                    return;
                }
                this.ivwWhen = When.onChanged((ObservableValue)newValue.inViewportProperty()).then((o, n) -> this.setVisible(this.getColumn() != null && this.getColumn().isInViewport())).executeNow().listen();
            }
        });
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void updateItem(T item) {
        this.setItem(item);
        this.invalidate();
    }

    @Override
    public void updateIndex(int index) {
        this.setIndex(index);
    }

    @Override
    public void updateColumn(TableColumn<T, ? extends TableCell<T>> column) {
        this.setColumn(column);
    }

    @Override
    public void updateRow(int rIndex, DefaultTableRow<T> row) {
        this.setRow(row);
    }

    @Override
    public void invalidate() {
        T item = this.getItem();
        E e = this.extractor.apply(item);
        String s = this.converter.toString(e);
        this.label.setText(s);
    }

    public TableColumn<T, ? extends TableCell<T>> getColumn() {
        return (TableColumn)this.column.get();
    }

    public ReadOnlyObjectProperty<TableColumn<T, ? extends TableCell<T>>> columnProperty() {
        return this.column.getReadOnlyProperty();
    }

    protected void setColumn(TableColumn<T, ? extends TableCell<T>> column) {
        this.column.set(column);
    }

    public TableRow<T> getRow() {
        return (TableRow)((Object)this.row.get());
    }

    public ReadOnlyObjectProperty<TableRow<T>> rowProperty() {
        return this.row.getReadOnlyProperty();
    }

    protected void setRow(DefaultTableRow<T> row) {
        this.row.set(row);
    }

    public T getItem() {
        return (T)this.item.get();
    }

    public ObjectProperty<T> itemProperty() {
        return this.item;
    }

    public void setItem(T item) {
        this.item.set(item);
    }

    public int getIndex() {
        return this.index.get();
    }

    public IntegerProperty indexProperty() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index.set(index);
    }

    @Override
    public Function<T, E> getExtractor() {
        return this.extractor;
    }

    @Override
    public void setExtractor(Function<T, E> extractor) {
        this.extractor = extractor;
    }

    @Override
    public StringConverter<E> getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(StringConverter<E> converter) {
        this.converter = converter;
    }
}

