/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table.defaults;

import io.github.palexdev.mfxcore.observables.When;
import io.github.palexdev.mfxcore.utils.converters.FunctionalStringConverter;
import io.github.palexdev.virtualizedfx.table.defaults.SimpleTableCell;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.util.StringConverter;

public class UpdatingTableCell<T, E>
extends SimpleTableCell<T, ObservableValue<E>> {
    private ObservableValue<E> property;
    protected When<E> updWhen;

    public UpdatingTableCell(T item, Function<T, ObservableValue<E>> extractor) {
        this(item, extractor, (StringConverter<ObservableValue<E>>)FunctionalStringConverter.to(p -> p != null ? Objects.toString(p.getValue()) : "null"));
    }

    public UpdatingTableCell(T item, Function<T, ObservableValue<E>> extractor, StringConverter<ObservableValue<E>> converter) {
        super(item, extractor, converter);
    }

    protected ObservableValue<E> getProperty() {
        if (this.property == null) {
            this.property = (ObservableValue)this.getExtractor().apply(this.getItem());
            this.updWhen = When.onInvalidated(this.property).then(o -> this.invalidate()).executeNow().listen();
        }
        return this.property;
    }

    @Override
    public void updateItem(T item) {
        if (this.ivwWhen != null) {
            this.ivwWhen.dispose();
        }
        this.ivwWhen = null;
        this.property = null;
        this.setItem(item);
        this.invalidate();
    }

    @Override
    public void invalidate() {
        String toString = this.getConverter().toString(this.getProperty());
        this.label.setText(toString);
    }

    @Override
    public void dispose() {
        if (this.ivwWhen != null) {
            this.ivwWhen.dispose();
        }
        this.ivwWhen = null;
        this.property = null;
    }
}

