/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table.paginated;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.utils.fx.LayoutUtils;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.TableHelper;
import io.github.palexdev.virtualizedfx.table.TableRow;
import io.github.palexdev.virtualizedfx.table.TableState;
import io.github.palexdev.virtualizedfx.table.paginated.PaginatedVirtualTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public interface PaginatedHelper
extends TableHelper {
    public double pageToPos(int var1);

    public void goToPage(int var1);

    public static class VariablePaginatedTableHelper
    extends TableHelper.VariableTableHelper
    implements PaginatedHelper {
        protected PaginatedVirtualTable<?> pTable;

        public VariablePaginatedTableHelper(PaginatedVirtualTable<?> table) {
            super(table);
            this.pTable = table;
        }

        @Override
        public int maxRows() {
            return this.pTable.getRowsPerPage();
        }

        @Override
        public double maxVScroll() {
            return this.pageToPos(this.pTable.getMaxPage());
        }

        @Override
        public double pageToPos(int page) {
            return (double)((page - 1) * this.pTable.getRowsPerPage()) * this.pTable.getCellHeight();
        }

        @Override
        public void goToPage(int page) {
            super.scrollTo(this.pageToPos(page), Orientation.VERTICAL);
        }

        @Override
        public void scrollBy(double pixels, Orientation orientation) {
            throw new UnsupportedOperationException("The paginated table cannot scroll by a given amount of pixels");
        }

        @Override
        public void scrollTo(double pixel, Orientation orientation) {
            throw new UnsupportedOperationException("The paginated table cannot scroll to a given pixel position as it may be wrong");
        }

        @Override
        public void scrollToRow(int index) {
            throw new UnsupportedOperationException("The paginated table cannot scroll to a given row index");
        }

        @Override
        public Map<Orientation, List<Double>> computePositions(TableState<?> state, boolean forceXComputation, boolean forceYComputation) {
            IntegerRange columnsRange = state.getColumnsRange();
            double cellH = this.table.getCellHeight();
            AtomicBoolean anyHidden = new AtomicBoolean(false);
            int firstRow = this.firstRow();
            int lastRow = Math.min(firstRow + this.maxRows() - 1, this.table.getItems().size() - 1);
            IntegerRange rowsRange = IntegerRange.of((Integer)firstRow, (Integer)lastRow);
            Map<Integer, TableRow<?>> rows = state.getRowsUnmodifiable();
            rows.entrySet().stream().filter(e -> !IntegerRange.inRangeOf((int)((Integer)e.getKey()), (IntegerRange)rowsRange)).peek(e -> anyHidden.set(true)).forEach(e -> ((TableRow)((Object)((Object)e.getValue()))).setVisible(false));
            List xPositions = this.positions.computeIfAbsent(Orientation.HORIZONTAL, o -> new ArrayList());
            if (forceXComputation || xPositions.isEmpty()) {
                xPositions.clear();
                double pos = 0.0;
                for (Integer cIndex : columnsRange) {
                    TableColumn column = this.table.getColumn(cIndex);
                    Region region = column.getRegion();
                    xPositions.add(pos);
                    double colW = Math.max(LayoutUtils.boundWidth((Node)region), this.table.getColumnSize().getWidth());
                    pos += colW;
                }
            }
            List yPositions = this.positions.computeIfAbsent(Orientation.VERTICAL, o -> new ArrayList());
            Integer rRangeDiff = rowsRange.diff();
            if (anyHidden.get() || forceYComputation || yPositions.isEmpty() || yPositions.size() != rRangeDiff + 1) {
                yPositions.clear();
                double pos = (double)rRangeDiff.intValue() * cellH;
                for (int i = firstRow; i <= lastRow; ++i) {
                    TableRow<?> row = rows.get(i);
                    yPositions.add(pos);
                    pos -= cellH;
                    row.setVisible(true);
                }
            }
            return this.positions;
        }

        @Override
        public void layout() {
            TableState state = this.table.getState();
            if (state.isEmptyAll()) {
                this.layoutInitialized.set(false);
                return;
            }
            if (!this.table.isNeedsViewportLayout() || this.invalidatedPos()) {
                return;
            }
            Map<Orientation, List<Double>> positions = this.computePositions(state, false, false);
            double colH = this.table.getColumnSize().getHeight();
            IntegerRange columnsRange = state.getColumnsRange();
            List<Double> xPositions = positions.get(Orientation.HORIZONTAL);
            int xI = 0;
            double totalW = 0.0;
            for (Integer cIndex : columnsRange) {
                TableColumn column = this.table.getColumn(cIndex);
                Region region = column.getRegion();
                double colW = Math.max(LayoutUtils.boundWidth((Node)region), this.table.getColumnSize().getWidth());
                Double xPos = xPositions.get(xI);
                totalW += colW;
                if (cIndex.equals(columnsRange.getMax()) && totalW < this.table.getWidth()) {
                    region.resizeRelocate(xPos.doubleValue(), 0.0, this.table.getWidth() - totalW + colW, colH);
                } else {
                    region.resizeRelocate(xPos.doubleValue(), 0.0, colW, colH);
                }
                ++xI;
            }
            if (!state.isEmpty()) {
                double cellH = this.table.getCellHeight();
                double yOffset = this.verticalOffset();
                List<Double> yPositions = positions.get(Orientation.VERTICAL);
                int yI = yPositions.size() - 1;
                Collection rows = state.getRowsUnmodifiable().values();
                for (TableRow row : rows) {
                    if (!row.isVisible()) continue;
                    xI = 0;
                    Double yPos = yPositions.get(yI);
                    double rowW = Math.max(LayoutUtils.boundWidth(row) + this.table.getColumnSize().getWidth(), this.table.getWidth());
                    row.resizeRelocate(0.0, yPos + yOffset, rowW, cellH);
                    ArrayList cells = new ArrayList(row.getCellsUnmodifiable().values());
                    for (int i = 0; i < cells.size(); ++i) {
                        TableCell cell = (TableCell)cells.get(i);
                        TableColumn column = this.table.getColumn(i);
                        Node node = cell.getNode();
                        cell.beforeLayout();
                        node.resizeRelocate(xPositions.get(xI).doubleValue(), 0.0, column.getRegion().getWidth(), cellH);
                        cell.afterLayout();
                        ++xI;
                    }
                    --yI;
                }
                this.layoutInitialized.set(totalW > 0.0);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this.pTable = null;
        }
    }

    public static class FixedPaginatedTableHelper
    extends TableHelper.FixedTableHelper
    implements PaginatedHelper {
        protected PaginatedVirtualTable<?> pTable;

        public FixedPaginatedTableHelper(PaginatedVirtualTable<?> table) {
            super(table);
            this.pTable = table;
        }

        @Override
        public int maxRows() {
            return this.pTable.getRowsPerPage();
        }

        @Override
        public double maxVScroll() {
            return this.pageToPos(this.pTable.getMaxPage());
        }

        @Override
        public double pageToPos(int page) {
            return (double)((page - 1) * this.pTable.getRowsPerPage()) * this.pTable.getCellHeight();
        }

        @Override
        public void goToPage(int page) {
            super.scrollTo(this.pageToPos(page), Orientation.VERTICAL);
        }

        @Override
        public void scrollBy(double pixels, Orientation orientation) {
            throw new UnsupportedOperationException("The paginated table cannot scroll by a given amount of pixels");
        }

        @Override
        public void scrollTo(double pixel, Orientation orientation) {
            throw new UnsupportedOperationException("The paginated table cannot scroll to a given pixel position as it may be wrong");
        }

        @Override
        public void scrollToRow(int index) {
            throw new UnsupportedOperationException("The paginated table cannot scroll to a given row index");
        }

        @Override
        public Map<Orientation, List<Double>> computePositions(TableState<?> state, boolean forceXComputation, boolean forceYComputation) {
            IntegerRange columnsRange = state.getColumnsRange();
            double colW = this.table.getColumnSize().getWidth();
            double cellH = this.table.getCellHeight();
            AtomicBoolean anyHidden = new AtomicBoolean(false);
            int firstRow = this.firstRow();
            int lastRow = Math.min(firstRow + this.maxRows() - 1, this.table.getItems().size() - 1);
            IntegerRange rowsRange = IntegerRange.of((Integer)firstRow, (Integer)lastRow);
            Map<Integer, TableRow<?>> rows = state.getRowsUnmodifiable();
            rows.entrySet().stream().filter(e -> !IntegerRange.inRangeOf((int)((Integer)e.getKey()), (IntegerRange)rowsRange)).peek(e -> anyHidden.set(true)).forEach(e -> ((TableRow)((Object)((Object)e.getValue()))).setVisible(false));
            List xPositions = this.positions.computeIfAbsent(Orientation.HORIZONTAL, o -> new ArrayList());
            Integer cRangeDiff = columnsRange.diff();
            if (forceXComputation || xPositions.isEmpty() || xPositions.size() != cRangeDiff + 1) {
                xPositions.clear();
                xPositions.addAll(DoubleStream.iterate((double)cRangeDiff.intValue() * colW, x -> x - colW).limit(cRangeDiff + 1).boxed().collect(Collectors.toList()));
            }
            List yPositions = this.positions.computeIfAbsent(Orientation.VERTICAL, o -> new ArrayList());
            Integer rRangeDiff = rowsRange.diff();
            if (anyHidden.get() || forceYComputation || yPositions.isEmpty() || yPositions.size() != rRangeDiff + 1) {
                yPositions.clear();
                double pos = (double)rRangeDiff.intValue() * cellH;
                for (int i = firstRow; i <= lastRow; ++i) {
                    TableRow<?> row = rows.get(i);
                    yPositions.add(pos);
                    pos -= cellH;
                    row.setVisible(true);
                }
            }
            return this.positions;
        }

        @Override
        public void layout() {
            TableState state = this.table.getState();
            if (state.isEmptyAll()) {
                this.layoutInitialized.set(false);
                return;
            }
            if (!this.table.isNeedsViewportLayout() || this.invalidatedPos()) {
                return;
            }
            Map<Orientation, List<Double>> positions = this.computePositions(state, false, false);
            double colW = this.table.getColumnSize().getWidth();
            double colH = this.table.getColumnSize().getHeight();
            IntegerRange columnsRange = state.getColumnsRange();
            double xOffset = this.horizontalOffset();
            List<Double> xPositions = positions.get(Orientation.HORIZONTAL);
            int xI = xPositions.size() - 1;
            double totalW = 0.0;
            for (Integer cIndex : columnsRange) {
                totalW += colW;
                TableColumn column = this.table.getColumn(cIndex);
                Region region = column.getRegion();
                Double xPos = xPositions.get(xI);
                if (cIndex.equals(columnsRange.getMax()) && totalW < this.table.getWidth()) {
                    region.resizeRelocate(xPos + xOffset, 0.0, this.table.getWidth() - totalW + colW, colH);
                } else {
                    region.resizeRelocate(xPos + xOffset, 0.0, colW, colH);
                }
                --xI;
            }
            if (!state.isEmpty()) {
                double cellH = this.table.getCellHeight();
                double yOffset = this.verticalOffset();
                List<Double> yPositions = positions.get(Orientation.VERTICAL);
                int yI = yPositions.size() - 1;
                Collection rows = state.getRowsUnmodifiable().values();
                for (TableRow row : rows) {
                    if (!row.isVisible()) continue;
                    xI = xPositions.size() - 1;
                    Double yPos = yPositions.get(yI);
                    double rowW = Math.max((double)row.size() * colW, this.table.getWidth());
                    row.resizeRelocate(xOffset, yPos + yOffset, rowW, cellH);
                    ArrayList cells = new ArrayList(row.getCellsUnmodifiable().values());
                    for (int i = 0; i < cells.size(); ++i) {
                        TableCell cell = (TableCell)cells.get(i);
                        TableColumn column = this.table.getColumn(i);
                        Node node = cell.getNode();
                        cell.beforeLayout();
                        node.resizeRelocate(xPositions.get(xI).doubleValue(), 0.0, column.getRegion().getWidth(), cellH);
                        cell.afterLayout();
                        --xI;
                    }
                    --yI;
                }
                this.layoutInitialized.set(totalW > 0.0);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this.pTable = null;
        }
    }
}

