/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table.paginated;

import io.github.palexdev.mfxcore.base.properties.styleable.StyleableIntegerProperty;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.cell.TableCell;
import io.github.palexdev.virtualizedfx.controls.VirtualScrollPane;
import io.github.palexdev.virtualizedfx.enums.ColumnsLayoutMode;
import io.github.palexdev.virtualizedfx.table.TableColumn;
import io.github.palexdev.virtualizedfx.table.TableHelper;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import io.github.palexdev.virtualizedfx.table.paginated.PaginatedHelper;
import io.github.palexdev.virtualizedfx.table.paginated.PaginatedVirtualTableSkin;
import io.github.palexdev.virtualizedfx.utils.VSPUtils;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.control.Skin;

public class PaginatedVirtualTable<T>
extends VirtualTable<T> {
    private final String STYLE_CLASS = "paginated-virtual-table";
    private final IntegerProperty currentPage = new SimpleIntegerProperty(1){

        public void set(int newValue) {
            int clamped = NumberUtils.clamp((int)newValue, (int)1, (int)PaginatedVirtualTable.this.getMaxPage());
            super.set(clamped);
        }

        protected void invalidated() {
            int page = this.get();
            PaginatedVirtualTable.this.changePage(page);
        }
    };
    private final ReadOnlyIntegerWrapper maxPage = new ReadOnlyIntegerWrapper(){

        public void set(int newValue) {
            int clamped = Math.max(1, newValue);
            super.set(clamped);
        }

        protected void invalidated() {
            int max = this.get();
            int curr = NumberUtils.clamp((int)PaginatedVirtualTable.this.getCurrentPage(), (int)1, (int)max);
            PaginatedVirtualTable.this.setCurrentPage(curr);
        }
    };
    private final StyleableIntegerProperty rowsPerPage = new StyleableIntegerProperty(StyleableProperties.ROWS_PER_PAGE, this, "rowsPerPage", 5){

        protected void invalidated() {
            PaginatedVirtualTable.this.updateMaxPage();
            PaginatedVirtualTable.this.changePage(PaginatedVirtualTable.this.getCurrentPage());
            PaginatedVirtualTable.this.requestViewportLayout();
        }
    };

    public PaginatedVirtualTable() {
        this.initialize();
    }

    public PaginatedVirtualTable(ObservableList<T> items, TableColumn<T, ? extends TableCell<T>> ... columns) {
        super(items, columns);
        this.initialize();
    }

    public PaginatedVirtualTable(ObservableList<T> items, ObservableList<TableColumn<T, ? extends TableCell<T>>> tableColumns) {
        super(items, tableColumns);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"paginated-virtual-table");
        this.setTableHelperSupplier(() -> {
            ColumnsLayoutMode mode = this.getColumnsLayoutMode();
            return mode == ColumnsLayoutMode.FIXED ? new PaginatedHelper.FixedPaginatedTableHelper(this) : new PaginatedHelper.VariablePaginatedTableHelper(this);
        });
    }

    public void goToPage(int page) {
        this.setCurrentPage(page);
    }

    public void goToFirstPage() {
        this.goToPage(1);
    }

    public void goToLastPage() {
        this.goToPage(this.getMaxPage());
    }

    public void updateMaxPage() {
        int rows = this.getItems().size();
        int rpp = this.getRowsPerPage();
        int max = (int)Math.ceil((double)rows / (double)rpp);
        this.setMaxPage(max);
    }

    protected void changePage(int page) {
        TableHelper helper = this.getTableHelper();
        if (!(helper instanceof PaginatedHelper)) {
            throw new IllegalStateException("The table's helper is not of type PaginatedHelper!");
        }
        this.updateMaxPage();
        PaginatedHelper pHelper = (PaginatedHelper)helper;
        pHelper.goToPage(page);
    }

    @Override
    public void scrollToFirstRow() {
        throw new UnsupportedOperationException("The paginated table cannot scroll to a desired row");
    }

    @Override
    public void scrollToLastRow() {
        throw new UnsupportedOperationException("The paginated table cannot scroll to a desired row");
    }

    @Override
    protected void onCellHeightChanged() {
        TableHelper helper = this.getTableHelper();
        if (helper != null) {
            helper.computeEstimatedSize();
        }
        if (this.getWidth() != 0.0 && this.getHeight() != 0.0) {
            if (!this.getViewportManager().init()) {
                this.requestViewportLayout();
            } else {
                this.goToPage(1);
                this.scrollToColumn(0);
            }
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new PaginatedVirtualTableSkin(this);
    }

    @Override
    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return PaginatedVirtualTable.getClassCssMetaData();
    }

    @Override
    public VirtualScrollPane wrap() {
        return VSPUtils.wrap(this);
    }

    public int getRowsPerPage() {
        return this.rowsPerPage.get();
    }

    public StyleableIntegerProperty rowsPerPageProperty() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage.set(rowsPerPage);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public int getCurrentPage() {
        return this.currentPage.get();
    }

    public IntegerProperty currentPageProperty() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage.set(currentPage);
    }

    public int getMaxPage() {
        return this.maxPage.get();
    }

    public ReadOnlyIntegerProperty maxPageProperty() {
        return this.maxPage.getReadOnlyProperty();
    }

    protected void setMaxPage(int maxPage) {
        this.maxPage.set(maxPage);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<PaginatedVirtualTable<?>> FACTORY = new StyleablePropertyFactory(VirtualTable.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<PaginatedVirtualTable<?>, Number> ROWS_PER_PAGE;

        private StyleableProperties() {
        }

        static {
            ROWS_PER_PAGE = FACTORY.createSizeCssMetaData("-fx-rows-per-page", PaginatedVirtualTable::rowsPerPageProperty, (Number)5);
            cssMetaDataList = StyleUtils.cssMetaDataList(VirtualTable.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{ROWS_PER_PAGE});
        }
    }
}

