/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.table.paginated;

import io.github.palexdev.mfxcore.utils.fx.NodeUtils;
import io.github.palexdev.virtualizedfx.table.VirtualTableSkin;
import io.github.palexdev.virtualizedfx.table.paginated.PaginatedVirtualTable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class PaginatedVirtualTableSkin<T>
extends VirtualTableSkin<T> {
    public PaginatedVirtualTableSkin(PaginatedVirtualTable<T> table) {
        super(table);
        NodeUtils.waitForScene(table, table::updateMaxPage, (boolean)false, (boolean)true);
    }

    protected PaginatedVirtualTable<T> getTable() {
        return (PaginatedVirtualTable)this.getSkinnable();
    }

    protected double getLength() {
        PaginatedVirtualTable<T> table = this.getTable();
        double cH = table.getColumnSize().getHeight();
        return (double)table.getRowsPerPage() * table.getCellHeight() + cH;
    }

    @Override
    protected void onListChanged(ObservableList<T> oldValue, ObservableList<T> newValue) {
        this.getTable().updateMaxPage();
        super.onListChanged(oldValue, newValue);
    }

    @Override
    protected void onItemsChanged(ListChangeListener.Change<? extends T> change) {
        this.getTable().updateMaxPage();
        super.onItemsChanged(change);
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.getLength();
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.getLength();
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.getLength();
    }
}

