/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.unused.simple;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.unused.simple.SimpleVirtualFlow;
import io.github.palexdev.virtualizedfx.unused.simple.SimpleVirtualFlowContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;

@Deprecated
public class CellsManager<T, C extends Cell<T>> {
    private final SimpleVirtualFlow<T, C> virtualFlow;
    private final SimpleVirtualFlowContainer<T, C> container;
    private final List<C> cellsPool = new ArrayList<C>();
    private final List<CellUpdate> updates = new ArrayList<CellUpdate>();
    private IntegerRange lastRange = IntegerRange.of((Integer)-1);
    private boolean listChanged;

    public CellsManager(SimpleVirtualFlowContainer<T, C> container) {
        this.virtualFlow = container.getVirtualFlow();
        this.container = container;
    }

    protected void initCells(int num) {
        this.cellsPool.clear();
        for (int i = 0; i < num && i < this.itemsSize(); ++i) {
            this.cellsPool.add(this.cellForIndex(i));
        }
        this.container.getChildren().setAll((Collection)this.cellsPool.stream().map(Cell::getNode).collect(Collectors.toList()));
        this.updateCells(0);
    }

    protected void updateCells(int start) {
        if (this.itemsEmpty()) {
            return;
        }
        int max = this.virtualFlow.getOrientationHelper().computeCellsNumber();
        int rEnd = NumberUtils.clamp((int)(start + max), (int)0, (int)this.itemsSize());
        IntegerRange range = IntegerRange.of((Integer)start, (Integer)rEnd);
        if (start == -1) {
            this.initCells(max);
            return;
        }
        if (this.lastRange.equals((Object)range) && !this.listChanged) {
            return;
        }
        this.updates.clear();
        this.cellsPool.forEach(cell -> cell.getNode().setVisible(false));
        int poolIndex = 0;
        for (int i = ((Integer)range.getMin()).intValue(); i < (Integer)range.getMax(); ++i) {
            Object item = this.virtualFlow.getItems().get(i);
            CellUpdate update = new CellUpdate(this, item, (Cell)this.cellsPool.get(poolIndex), i);
            this.updates.add(update);
            ++poolIndex;
        }
        this.updates.forEach(CellUpdate::update);
        this.processLayout(this.updates);
        this.lastRange = range;
    }

    public void itemsChanged() {
        if (this.itemsEmpty()) {
            this.clear();
            return;
        }
        if ((Integer)this.lastRange.getMin() == -1 || (Integer)this.lastRange.getMax() == -1) {
            int num = this.virtualFlow.getOrientationHelper().computeCellsNumber();
            this.initCells(num);
            return;
        }
        int num = this.virtualFlow.getOrientationHelper().computeCellsNumber();
        if (this.cellsPool.size() > num || this.cellsPool.size() > this.itemsSize()) {
            int overflow = this.cellsPool.size() > num ? this.cellsPool.size() - num : (this.cellsPool.size() > this.itemsSize() ? this.cellsPool.size() - this.itemsSize() : 0);
            for (int i = 0; i < overflow; ++i) {
                Cell cell = (Cell)this.cellsPool.remove(0);
                cell.dispose();
                this.container.getChildren().remove(0);
            }
        } else if (this.cellsPool.size() < num) {
            int max = NumberUtils.clamp((int)num, (int)0, (int)this.itemsSize());
            this.supplyCells(this.cellsPool.size(), max);
        }
        this.listChanged = true;
        this.updateCells((Integer)this.lastRange.getMin());
        this.listChanged = false;
    }

    protected void processLayout(List<CellUpdate> updates) {
        double cellW = this.container.getCellWidth();
        double cellH = this.container.getCellHeight();
        for (int i = 0; i < updates.size(); ++i) {
            CellUpdate update = updates.get(i);
            Object cell = update.cell;
            Node node = cell.getNode();
            node.setVisible(true);
            cell.beforeLayout();
            this.virtualFlow.getOrientationHelper().layout(node, i, cellW, cellH);
            cell.afterLayout();
        }
    }

    protected void requestLayout() {
        this.processLayout(this.updates);
    }

    protected void reset() {
        this.virtualFlow.scrollToPixel(0.0);
        this.clear();
        int max = this.virtualFlow.getOrientationHelper().computeCellsNumber();
        this.initCells(max);
    }

    protected void clear() {
        this.container.getChildren().clear();
        this.cellsPool.clear();
        this.updates.clear();
        this.lastRange = IntegerRange.of((Integer)-1);
    }

    protected void supplyCells(int from, int targetSize) {
        int i = from;
        while (this.cellsPool.size() < targetSize) {
            C cell = this.cellForIndex(i);
            this.cellsPool.add(cell);
            this.container.getChildren().add((Object)cell.getNode());
            ++i;
        }
    }

    protected C cellForIndex(int index) {
        Object item = this.virtualFlow.getItems().get(index);
        return this.cellForItem(item);
    }

    protected C cellForItem(T item) {
        return (C)((Cell)this.virtualFlow.getCellFactory().apply(item));
    }

    private int itemsSize() {
        return this.virtualFlow.getItems().size();
    }

    private boolean itemsEmpty() {
        return this.virtualFlow.getItems().isEmpty();
    }

    protected Map<Integer, C> getCells() {
        return this.updates.stream().collect(Collectors.toMap(u -> u.index, u -> u.cell));
    }

    private class CellUpdate {
        private final T item;
        private final C cell;
        private final int index;
        final /* synthetic */ CellsManager this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public CellUpdate(T item, C cell, int index) {
            this.this$0 = (CellsManager)n;
            this.item = item;
            this.cell = cell;
            this.index = index;
        }

        public void update() {
            this.cell.updateIndex(this.index);
            this.cell.updateItem(this.item);
        }
    }
}

