/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.unused.simple;

import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.unused.simple.CellsManager;
import io.github.palexdev.virtualizedfx.unused.simple.LayoutManager;
import io.github.palexdev.virtualizedfx.unused.simple.SimpleVirtualFlow;
import java.util.Map;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

@Deprecated
public class SimpleVirtualFlowContainer<T, C extends Cell<T>>
extends Region {
    private final SimpleVirtualFlow<T, C> virtualFlow;
    private final CellsManager<T, C> cellsManager;
    private final LayoutManager<T, C> layoutManager;
    private final ChangeListener<? super ObservableList<T>> listChanged;
    private final ListChangeListener<? super T> itemsChanged;

    public SimpleVirtualFlowContainer(SimpleVirtualFlow<T, C> virtualFlow) {
        this.virtualFlow = virtualFlow;
        this.cellsManager = new CellsManager(this);
        this.layoutManager = new LayoutManager(this);
        this.itemsChanged = c -> {
            if (!this.layoutManager.isInitialized()) {
                this.initialize();
            }
            this.cellsManager.itemsChanged();
        };
        this.listChanged = (observable, oldValue, newValue) -> {
            this.cellsManager.clear();
            virtualFlow.scrollToPixel(0.0);
            oldValue.removeListener(this.itemsChanged);
            newValue.addListener(this.itemsChanged);
            if (!this.layoutManager.isInitialized()) {
                this.layoutManager.initialize();
            } else {
                this.layoutManager.initFlow();
            }
        };
    }

    protected void initialize() {
        this.buildClip();
        this.virtualFlow.getItems().addListener(this.itemsChanged);
        this.virtualFlow.itemsProperty().addListener(this.listChanged);
        this.layoutManager.initialize();
    }

    private void buildClip() {
        Rectangle clip = new Rectangle();
        clip.heightProperty().bind((ObservableValue)this.virtualFlow.heightProperty());
        clip.widthProperty().bind((ObservableValue)this.virtualFlow.widthProperty());
        clip.layoutXProperty().bind((ObservableValue)this.layoutXProperty().multiply(-1));
        clip.layoutYProperty().bind((ObservableValue)this.layoutYProperty().multiply(-1));
        this.setClip((Node)clip);
    }

    protected void initCells(int num) {
        this.cellsManager.initCells(num);
    }

    protected void updateCells(int start) {
        this.cellsManager.updateCells(start);
    }

    public void update(double scrolled) {
        this.layoutManager.update(scrolled);
    }

    public void reset() {
        this.cellsManager.reset();
    }

    protected Map<Integer, C> getCells() {
        return this.cellsManager.getCells();
    }

    protected double getEstimatedHeight() {
        return this.layoutManager.getEstimatedHeight();
    }

    protected DoubleProperty estimatedHeightProperty() {
        return this.layoutManager.estimatedHeightProperty();
    }

    protected double getEstimatedWidth() {
        return this.layoutManager.getEstimatedWidth();
    }

    protected DoubleProperty estimatedWidthProperty() {
        return this.layoutManager.estimatedWidthProperty();
    }

    public double getCellHeight() {
        return this.layoutManager.getCellHeight();
    }

    public double getCellWidth() {
        return this.layoutManager.getCellWidth();
    }

    public void recomputeCellsSize() {
        if (this.virtualFlow.getItems().isEmpty()) {
            return;
        }
        Cell cell = (Cell)this.virtualFlow.getCellFactory().apply(this.virtualFlow.getItems().get(0));
        this.layoutManager.retrieveCellsSizes(cell);
    }

    public double getScrolled() {
        return this.layoutManager.getScrolled();
    }

    protected SimpleVirtualFlow<T, C> getVirtualFlow() {
        return this.virtualFlow;
    }

    protected CellsManager<T, C> getCellsManager() {
        return this.cellsManager;
    }

    protected LayoutManager<T, C> getLayoutManager() {
        return this.layoutManager;
    }

    protected ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    protected void layoutChildren() {
    }

    public void requestCellsLayout() {
        this.cellsManager.requestLayout();
    }
}

