/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.utils;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.base.beans.Size;
import io.github.palexdev.mfxcore.base.bindings.AbstractSource;
import io.github.palexdev.mfxcore.base.bindings.ExternalSource;
import io.github.palexdev.mfxcore.base.bindings.MFXBindings;
import io.github.palexdev.mfxcore.base.bindings.Mapper;
import io.github.palexdev.mfxcore.base.bindings.MappingSource;
import io.github.palexdev.mfxcore.builders.bindings.DoubleBindingBuilder;
import io.github.palexdev.mfxcore.builders.bindings.ObjectBindingBuilder;
import io.github.palexdev.mfxcore.utils.EnumUtils;
import io.github.palexdev.virtualizedfx.beans.VirtualBounds;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.cell.GridCell;
import io.github.palexdev.virtualizedfx.controls.VirtualScrollPane;
import io.github.palexdev.virtualizedfx.flow.OrientationHelper;
import io.github.palexdev.virtualizedfx.flow.VirtualFlow;
import io.github.palexdev.virtualizedfx.flow.paginated.PaginatedVirtualFlow;
import io.github.palexdev.virtualizedfx.grid.GridHelper;
import io.github.palexdev.virtualizedfx.grid.VirtualGrid;
import io.github.palexdev.virtualizedfx.grid.paginated.PaginatedVirtualGrid;
import io.github.palexdev.virtualizedfx.table.TableHelper;
import io.github.palexdev.virtualizedfx.table.VirtualTable;
import io.github.palexdev.virtualizedfx.table.paginated.PaginatedVirtualTable;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;

public class VSPUtils {
    private VSPUtils() {
    }

    public static <T, C extends Cell<T>> VirtualScrollPane wrap(VirtualFlow<T, C> flow) {
        VirtualScrollPane vsp = new VirtualScrollPane((Node)flow);
        MFXBindings bindings = MFXBindings.instance();
        vsp.orientationProperty().bind(flow.orientationProperty());
        vsp.contentBoundsProperty().bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
            Orientation o = flow.getOrientation();
            double breadth = flow.getMaxBreadth();
            double length = flow.getEstimatedLength();
            return o == Orientation.VERTICAL ? VirtualBounds.of(flow.getWidth(), flow.getHeight(), breadth, length) : VirtualBounds.of(flow.getWidth(), flow.getHeight(), length, breadth);
        }).addSources(new Observable[]{flow.orientationProperty(), flow.maxBreadthProperty(), flow.estimatedLengthProperty()}).get());
        MappingSource vSource = MappingSource.of((ObservableValue)flow.vPosProperty()).setTargetUpdater(Mapper.of(val -> {
            OrientationHelper helper = flow.getOrientationHelper();
            double max = helper.maxVScroll();
            return max != 0.0 ? val.doubleValue() / max : 0.0;
        }), (o, n) -> vsp.setVVal(n.doubleValue())).setSourceUpdater(Mapper.of(val -> {
            OrientationHelper helper = flow.getOrientationHelper();
            return val.doubleValue() * helper.maxVScroll();
        }), (o, n) -> flow.setVPos(n.doubleValue()));
        bindings.bindBidirectional((ObservableValue)vsp.vValProperty()).addSources(new AbstractSource[]{vSource}).addInvalidatingSource(ExternalSource.of((ObservableValue)flow.estimatedLengthProperty(), (o, n) -> {
            if (flow.getOrientation() != Orientation.VERTICAL) {
                return;
            }
            flow.getOrientationHelper().invalidatePos();
            bindings.biInvalidate((ObservableValue)vsp.vValProperty());
        })).get();
        MappingSource hSource = new MappingSource((ObservableValue)flow.hPosProperty()).setTargetUpdater(Mapper.of(val -> {
            OrientationHelper helper = flow.getOrientationHelper();
            double max = helper.maxHScroll();
            return max != 0.0 ? val.doubleValue() / max : 0.0;
        }), (o, n) -> vsp.setHVal(n.doubleValue())).setSourceUpdater(Mapper.of(val -> {
            OrientationHelper helper = flow.getOrientationHelper();
            return val.doubleValue() * helper.maxHScroll();
        }), (o, n) -> flow.setHPos(n.doubleValue()));
        bindings.bindBidirectional((ObservableValue)vsp.hValProperty()).addSource((AbstractSource)hSource).addInvalidatingSource(ExternalSource.of((ObservableValue)flow.estimatedLengthProperty(), (o, n) -> {
            if (flow.getOrientation() != Orientation.HORIZONTAL) {
                return;
            }
            flow.getOrientationHelper().invalidatePos();
            bindings.biInvalidate((ObservableValue)vsp.hValProperty());
        })).get();
        return vsp;
    }

    public static <T, C extends Cell<T>> VirtualScrollPane wrap(final PaginatedVirtualFlow<T, C> flow) {
        VirtualScrollPane vsp = new VirtualScrollPane((Node)flow){

            protected double computeMinHeight(double width) {
                Orientation o = flow.getOrientation();
                if (o == Orientation.VERTICAL) {
                    return this.computePrefHeight(width);
                }
                return super.computeMinHeight(width);
            }

            protected double computeMaxHeight(double width) {
                Orientation o = flow.getOrientation();
                if (o == Orientation.VERTICAL) {
                    return this.computePrefHeight(width);
                }
                return super.computeMaxHeight(width);
            }

            protected double computeMinWidth(double height) {
                Orientation o = flow.getOrientation();
                if (o == Orientation.HORIZONTAL) {
                    return this.computePrefWidth(height);
                }
                return super.computeMinWidth(height);
            }

            protected double computeMaxWidth(double height) {
                Orientation o = flow.getOrientation();
                if (o == Orientation.HORIZONTAL) {
                    return this.computePrefWidth(height);
                }
                return super.computeMaxWidth(height);
            }
        };
        vsp.orientationProperty().bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
            VSPUtils.createBindingsFor(vsp, flow);
            return (Orientation)EnumUtils.next(Orientation.class, (Enum)flow.getOrientation());
        }).addSources(new Observable[]{flow.orientationProperty()}).get());
        vsp.contentBoundsProperty().bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
            Orientation o = flow.getOrientation();
            double breadth = flow.getMaxBreadth();
            return o == Orientation.VERTICAL ? VirtualBounds.of(flow.getWidth(), flow.getHeight(), breadth, 0.0) : VirtualBounds.of(flow.getWidth(), flow.getHeight(), 0.0, breadth);
        }).addSources(new Observable[]{flow.orientationProperty()}).addSources(new Observable[]{flow.maxBreadthProperty()}).addSources(new Observable[]{flow.estimatedLengthProperty()}).get());
        return vsp;
    }

    public static <T, C extends GridCell<T>> VirtualScrollPane wrap(VirtualGrid<T, C> grid) {
        VirtualScrollPane vsp = new VirtualScrollPane((Node)grid);
        MFXBindings bindings = MFXBindings.instance();
        vsp.setOrientation(Orientation.VERTICAL);
        vsp.contentBoundsProperty().bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
            Size eSize = grid.getEstimatedSize();
            return VirtualBounds.of(grid.getWidth(), grid.getHeight(), eSize.getWidth(), eSize.getHeight());
        }).addSources(new Observable[]{grid.widthProperty(), grid.heightProperty(), grid.estimatedSizeProperty()}).get());
        MappingSource vSource = MappingSource.of((ObservableValue)grid.positionProperty()).setTargetUpdater(Mapper.of(val -> {
            GridHelper helper = grid.getGridHelper();
            double max = helper.maxVScroll();
            return max != 0.0 ? val.getY() / max : 0.0;
        }), (o, n) -> vsp.setVVal(n.doubleValue())).setSourceUpdater(Mapper.of(val -> {
            GridHelper helper = grid.getGridHelper();
            Position currPos = grid.getPosition();
            return Position.of((double)currPos.getX(), (double)(val.doubleValue() * helper.maxVScroll()));
        }), (o, n) -> grid.setPosition((Position)n));
        bindings.bindBidirectional((ObservableValue)vsp.vValProperty()).addSources(new AbstractSource[]{vSource}).addTargetInvalidatingSource((ObservableValue)grid.heightProperty()).get();
        MappingSource hSource = MappingSource.of((ObservableValue)grid.positionProperty()).setTargetUpdater(Mapper.of(val -> {
            GridHelper helper = grid.getGridHelper();
            double max = helper.maxHScroll();
            return max != 0.0 ? val.getX() / max : 0.0;
        }), (o, n) -> vsp.setHVal(n.doubleValue())).setSourceUpdater(Mapper.of(val -> {
            GridHelper helper = grid.getGridHelper();
            Position currPos = grid.getPosition();
            return Position.of((double)(val.doubleValue() * helper.maxHScroll()), (double)currPos.getY());
        }), (o, n) -> grid.setPosition((Position)n));
        bindings.bindBidirectional((ObservableValue)vsp.hValProperty()).addSources(new AbstractSource[]{hSource}).addTargetInvalidatingSource((ObservableValue)grid.widthProperty()).get();
        return vsp;
    }

    public static <T, C extends GridCell<T>> VirtualScrollPane wrap(final PaginatedVirtualGrid<T, C> grid) {
        MFXBindings bindings = MFXBindings.instance();
        VirtualScrollPane vsp = new VirtualScrollPane((Node)grid){

            protected double computeMinHeight(double width) {
                return this.computePrefHeight(width);
            }

            protected double computeMaxHeight(double width) {
                return this.computePrefHeight(width);
            }

            protected double computeMaxWidth(double height) {
                return grid.maxWidth(height);
            }
        };
        vsp.setOrientation(Orientation.HORIZONTAL);
        vsp.contentBoundsProperty().bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
            double breadth = grid.getEstimatedSize().getWidth();
            return VirtualBounds.of(grid.getWidth(), grid.getHeight(), breadth, 0.0);
        }).addSources(new Observable[]{grid.widthProperty(), grid.heightProperty(), grid.estimatedSizeProperty()}).get());
        MappingSource hSource = MappingSource.of((ObservableValue)grid.positionProperty()).setTargetUpdater(Mapper.of(val -> {
            GridHelper helper = grid.getGridHelper();
            double max = helper.maxHScroll();
            return max != 0.0 ? val.getX() / max : 0.0;
        }), (o, n) -> vsp.setHVal(n.doubleValue())).setSourceUpdater(Mapper.of(val -> {
            GridHelper helper = grid.getGridHelper();
            Position currPos = grid.getPosition();
            return Position.of((double)(val.doubleValue() * helper.maxHScroll()), (double)currPos.getY());
        }), (o, n) -> grid.setPosition((Position)n));
        bindings.bindBidirectional((ObservableValue)vsp.hValProperty()).addSources(new AbstractSource[]{hSource}).addTargetInvalidatingSource((ObservableValue)grid.widthProperty()).get();
        return vsp;
    }

    public static <T> VirtualScrollPane wrap(VirtualTable<T> table) {
        VirtualScrollPane vsp = new VirtualScrollPane((Node)table);
        MFXBindings bindings = MFXBindings.instance();
        vsp.setOrientation(Orientation.VERTICAL);
        vsp.vBarOffsetProperty().bind(table.columnSizeProperty().map(Size::getHeight));
        vsp.contentBoundsProperty().bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
            Size eSize = table.getEstimatedSize();
            double vH = Math.max(0.0, eSize.getHeight() + table.getColumnSize().getHeight());
            return VirtualBounds.of(table.getWidth(), table.getHeight(), eSize.getWidth(), vH);
        }).addSources(new Observable[]{table.widthProperty(), table.heightProperty(), table.columnSizeProperty(), table.estimatedSizeProperty()}).get());
        MappingSource vSource = MappingSource.of((ObservableValue)table.positionProperty()).setTargetUpdater(Mapper.of(val -> {
            TableHelper helper = table.getTableHelper();
            double max = helper.maxVScroll();
            return max != 0.0 ? val.getY() / max : 0.0;
        }), (o, n) -> vsp.setVVal(n.doubleValue())).setSourceUpdater(Mapper.of(val -> {
            TableHelper helper = table.getTableHelper();
            Position currPos = table.getPosition();
            return Position.of((double)currPos.getX(), (double)(val.doubleValue() * helper.maxVScroll()));
        }), (o, n) -> table.setPosition((Position)n));
        bindings.bindBidirectional((ObservableValue)vsp.vValProperty()).addSources(new AbstractSource[]{vSource}).addTargetInvalidatingSource((ObservableValue)table.heightProperty()).addInvalidatingSource(ExternalSource.of(table.estimatedSizeProperty(), (o, n) -> {
            if (o.getHeight() != n.getHeight()) {
                table.getTableHelper().invalidatedPos();
                bindings.biInvalidate((ObservableValue)vsp.vValProperty());
            }
        })).get();
        MappingSource hSource = MappingSource.of((ObservableValue)table.positionProperty()).setTargetUpdater(Mapper.of(val -> {
            TableHelper helper = table.getTableHelper();
            double max = helper.maxHScroll();
            return max != 0.0 ? val.getX() / max : 0.0;
        }), (o, n) -> vsp.setHVal(n.doubleValue())).setSourceUpdater(Mapper.of(val -> {
            TableHelper helper = table.getTableHelper();
            Position currPos = table.getPosition();
            return Position.of((double)(val.doubleValue() * helper.maxHScroll()), (double)currPos.getY());
        }), (o, n) -> table.setPosition((Position)n));
        bindings.bindBidirectional((ObservableValue)vsp.hValProperty()).addSources(new AbstractSource[]{hSource}).addTargetInvalidatingSource((ObservableValue)table.widthProperty()).addInvalidatingSource(ExternalSource.of(table.estimatedSizeProperty(), (o, n) -> {
            if (o.getWidth() != n.getWidth()) {
                table.getTableHelper().invalidatedPos();
                bindings.biInvalidate((ObservableValue)vsp.hValProperty());
            }
        })).get();
        return vsp;
    }

    public static <T> VirtualScrollPane wrap(final PaginatedVirtualTable<T> table) {
        MFXBindings bindings = MFXBindings.instance();
        VirtualScrollPane vsp = new VirtualScrollPane((Node)table){

            protected double computeMinHeight(double width) {
                return this.computePrefHeight(width);
            }

            protected double computePrefHeight(double width) {
                return super.computePrefHeight(width);
            }

            protected double computeMaxHeight(double width) {
                return this.computePrefHeight(width);
            }

            protected double computeMaxWidth(double height) {
                return table.maxWidth(height);
            }
        };
        vsp.setOrientation(Orientation.VERTICAL);
        vsp.contentBoundsProperty().bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
            Size eSize = table.getEstimatedSize();
            return VirtualBounds.of(table.getWidth(), table.getHeight(), eSize.getWidth(), 0.0);
        }).addSources(new Observable[]{table.widthProperty(), table.heightProperty(), table.estimatedSizeProperty()}).get());
        MappingSource hSource = MappingSource.of((ObservableValue)table.positionProperty()).setTargetUpdater(Mapper.of(val -> {
            TableHelper helper = table.getTableHelper();
            double max = helper.maxHScroll();
            return max != 0.0 ? val.getX() / max : 0.0;
        }), (o, n) -> vsp.setHVal(n.doubleValue())).setSourceUpdater(Mapper.of(val -> {
            TableHelper helper = table.getTableHelper();
            Position currPos = table.getPosition();
            return Position.of((double)(val.doubleValue() * helper.maxHScroll()), (double)currPos.getY());
        }), (o, n) -> table.setPosition((Position)n));
        bindings.bindBidirectional((ObservableValue)vsp.hValProperty()).addSources(new AbstractSource[]{hSource}).addTargetInvalidatingSource((ObservableValue)table.widthProperty()).addInvalidatingSource(ExternalSource.of(table.estimatedSizeProperty(), (o, n) -> {
            if (o.getWidth() != n.getWidth()) {
                table.getTableHelper().invalidatedPos();
                bindings.biInvalidate((ObservableValue)vsp.hValProperty());
            }
        })).get();
        return vsp;
    }

    public static void setHSpeed(VirtualScrollPane vsp, double unitIncrement, double smoothUnit, double trackIncrement) {
        vsp.hUnitIncrementProperty().bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> {
            Orientation o = vsp.getOrientation();
            VirtualBounds cBounds = vsp.getContentBounds();
            double viewL = cBounds.getWidth();
            double contentL = vsp.getContent() != null && vsp.getContent() instanceof VirtualFlow ? (o == Orientation.VERTICAL ? cBounds.getVirtualHeight() : cBounds.getVirtualWidth()) : cBounds.getVirtualWidth();
            double pixels = vsp.isSmoothScroll() ? smoothUnit : unitIncrement;
            return Math.max(0.0, pixels / (contentL - viewL));
        }).addSources(new Observable[]{vsp.orientationProperty(), vsp.heightProperty(), vsp.widthProperty()}).addSources(new Observable[]{vsp.contentBoundsProperty(), vsp.smoothScrollProperty()}).get());
        vsp.hTrackIncrementProperty().bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> {
            Orientation o = vsp.getOrientation();
            VirtualBounds cBounds = vsp.getContentBounds();
            double viewL = cBounds.getWidth();
            double contentL = o == Orientation.VERTICAL ? cBounds.getVirtualHeight() : cBounds.getVirtualWidth();
            return Math.max(0.0, trackIncrement / (contentL - viewL));
        }).addSources(new Observable[]{vsp.orientationProperty(), vsp.heightProperty(), vsp.widthProperty(), vsp.contentBoundsProperty()}).get());
    }

    public static void setVSpeed(VirtualScrollPane vsp, double unitIncrement, double smoothUnit, double trackIncrement) {
        vsp.vUnitIncrementProperty().bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> {
            Orientation o = vsp.getOrientation();
            VirtualBounds cBounds = vsp.getContentBounds();
            double viewL = cBounds.getHeight();
            double contentL = vsp.getContent() != null && vsp.getContent() instanceof VirtualFlow ? (o == Orientation.VERTICAL ? cBounds.getVirtualHeight() : cBounds.getVirtualWidth()) : cBounds.getVirtualHeight();
            double pixels = vsp.isSmoothScroll() ? smoothUnit : unitIncrement;
            return Math.max(0.0, pixels / (contentL - viewL));
        }).addSources(new Observable[]{vsp.orientationProperty(), vsp.heightProperty(), vsp.widthProperty()}).addSources(new Observable[]{vsp.contentBoundsProperty(), vsp.smoothScrollProperty()}).get());
        vsp.vTrackIncrementProperty().bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> {
            Orientation o = vsp.getOrientation();
            VirtualBounds cBounds = vsp.getContentBounds();
            double viewL = cBounds.getHeight();
            double contentL = o == Orientation.VERTICAL ? cBounds.getVirtualHeight() : cBounds.getVirtualWidth();
            return Math.max(0.0, trackIncrement / (contentL - viewL));
        }).addSources(new Observable[]{vsp.orientationProperty(), vsp.heightProperty(), vsp.widthProperty(), vsp.contentBoundsProperty()}).get());
    }

    private static <T, C extends Cell<T>> void createBindingsFor(VirtualScrollPane vsp, PaginatedVirtualFlow<T, C> flow) {
        MappingSource source;
        DoubleProperty prop;
        MFXBindings bindings = MFXBindings.instance();
        bindings.disposeBidirectional((ObservableValue)vsp.vValProperty());
        bindings.disposeBidirectional((ObservableValue)vsp.hValProperty());
        Orientation o = flow.getOrientation();
        if (o == Orientation.HORIZONTAL) {
            prop = vsp.vValProperty();
            source = MappingSource.of((ObservableValue)flow.vPosProperty()).setTargetUpdater(Mapper.of(val -> {
                OrientationHelper helper = flow.getOrientationHelper();
                double max = helper.maxVScroll();
                return max != 0.0 ? val.doubleValue() / max : 0.0;
            }), (ov, n) -> vsp.setVVal(n.doubleValue())).setSourceUpdater(Mapper.of(val -> {
                OrientationHelper helper = flow.getOrientationHelper();
                return val.doubleValue() * helper.maxVScroll();
            }), (ov, n) -> flow.setVPos(n.doubleValue()));
        } else {
            prop = vsp.hValProperty();
            source = MappingSource.of((ObservableValue)flow.hPosProperty()).setTargetUpdater(Mapper.of(val -> {
                OrientationHelper helper = flow.getOrientationHelper();
                double max = helper.maxHScroll();
                return max != 0.0 ? val.doubleValue() / max : 0.0;
            }), (ov, n) -> vsp.setHVal(n.doubleValue())).setSourceUpdater(Mapper.of(val -> {
                OrientationHelper helper = flow.getOrientationHelper();
                return val.doubleValue() * helper.maxHScroll();
            }), (ov, n) -> flow.setHPos(n.doubleValue()));
        }
        bindings.bindBidirectional((ObservableValue)prop).addSources(new AbstractSource[]{source}).get();
    }

    public static void disposeFor(VirtualScrollPane vsp) {
        MFXBindings bindings = MFXBindings.instance();
        bindings.disposeBidirectional((ObservableValue)vsp.vValProperty());
        bindings.disposeBidirectional((ObservableValue)vsp.hValProperty());
    }
}

