/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.base;

import io.github.palexdev.virtualizedfx.base.VFXContainer;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;

public interface Paginated<T>
extends VFXContainer<T> {
    default public int getPage() {
        return this.pageProperty().get();
    }

    public IntegerProperty pageProperty();

    default public void setPage(int page) {
        this.pageProperty().set(page);
    }

    default public int getMaxPage() {
        return this.maxPageProperty().get();
    }

    public ReadOnlyIntegerProperty maxPageProperty();

    default public int getCellsPerPage() {
        return this.cellsPerPageProperty().get();
    }

    public IntegerProperty cellsPerPageProperty();

    default public void setCellsPerPage(int cellsPerPage) {
        this.cellsPerPageProperty().set(cellsPerPage);
    }

    default public void next() {
        this.setPage(this.getPage() + 1);
    }

    default public void previous() {
        this.setPage(this.getPage() - 1);
    }

    default public void moveBy(int delta) {
        this.setPage(this.getPage() + delta);
    }

    default public int findPageByIndex(int index) {
        if (this.isEmpty() || this.getMaxPage() == 0 || index < 0) {
            return 0;
        }
        if (index > this.size() - 1) {
            return this.getMaxPage();
        }
        return index / this.getCellsPerPage();
    }

    default public int computeMaxPage() {
        int items = this.size();
        int cpp = this.getCellsPerPage();
        return Math.max(0, (int)Math.ceil((double)items / (double)cpp) - 1);
    }
}

