/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.cells;

import io.github.palexdev.mfxcore.controls.Control;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.cells.CellBaseBehavior;
import java.util.function.Supplier;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;

public abstract class CellBase<T>
extends Control<CellBaseBehavior<T>>
implements Cell<T> {
    private final IntegerProperty index = new SimpleIntegerProperty();
    private final ObjectProperty<T> item = new SimpleObjectProperty();

    public CellBase() {
        this.initialize();
    }

    public CellBase(T item) {
        this();
        this.updateItem(item);
    }

    protected void initialize() {
        this.getStyleClass().add((Object)"cell-base");
        this.setDefaultBehaviorProvider();
    }

    @Override
    public Node toNode() {
        return this;
    }

    @Override
    public void updateItem(T item) {
        this.setItem(item);
    }

    @Override
    public void updateIndex(int index) {
        this.setIndex(index);
    }

    public Supplier<CellBaseBehavior<T>> defaultBehaviorProvider() {
        return () -> new CellBaseBehavior(this);
    }

    public int getIndex() {
        return this.index.get();
    }

    public IntegerProperty indexProperty() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index.set(index);
    }

    public T getItem() {
        return (T)this.item.get();
    }

    public ObjectProperty<T> itemProperty() {
        return this.item;
    }

    public void setItem(T item) {
        this.item.set(item);
    }
}

