/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.Size;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.properties.functional.FunctionProperty;
import io.github.palexdev.mfxcore.base.properties.functional.SupplierProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableIntegerProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableSizeProperty;
import io.github.palexdev.mfxcore.controls.Control;
import io.github.palexdev.mfxcore.controls.SkinBase;
import io.github.palexdev.mfxcore.utils.PositionUtils;
import io.github.palexdev.mfxcore.utils.fx.PropUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.base.VFXContainer;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.enums.BufferSize;
import io.github.palexdev.virtualizedfx.grid.VFXGridHelper;
import io.github.palexdev.virtualizedfx.grid.VFXGridManager;
import io.github.palexdev.virtualizedfx.grid.VFXGridSkin;
import io.github.palexdev.virtualizedfx.grid.VFXGridState;
import io.github.palexdev.virtualizedfx.properties.VFXGridStateProperty;
import io.github.palexdev.virtualizedfx.utils.VFXCellsCache;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Pos;

public class VFXGrid<T, C extends Cell<T>>
extends Control<VFXGridManager<T, C>>
implements VFXContainer<T> {
    private final VFXCellsCache<T, C> cache;
    private final ListProperty<T> items = new SimpleListProperty<T>(this, FXCollections.observableArrayList()){

        public void set(ObservableList<T> newValue) {
            if (newValue == null) {
                newValue = FXCollections.observableArrayList();
            }
            super.set(newValue);
        }
    };
    private final FunctionProperty<T, C> cellFactory = new FunctionProperty<T, C>(){

        protected void invalidated() {
            VFXGrid.this.cache.setCellFactory((Function)this.get());
        }
    };
    private final ReadOnlyObjectWrapper<VFXGridHelper<T, C>> helper = new ReadOnlyObjectWrapper<VFXGridHelper<T, C>>(this){

        public void set(VFXGridHelper<T, C> newValue) {
            if (newValue == null) {
                throw new NullPointerException("Grid helper cannot be null!");
            }
            VFXGridHelper oldValue = (VFXGridHelper)this.get();
            if (oldValue != null) {
                oldValue.dispose();
            }
            super.set(newValue);
        }
    };
    private final SupplierProperty<VFXGridHelper<T, C>> helperFactory = new SupplierProperty<VFXGridHelper<T, C>>(this.defaultHelperFactory()){

        public void set(Supplier<VFXGridHelper<T, C>> newValue) {
            if (newValue == null) {
                throw new NullPointerException("Grid helper factory cannot be null!");
            }
            super.set(newValue);
        }

        protected void invalidated() {
            VFXGridHelper helper = (VFXGridHelper)((Supplier)this.get()).get();
            VFXGrid.this.setHelper(helper);
        }
    };
    private final DoubleProperty vPos = PropUtils.clampedDoubleProperty(() -> 0.0, () -> this.getHelper().maxVScroll());
    private final DoubleProperty hPos = PropUtils.clampedDoubleProperty(() -> 0.0, () -> this.getHelper().maxHScroll());
    private final VFXGridStateProperty<T, C> state = new VFXGridStateProperty(VFXGridState.EMPTY);
    private final ReadOnlyBooleanWrapper needsViewportLayout = new ReadOnlyBooleanWrapper(false);
    private final StyleableSizeProperty cellSize = new StyleableSizeProperty(StyleableProperties.CELL_SIZE, (Object)this, "cellSize", Size.of((double)100.0, (double)100.0));
    private final StyleableIntegerProperty columnsNum = new StyleableIntegerProperty(StyleableProperties.COLUMNS_NUM, (Object)this, "columnsNum", Integer.valueOf(5));
    private final StyleableObjectProperty<Pos> alignment = new StyleableObjectProperty<Pos>(this, StyleableProperties.ALIGNMENT, (Object)this, "alignment", Pos.TOP_LEFT){

        public void set(Pos v) {
            if (PositionUtils.isBaseline((Pos)v)) {
                v = Pos.TOP_LEFT;
            }
            super.set((Object)v);
        }
    };
    private final StyleableDoubleProperty hSpacing = new StyleableDoubleProperty(StyleableProperties.H_SPACING, (Object)this, "hSpacing", Double.valueOf(0.0));
    private final StyleableDoubleProperty vSpacing = new StyleableDoubleProperty(StyleableProperties.V_SPACING, (Object)this, "vSpacing", Double.valueOf(0.0));
    private final StyleableObjectProperty<BufferSize> bufferSize = new StyleableObjectProperty(StyleableProperties.BUFFER_SIZE, (Object)this, "bufferSize", (Object)BufferSize.standard());
    private final StyleableDoubleProperty clipBorderRadius = new StyleableDoubleProperty(StyleableProperties.CLIP_BORDER_RADIUS, (Object)this, "clipBorderRadius", Double.valueOf(0.0));
    private final StyleableIntegerProperty cacheCapacity = new StyleableIntegerProperty(StyleableProperties.CACHE_CAPACITY, this, "cacheCapacity", 10){

        protected void invalidated() {
            VFXGrid.this.cache.setCapacity(this.get());
        }
    };

    public VFXGrid() {
        this.cache = this.createCache();
        this.initialize();
    }

    public VFXGrid(ObservableList<T> items, Function<T, C> cellFactory) {
        this();
        this.setItems(items);
        this.setCellFactory(cellFactory);
    }

    private void initialize() {
        this.getStyleClass().addAll(this.defaultStyleClasses());
        this.setDefaultBehaviorProvider();
        this.setHelper(this.getHelperFactory().get());
    }

    public void autoArrange() {
        this.autoArrange(0);
    }

    public void autoArrange(int min) {
        double cellWidth = this.getCellSize().getWidth();
        double hSpacing = this.getHSpacing();
        int nColumns = (int)Math.max((double)Math.max(0, min), Math.floor(this.getWidth() / (cellWidth + hSpacing)));
        this.setColumnsNum(nColumns);
    }

    protected VFXCellsCache<T, C> createCache() {
        return new VFXCellsCache(null, this.getCacheCapacity());
    }

    protected void update(VFXGridState<T, C> state) {
        this.setState(state);
    }

    protected Supplier<VFXGridHelper<T, C>> defaultHelperFactory() {
        return () -> new VFXGridHelper.DefaultHelper(this);
    }

    public void requestViewportLayout() {
        this.setNeedsViewportLayout(true);
    }

    @Override
    public List<String> defaultStyleClasses() {
        return List.of("vfx-grid");
    }

    protected SkinBase<?, ?> buildSkin() {
        return new VFXGridSkin(this);
    }

    public Supplier<VFXGridManager<T, C>> defaultBehaviorProvider() {
        return () -> new VFXGridManager(this);
    }

    public VFXGrid<T, C> populateCache() {
        this.cache.populate();
        return this;
    }

    @Override
    public ReadOnlyIntegerProperty sizeProperty() {
        return this.items.sizeProperty();
    }

    @Override
    public ReadOnlyBooleanProperty emptyProperty() {
        return this.items.emptyProperty();
    }

    public IntegerRange getRowsRange() {
        return this.getState().getRowsRange();
    }

    public IntegerRange getColumnsRange() {
        return this.getState().getColumnsRange();
    }

    public SequencedMap<Integer, C> getCellsByIndexUnmodifiable() {
        return this.getState().getCellsByIndexUnmodifiable();
    }

    public Map<T, C> getCellsByItemUnmodifiable() {
        return this.getState().getCellsByItemUnmodifiable();
    }

    @Override
    public ReadOnlyDoubleProperty virtualMaxXProperty() {
        return this.getHelper().virtualMaxXProperty();
    }

    @Override
    public ReadOnlyDoubleProperty virtualMaxYProperty() {
        return this.getHelper().virtualMaxYProperty();
    }

    public void scrollToRow(int row) {
        this.getHelper().scrollToRow(row);
    }

    public void scrollToColumn(int column) {
        this.getHelper().scrollToColumn(column);
    }

    public void scrollToFirstRow() {
        this.scrollToRow(0);
    }

    public void scrollToLastRow() {
        this.scrollToRow(Integer.MAX_VALUE);
    }

    public void scrollToFirstColumn() {
        this.scrollToColumn(0);
    }

    public void scrollToLastColumn() {
        this.scrollToColumn(Integer.MAX_VALUE);
    }

    public Size getCellSize() {
        return (Size)this.cellSize.get();
    }

    public StyleableSizeProperty cellSizeProperty() {
        return this.cellSize;
    }

    public void setCellSize(Size cellSize) {
        this.cellSize.set((Object)cellSize);
    }

    public void setCellSize(double w, double h) {
        this.setCellSize(Size.of((double)w, (double)h));
    }

    public void setCellSize(double size) {
        this.setCellSize(Size.of((double)size, (double)size));
    }

    public int getColumnsNum() {
        return this.columnsNum.get();
    }

    public StyleableIntegerProperty columnsNumProperty() {
        return this.columnsNum;
    }

    public void setColumnsNum(int columnsNum) {
        this.columnsNum.set(columnsNum);
    }

    public Pos getAlignment() {
        return (Pos)this.alignment.get();
    }

    public StyleableObjectProperty<Pos> alignmentProperty() {
        return this.alignment;
    }

    public void setAlignment(Pos alignment) {
        this.alignment.set((Object)alignment);
    }

    public double getHSpacing() {
        return this.hSpacing.get();
    }

    public StyleableDoubleProperty hSpacingProperty() {
        return this.hSpacing;
    }

    public void setHSpacing(double spacing) {
        this.hSpacing.set(spacing);
    }

    public double getVSpacing() {
        return this.vSpacing.get();
    }

    public StyleableDoubleProperty vSpacingProperty() {
        return this.vSpacing;
    }

    public void setVSpacing(double spacing) {
        this.vSpacing.set(spacing);
    }

    public void setSpacing(double spacing) {
        this.setHSpacing(spacing);
        this.setVSpacing(spacing);
    }

    public void setSpacing(double hSpacing, double vSpacing) {
        this.setHSpacing(hSpacing);
        this.setVSpacing(vSpacing);
    }

    @Override
    public StyleableObjectProperty<BufferSize> bufferSizeProperty() {
        return this.bufferSize;
    }

    public double getClipBorderRadius() {
        return this.clipBorderRadius.get();
    }

    public StyleableDoubleProperty clipBorderRadiusProperty() {
        return this.clipBorderRadius;
    }

    public void setClipBorderRadius(double clipBorderRadius) {
        this.clipBorderRadius.set(clipBorderRadius);
    }

    public int getCacheCapacity() {
        return this.cacheCapacity.get();
    }

    public StyleableIntegerProperty cacheCapacityProperty() {
        return this.cacheCapacity;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity.set(cacheCapacity);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return VFXGrid.getClassCssMetaData();
    }

    protected VFXCellsCache<T, C> getCache() {
        return this.cache;
    }

    public int cacheSize() {
        return this.cache.size();
    }

    @Override
    public ListProperty<T> itemsProperty() {
        return this.items;
    }

    public Function<T, C> getCellFactory() {
        return (Function)this.cellFactory.get();
    }

    public FunctionProperty<T, C> cellFactoryProperty() {
        return this.cellFactory;
    }

    public void setCellFactory(Function<T, C> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    public VFXGridHelper<T, C> getHelper() {
        return (VFXGridHelper)this.helper.get();
    }

    public ReadOnlyObjectProperty<VFXGridHelper<T, C>> helperProperty() {
        return this.helper.getReadOnlyProperty();
    }

    protected void setHelper(VFXGridHelper<T, C> helper) {
        this.helper.set(helper);
    }

    public Supplier<VFXGridHelper<T, C>> getHelperFactory() {
        return (Supplier)this.helperFactory.get();
    }

    public SupplierProperty<VFXGridHelper<T, C>> helperFactoryProperty() {
        return this.helperFactory;
    }

    public void setHelperFactory(Supplier<VFXGridHelper<T, C>> helperFactory) {
        this.helperFactory.set(helperFactory);
    }

    @Override
    public DoubleProperty vPosProperty() {
        return this.vPos;
    }

    @Override
    public DoubleProperty hPosProperty() {
        return this.hPos;
    }

    public VFXGridState<T, C> getState() {
        return (VFXGridState)this.state.get();
    }

    public ReadOnlyObjectProperty<VFXGridState<T, C>> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    protected void setState(VFXGridState<T, C> state) {
        this.state.set(state);
    }

    public boolean isNeedsViewportLayout() {
        return this.needsViewportLayout.get();
    }

    public ReadOnlyBooleanProperty needsViewportLayoutProperty() {
        return this.needsViewportLayout.getReadOnlyProperty();
    }

    protected void setNeedsViewportLayout(boolean needsViewportLayout) {
        this.needsViewportLayout.set(needsViewportLayout);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<VFXGrid<?, ?>> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<VFXGrid<?, ?>, Size> CELL_SIZE;
        private static final CssMetaData<VFXGrid<?, ?>, Number> COLUMNS_NUM;
        private static final CssMetaData<VFXGrid<?, ?>, Pos> ALIGNMENT;
        private static final CssMetaData<VFXGrid<?, ?>, Number> H_SPACING;
        private static final CssMetaData<VFXGrid<?, ?>, Number> V_SPACING;
        private static final CssMetaData<VFXGrid<?, ?>, Number> CLIP_BORDER_RADIUS;
        private static final CssMetaData<VFXGrid<?, ?>, Number> CACHE_CAPACITY;
        private static final CssMetaData<VFXGrid<?, ?>, BufferSize> BUFFER_SIZE;

        private StyleableProperties() {
        }

        static {
            CELL_SIZE = new CssMetaData<VFXGrid<?, ?>, Size>("-vfx-cell-size", StyleableSizeProperty.SizeConverter.getInstance(), Size.of((double)100.0, (double)100.0)){

                public boolean isSettable(VFXGrid<?, ?> styleable) {
                    return !styleable.cellSizeProperty().isBound();
                }

                public StyleableProperty<Size> getStyleableProperty(VFXGrid<?, ?> styleable) {
                    return styleable.cellSizeProperty();
                }
            };
            COLUMNS_NUM = FACTORY.createSizeCssMetaData("-vfx-columns-num", VFXGrid::columnsNumProperty, (Number)5);
            ALIGNMENT = FACTORY.createEnumCssMetaData(Pos.class, "-vfx-alignment", VFXGrid::alignmentProperty, (Enum)Pos.TOP_LEFT);
            H_SPACING = FACTORY.createSizeCssMetaData("-vfx-h-spacing", VFXGrid::hSpacingProperty, (Number)0.0);
            V_SPACING = FACTORY.createSizeCssMetaData("-vfx-v-spacing", VFXGrid::vSpacingProperty, (Number)0.0);
            CLIP_BORDER_RADIUS = FACTORY.createSizeCssMetaData("-vfx-clip-border-radius", VFXGrid::clipBorderRadiusProperty, (Number)0.0);
            CACHE_CAPACITY = FACTORY.createSizeCssMetaData("-vfx-cache-capacity", VFXGrid::cacheCapacityProperty, (Number)10);
            BUFFER_SIZE = FACTORY.createEnumCssMetaData(BufferSize.class, "-vfx-buffer-size", VFXGrid::bufferSizeProperty, (Enum)BufferSize.standard());
            cssMetaDataList = StyleUtils.cssMetaDataList((List)Control.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{CELL_SIZE, COLUMNS_NUM, ALIGNMENT, H_SPACING, V_SPACING, BUFFER_SIZE, CACHE_CAPACITY, CLIP_BORDER_RADIUS});
        }
    }
}

