/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.base.beans.Size;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.beans.range.NumberRange;
import io.github.palexdev.mfxcore.base.properties.PositionProperty;
import io.github.palexdev.mfxcore.base.properties.SizeProperty;
import io.github.palexdev.mfxcore.base.properties.range.IntegerRangeProperty;
import io.github.palexdev.mfxcore.builders.bindings.DoubleBindingBuilder;
import io.github.palexdev.mfxcore.builders.bindings.ObjectBindingBuilder;
import io.github.palexdev.mfxcore.utils.GridUtils;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.grid.VFXGrid;
import io.github.palexdev.virtualizedfx.utils.Utils;
import io.github.palexdev.virtualizedfx.utils.VFXCellsCache;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public interface VFXGridHelper<T, C extends Cell<T>> {
    public int maxColumns();

    public int firstColumn();

    public int lastColumn();

    public int visibleColumns();

    public int totalColumns();

    public ReadOnlyObjectProperty<NumberRange<Integer>> columnsRangeProperty();

    default public IntegerRange columnsRange() {
        return (IntegerRange)this.columnsRangeProperty().get();
    }

    public int maxRows();

    public int firstRow();

    public int lastRow();

    public int visibleRows();

    public int totalRows();

    public ReadOnlyObjectProperty<NumberRange<Integer>> rowsRangeProperty();

    default public IntegerRange rowsRange() {
        return (IntegerRange)this.rowsRangeProperty().get();
    }

    public double maxHScroll();

    public double maxVScroll();

    public ReadOnlyDoubleProperty virtualMaxXProperty();

    default public double getVirtualMaxX() {
        return this.virtualMaxXProperty().get();
    }

    public ReadOnlyDoubleProperty virtualMaxYProperty();

    default public double getVirtualMaxY() {
        return this.virtualMaxYProperty().get();
    }

    public ReadOnlyObjectProperty<Position> viewportPositionProperty();

    default public Position getViewportPosition() {
        return (Position)this.viewportPositionProperty().get();
    }

    public void layout(int var1, int var2, Node var3);

    public Size getTotalCellSize();

    public VFXGrid<T, C> getGrid();

    default public int visibleCells() {
        int nColumns = this.visibleColumns();
        int nRows = this.visibleRows();
        return nColumns * nRows;
    }

    default public int totalCells() {
        VFXGrid<T, C> grid = this.getGrid();
        int cnt = 0;
        int nColumns = this.maxColumns();
        IntegerRange rRange = this.rowsRange();
        IntegerRange cRange = this.columnsRange();
        int nCells = cRange.diff() + 1;
        for (Integer rIdx : rRange) {
            int linear = GridUtils.subToInd((int)nColumns, (int)rIdx, (int)((Integer)cRange.getMax()));
            if (linear < grid.size()) {
                cnt += nCells;
                continue;
            }
            int rowStart = GridUtils.subToInd((int)nColumns, (int)rIdx, (int)((Integer)cRange.getMin()));
            int max = Math.min(grid.size(), linear) - 1;
            if (max < rowStart) break;
            cnt += max - rowStart + 1;
        }
        return cnt;
    }

    default public void scrollToRow(int row) {
        double h = this.getTotalCellSize().getHeight();
        this.getGrid().setVPos((double)row * h);
    }

    default public void scrollToColumn(int column) {
        double w = this.getTotalCellSize().getWidth();
        this.getGrid().setHPos((double)column * w);
    }

    default public void invalidatePos() {
        VFXGrid<T, C> grid = this.getGrid();
        grid.setVPos(grid.getVPos());
        grid.setHPos(grid.getHPos());
    }

    default public T indexToItem(int index) {
        return (T)this.getGrid().getItems().get(index);
    }

    default public C indexToCell(int index) {
        T item = this.indexToItem(index);
        return this.itemToCell(item);
    }

    default public C itemToCell(T item) {
        VFXGrid grid = this.getGrid();
        VFXCellsCache<T, C> cache = grid.getCache();
        Optional<C> opt = cache.tryTake();
        opt.ifPresent(c -> c.updateItem(item));
        return (C)opt.orElseGet(() -> (Cell)grid.getCellFactory().apply(item));
    }

    default public void dispose() {
    }

    public static class DefaultHelper<T, C extends Cell<T>>
    implements VFXGridHelper<T, C> {
        protected final VFXGrid<T, C> grid;
        protected final IntegerRangeProperty columnsRange = new IntegerRangeProperty();
        protected final IntegerRangeProperty rowsRange = new IntegerRangeProperty();
        protected final ReadOnlyDoubleWrapper virtualMaxX = new ReadOnlyDoubleWrapper();
        protected final ReadOnlyDoubleWrapper virtualMaxY = new ReadOnlyDoubleWrapper();
        protected final PositionProperty viewportPosition = new PositionProperty();
        protected final SizeProperty totalCellSize = new SizeProperty(Size.empty());

        public DefaultHelper(VFXGrid<T, C> grid) {
            this.grid = grid;
            this.columnsRange.bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
                if (grid.getWidth() <= 0.0) {
                    return Utils.INVALID_RANGE;
                }
                int needed = this.totalColumns();
                if (needed == 0) {
                    return Utils.INVALID_RANGE;
                }
                int start = Math.max(0, this.firstColumn() - grid.getBufferSize().val());
                int end = Math.min(this.maxColumns() - 1, start + this.totalColumns() - 1);
                if (end - start + 1 < needed) {
                    start = Math.max(0, end - needed + 1);
                }
                return IntegerRange.of((Integer)start, (Integer)end);
            }).addSources(new Observable[]{grid.columnsNumProperty()}).addSources(new Observable[]{grid.widthProperty()}).addSources(new Observable[]{grid.hPosProperty()}).addSources(new Observable[]{grid.bufferSizeProperty()}).addSources(new Observable[]{grid.sizeProperty(), grid.cellSizeProperty(), grid.hSpacingProperty()}).get());
            this.rowsRange.bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
                if (grid.getHeight() == 0.0) {
                    return Utils.INVALID_RANGE;
                }
                int needed = this.totalRows();
                if (needed == 0) {
                    return Utils.INVALID_RANGE;
                }
                int start = Math.max(0, this.firstRow() - grid.getBufferSize().val());
                int end = Math.min(this.maxRows() - 1, start + this.totalRows() - 1);
                if (end - start + 1 < needed) {
                    start = Math.max(0, end - needed + 1);
                }
                return IntegerRange.of((Integer)start, (Integer)end);
            }).addSources(new Observable[]{grid.columnsNumProperty()}).addSources(new Observable[]{grid.heightProperty()}).addSources(new Observable[]{grid.vPosProperty()}).addSources(new Observable[]{grid.bufferSizeProperty()}).addSources(new Observable[]{grid.sizeProperty(), grid.cellSizeProperty(), grid.vSpacingProperty()}).get());
            this.virtualMaxX.bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> (double)this.maxColumns() * this.getTotalCellSize().getWidth() - grid.getHSpacing()).addSources(new Observable[]{grid.sizeProperty(), grid.columnsNumProperty(), grid.cellSizeProperty()}).addSources(new Observable[]{grid.hSpacingProperty()}).get());
            this.virtualMaxY.bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> (double)this.maxRows() * this.getTotalCellSize().getHeight() - grid.getVSpacing()).addSources(new Observable[]{grid.sizeProperty(), grid.columnsNumProperty(), grid.cellSizeProperty()}).addSources(new Observable[]{grid.vSpacingProperty()}).get());
            this.viewportPosition.bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
                if (grid.isEmpty()) {
                    return Position.origin();
                }
                IntegerRange rowsRange = this.rowsRange();
                IntegerRange columnsRange = this.columnsRange();
                if (Utils.INVALID_RANGE.equals((Object)rowsRange) || Utils.INVALID_RANGE.equals((Object)columnsRange)) {
                    return Position.origin();
                }
                Size size = this.getTotalCellSize();
                IntegerRange rRangeToFirstVisible = IntegerRange.of((Integer)((Integer)rowsRange.getMin()), (Integer)this.firstRow());
                double rPixelsToFirst = (double)rRangeToFirstVisible.diff().intValue() * size.getHeight();
                double rVisibleAmount = grid.getVPos() % size.getHeight();
                IntegerRange cRangeToFirstVisible = IntegerRange.of((Integer)((Integer)columnsRange.getMin()), (Integer)this.firstColumn());
                double cPixelsToFirst = (double)cRangeToFirstVisible.diff().intValue() * size.getWidth();
                double cVisibleAmount = grid.getHPos() % size.getWidth();
                double x = -(cPixelsToFirst + cVisibleAmount);
                double y = -(rPixelsToFirst + rVisibleAmount);
                return Position.of((double)x, (double)y);
            }).addSources(new Observable[]{grid.vPosProperty(), grid.hPosProperty()}).addSources(new Observable[]{grid.cellSizeProperty()}).addSources(new Observable[]{grid.hSpacingProperty(), grid.vSpacingProperty()}).get());
            this.totalCellSize.bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
                Size size = grid.getCellSize();
                return Size.of((double)(size.getWidth() + grid.getHSpacing()), (double)(size.getHeight() + grid.getVSpacing()));
            }).addSources(new Observable[]{grid.cellSizeProperty(), grid.vSpacingProperty(), grid.hSpacingProperty()}).get());
        }

        @Override
        public int maxColumns() {
            return Math.min(this.grid.size(), this.grid.getColumnsNum());
        }

        @Override
        public int firstColumn() {
            return NumberUtils.clamp((int)((int)Math.floor(this.grid.getHPos() / this.getTotalCellSize().getWidth())), (int)0, (int)(this.maxColumns() - 1));
        }

        @Override
        public int lastColumn() {
            return (Integer)this.columnsRange().getMax();
        }

        @Override
        public int visibleColumns() {
            return (int)Math.ceil(this.grid.getWidth() / this.getTotalCellSize().getWidth());
        }

        @Override
        public int totalColumns() {
            int visible = this.visibleColumns();
            return visible == 0 ? 0 : Math.min(visible + this.grid.getBufferSize().val() * 2, this.maxColumns());
        }

        @Override
        public ReadOnlyObjectProperty<NumberRange<Integer>> columnsRangeProperty() {
            return this.columnsRange.getReadOnlyProperty();
        }

        @Override
        public int maxRows() {
            return NumberUtils.clamp((int)((int)Math.ceil((double)this.grid.size() / (double)this.maxColumns())), (int)0, (int)this.grid.size());
        }

        @Override
        public int firstRow() {
            return NumberUtils.clamp((int)((int)Math.floor(this.grid.getVPos() / this.getTotalCellSize().getHeight())), (int)0, (int)(this.maxRows() - 1));
        }

        @Override
        public int lastRow() {
            return (Integer)this.rowsRange().getMax();
        }

        @Override
        public int visibleRows() {
            return (int)Math.ceil(this.grid.getHeight() / this.getTotalCellSize().getHeight());
        }

        @Override
        public int totalRows() {
            int visible = this.visibleRows();
            return visible == 0 ? 0 : Math.min(visible + this.grid.getBufferSize().val() * 2, this.maxRows());
        }

        @Override
        public ReadOnlyObjectProperty<NumberRange<Integer>> rowsRangeProperty() {
            return this.rowsRange;
        }

        @Override
        public double maxHScroll() {
            return Math.max(0.0, this.getVirtualMaxX() - this.grid.getWidth());
        }

        @Override
        public double maxVScroll() {
            return Math.max(0.0, this.getVirtualMaxY() - this.grid.getHeight());
        }

        @Override
        public ReadOnlyDoubleProperty virtualMaxXProperty() {
            return this.virtualMaxX.getReadOnlyProperty();
        }

        @Override
        public ReadOnlyDoubleProperty virtualMaxYProperty() {
            return this.virtualMaxY.getReadOnlyProperty();
        }

        @Override
        public ReadOnlyObjectProperty<Position> viewportPositionProperty() {
            return this.viewportPosition.getReadOnlyProperty();
        }

        @Override
        public void layout(int absRowIndex, int absColumnIndex, Node node) {
            double x = this.getTotalCellSize().getWidth() * (double)absColumnIndex;
            double y = this.getTotalCellSize().getHeight() * (double)absRowIndex;
            double w = this.grid.getCellSize().getWidth();
            double h = this.grid.getCellSize().getHeight();
            node.resizeRelocate(x, y, w, h);
        }

        @Override
        public Size getTotalCellSize() {
            return (Size)this.totalCellSize.get();
        }

        @Override
        public VFXGrid<T, C> getGrid() {
            return this.grid;
        }
    }
}

