/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.behavior.BehaviorBase;
import io.github.palexdev.mfxcore.utils.GridUtils;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.grid.VFXGrid;
import io.github.palexdev.virtualizedfx.grid.VFXGridHelper;
import io.github.palexdev.virtualizedfx.grid.VFXGridState;
import io.github.palexdev.virtualizedfx.utils.Utils;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javafx.geometry.Orientation;

public class VFXGridManager<T, C extends Cell<T>>
extends BehaviorBase<VFXGrid<T, C>> {
    protected boolean invalidatingPos = false;

    public VFXGridManager(VFXGrid<T, C> grid) {
        super(grid);
    }

    protected void onGeometryChanged() {
        this.invalidatingPos = true;
        VFXGrid grid = (VFXGrid)this.getNode();
        VFXGridHelper helper = grid.getHelper();
        if (!this.gridFactorySizeCheck()) {
            return;
        }
        helper.invalidatePos();
        IntegerRange rowsRange = helper.rowsRange();
        IntegerRange columnsRange = helper.columnsRange();
        if (!this.rangeCheck(rowsRange, columnsRange, true, true)) {
            return;
        }
        VFXGridState newState = new VFXGridState(grid, rowsRange, columnsRange);
        this.moveReuseCreateAlgorithm(rowsRange, columnsRange, newState);
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        grid.update(newState);
        this.invalidatingPos = false;
    }

    protected void onPositionChanged(Orientation axis) {
        IntegerRange range;
        if (this.invalidatingPos) {
            return;
        }
        VFXGrid grid = (VFXGrid)this.getNode();
        VFXGridState state = grid.getState();
        if (state == VFXGridState.EMPTY) {
            return;
        }
        VFXGridHelper helper = grid.getHelper();
        IntegerRange lastRange = axis == Orientation.VERTICAL ? state.getRowsRange() : state.getColumnsRange();
        IntegerRange integerRange = range = axis == Orientation.VERTICAL ? helper.rowsRange() : helper.columnsRange();
        if (Objects.equals(lastRange, range) || Utils.INVALID_RANGE.equals((Object)range)) {
            return;
        }
        IntegerRange rowsRange = axis == Orientation.VERTICAL ? range : helper.rowsRange();
        IntegerRange columnsRange = axis == Orientation.VERTICAL ? helper.columnsRange() : range;
        VFXGridState newState = new VFXGridState(grid, rowsRange, columnsRange);
        this.moveReuseCreateAlgorithm(rowsRange, columnsRange, newState);
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        grid.update(newState);
        if (!newState.haveCellsChanged()) {
            grid.requestViewportLayout();
        }
    }

    protected void onColumnsNumChanged() {
        this.invalidatingPos = true;
        VFXGrid grid = (VFXGrid)this.getNode();
        if (!this.gridFactorySizeCheck()) {
            return;
        }
        VFXGridHelper helper = grid.getHelper();
        helper.invalidatePos();
        IntegerRange rowsRange = helper.rowsRange();
        IntegerRange columnsRange = helper.columnsRange();
        if (!this.rangeCheck(rowsRange, columnsRange, true, true)) {
            return;
        }
        VFXGridState newState = new VFXGridState(grid, rowsRange, columnsRange);
        this.moveReuseCreateAlgorithm(rowsRange, columnsRange, newState);
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        grid.update(newState);
        if (!newState.haveCellsChanged()) {
            grid.requestViewportLayout();
        }
        this.invalidatingPos = false;
    }

    protected void onCellFactoryChanged() {
        IntegerRange columnsRange;
        VFXGrid grid = (VFXGrid)this.getNode();
        if (this.disposeCurrent()) {
            grid.getCache().clear();
        }
        if (!this.gridFactorySizeCheck()) {
            return;
        }
        VFXGridState current = grid.getState();
        IntegerRange rowsRange = current.getRowsRange();
        if (!this.rangeCheck(rowsRange, columnsRange = current.getColumnsRange(), true, true)) {
            return;
        }
        VFXGridState newState = new VFXGridState(grid, rowsRange, columnsRange);
        this.moveReuseCreateAlgorithm(rowsRange, columnsRange, newState);
        newState.setCellsChanged(true);
        grid.update(newState);
    }

    protected void onCellSizeChanged() {
        this.invalidatingPos = true;
        VFXGrid grid = (VFXGrid)this.getNode();
        VFXGridHelper helper = grid.getHelper();
        helper.invalidatePos();
        if (!this.gridFactorySizeCheck()) {
            return;
        }
        IntegerRange rowsRange = helper.rowsRange();
        IntegerRange columnsRange = helper.columnsRange();
        VFXGridState newState = new VFXGridState(grid, rowsRange, columnsRange);
        this.moveReuseCreateAlgorithm(rowsRange, columnsRange, newState);
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        grid.update(newState);
        this.invalidatingPos = true;
    }

    protected void onSpacingChanged() {
        this.invalidatingPos = true;
        VFXGrid grid = (VFXGrid)this.getNode();
        if (!this.gridFactorySizeCheck()) {
            return;
        }
        VFXGridHelper helper = grid.getHelper();
        helper.invalidatePos();
        IntegerRange rowsRange = helper.rowsRange();
        IntegerRange columnsRange = helper.columnsRange();
        if (!this.rangeCheck(rowsRange, columnsRange, true, true)) {
            return;
        }
        VFXGridState newState = new VFXGridState(grid, rowsRange, columnsRange);
        this.moveReuseCreateAlgorithm(rowsRange, columnsRange, newState);
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        grid.update(newState);
        if (!newState.haveCellsChanged()) {
            grid.requestViewportLayout();
        }
        this.invalidatingPos = false;
    }

    protected void onItemsChanged() {
        this.invalidatingPos = true;
        VFXGrid grid = (VFXGrid)this.getNode();
        VFXGridHelper helper = grid.getHelper();
        helper.invalidatePos();
        VFXGridState current = grid.getState();
        if (!this.gridFactorySizeCheck()) {
            return;
        }
        int nColumns = helper.maxColumns();
        IntegerRange rowsRange = helper.rowsRange();
        IntegerRange columnsRange = helper.columnsRange();
        LinkedHashSet<Integer> remaining = new LinkedHashSet<Integer>();
        VFXGridState newState = new VFXGridState(grid, rowsRange, columnsRange);
        block0: for (Integer rIdx : rowsRange) {
            for (Integer cIdx : columnsRange) {
                int linear = GridUtils.subToInd((int)nColumns, (int)rIdx, (int)cIdx);
                if (linear >= grid.size()) break block0;
                Object item = helper.indexToItem(linear);
                Object c = current.removeCell(item);
                if (c != null) {
                    c.updateIndex(linear);
                    newState.addCell(linear, item, c);
                    continue;
                }
                remaining.add(linear);
            }
        }
        this.remainingAlgorithm(remaining, newState);
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        grid.update(newState);
        if (!newState.haveCellsChanged()) {
            grid.requestViewportLayout();
        }
        this.invalidatingPos = false;
    }

    protected void moveReuseCreateAlgorithm(IntegerRange rowsRange, IntegerRange columnsRange, VFXGridState<T, C> newState) {
        VFXGrid grid = (VFXGrid)this.getNode();
        int nColumns = grid.getHelper().maxColumns();
        VFXGridState current = grid.getState();
        LinkedHashSet<Integer> remaining = new LinkedHashSet<Integer>();
        block0: for (Integer rIdx : rowsRange) {
            for (Integer cIdx : columnsRange) {
                int linear = GridUtils.subToInd((int)nColumns, (int)rIdx, (int)cIdx);
                if (linear >= grid.size()) break block0;
                Object c = current.removeCell(linear);
                if (c == null) {
                    remaining.add(linear);
                    continue;
                }
                newState.addCell(linear, c);
            }
        }
        this.remainingAlgorithm(remaining, newState);
    }

    protected void remainingAlgorithm(Set<Integer> remaining, VFXGridState<T, C> newState) {
        VFXGrid grid = (VFXGrid)this.getNode();
        VFXGridHelper helper = grid.getHelper();
        VFXGridState current = grid.getState();
        for (Integer index : remaining) {
            Object c;
            Object item = helper.indexToItem(index);
            if (!current.isEmpty()) {
                c = (Cell)current.getCells().poll().getValue();
                c.updateIndex(index);
                c.updateItem(item);
            } else {
                c = helper.itemToCell(item);
                c.updateIndex(index);
                newState.setCellsChanged(true);
            }
            newState.addCell((int)index, item, c);
        }
    }

    protected boolean gridFactorySizeCheck() {
        VFXGrid grid = (VFXGrid)this.getNode();
        if (grid.isEmpty() || grid.getCellFactory() == null || grid.getCellSize().getWidth() <= 0.0 || grid.getCellSize().getHeight() <= 0.0) {
            this.disposeCurrent();
            grid.update(VFXGridState.EMPTY);
            this.invalidatingPos = false;
            return false;
        }
        return true;
    }

    protected boolean rangeCheck(IntegerRange rowsRange, IntegerRange columnsRange, boolean update, boolean dispose) {
        VFXGrid grid = (VFXGrid)this.getNode();
        if (Utils.INVALID_RANGE.equals((Object)rowsRange) || Utils.INVALID_RANGE.equals((Object)columnsRange)) {
            if (dispose) {
                this.disposeCurrent();
            }
            if (update) {
                grid.update(VFXGridState.EMPTY);
            }
            this.invalidatingPos = false;
            return false;
        }
        return true;
    }

    protected boolean disposeCurrent() {
        VFXGridState state = ((VFXGrid)this.getNode()).getState();
        if (!state.isEmpty()) {
            state.dispose();
            return true;
        }
        return false;
    }
}

