/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.controls.SkinBase;
import io.github.palexdev.mfxcore.observables.When;
import io.github.palexdev.mfxcore.utils.GridUtils;
import io.github.palexdev.mfxcore.utils.fx.LayoutUtils;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.grid.VFXGrid;
import io.github.palexdev.virtualizedfx.grid.VFXGridHelper;
import io.github.palexdev.virtualizedfx.grid.VFXGridManager;
import io.github.palexdev.virtualizedfx.grid.VFXGridState;
import java.util.SequencedMap;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class VFXGridSkin<T, C extends Cell<T>>
extends SkinBase<VFXGrid<T, C>, VFXGridManager<T, C>> {
    protected final Pane viewport = new Pane(){

        protected void layoutChildren() {
            VFXGridSkin.this.layout();
        }
    };
    protected final Rectangle clip;
    protected double DEFAULT_SIZE = 100.0;

    public VFXGridSkin(VFXGrid<T, C> grid) {
        super(grid);
        this.viewport.getStyleClass().add((Object)"viewport");
        this.clip = new Rectangle();
        this.clip.widthProperty().bind((ObservableValue)grid.widthProperty());
        this.clip.heightProperty().bind((ObservableValue)grid.heightProperty());
        this.clip.arcWidthProperty().bind((ObservableValue)grid.clipBorderRadiusProperty());
        this.clip.arcHeightProperty().bind((ObservableValue)grid.clipBorderRadiusProperty());
        grid.setClip((Node)this.clip);
        this.addListeners();
        this.getChildren().add((Object)this.viewport);
    }

    protected void addListeners() {
        VFXGrid grid = (VFXGrid)this.getSkinnable();
        this.listeners(new When[]{When.onInvalidated(grid.stateProperty()).then(s -> {
            if (s == VFXGridState.EMPTY) {
                this.viewport.getChildren().clear();
            } else if (s.haveCellsChanged()) {
                this.viewport.getChildren().setAll(s.getNodes());
                grid.requestViewportLayout();
            }
        }), When.onInvalidated((ObservableValue)grid.needsViewportLayoutProperty()).condition(v -> v).then(v -> this.layout()), When.onChanged(grid.helperProperty()).then((o, n) -> {
            this.viewport.translateXProperty().bind(n.viewportPositionProperty().map(Position::getX));
            this.viewport.translateYProperty().bind(n.viewportPositionProperty().map(Position::getY));
        }).executeNow(), When.onInvalidated((ObservableValue)grid.widthProperty()).then(w -> ((VFXGridManager)this.getBehavior()).onGeometryChanged()), When.onInvalidated((ObservableValue)grid.heightProperty()).then(h -> ((VFXGridManager)this.getBehavior()).onGeometryChanged()), When.onInvalidated(grid.bufferSizeProperty()).then(b -> ((VFXGridManager)this.getBehavior()).onGeometryChanged()), When.onInvalidated((ObservableValue)grid.vPosProperty()).then(h -> ((VFXGridManager)this.getBehavior()).onPositionChanged(Orientation.VERTICAL)), When.onInvalidated((ObservableValue)grid.hPosProperty()).then(v -> ((VFXGridManager)this.getBehavior()).onPositionChanged(Orientation.HORIZONTAL)), When.onInvalidated((ObservableValue)grid.columnsNumProperty()).then(n -> ((VFXGridManager)this.getBehavior()).onColumnsNumChanged()), When.onInvalidated(grid.cellFactoryProperty()).then(f -> ((VFXGridManager)this.getBehavior()).onCellFactoryChanged()), When.onInvalidated((ObservableValue)grid.cellSizeProperty()).then(s -> ((VFXGridManager)this.getBehavior()).onCellSizeChanged()), When.onInvalidated((ObservableValue)grid.hSpacingProperty()).then(s -> ((VFXGridManager)this.getBehavior()).onSpacingChanged()), When.onInvalidated((ObservableValue)grid.vSpacingProperty()).then(s -> ((VFXGridManager)this.getBehavior()).onSpacingChanged()), When.onInvalidated(grid.itemsProperty()).then(it -> ((VFXGridManager)this.getBehavior()).onItemsChanged()), When.onInvalidated(grid.alignmentProperty()).then(a -> grid.requestLayout())});
    }

    protected void layout() {
        VFXGrid grid = (VFXGrid)this.getSkinnable();
        if (!grid.isNeedsViewportLayout()) {
            return;
        }
        VFXGridHelper helper = grid.getHelper();
        VFXGridState state = grid.getState();
        int nColumns = helper.maxColumns();
        if (state != VFXGridState.EMPTY) {
            SequencedMap cells = state.getCellsByIndex();
            int i = 0;
            int j = 0;
            block0: for (Integer rIdx : state.getRowsRange()) {
                for (Integer cIdx : state.getColumnsRange()) {
                    int linear = GridUtils.subToInd((int)nColumns, (int)rIdx, (int)cIdx);
                    if (linear >= grid.size()) break block0;
                    helper.layout(i, j, ((Cell)cells.get(linear)).toNode());
                    ++j;
                }
                ++i;
                j = 0;
            }
            this.onLayoutCompleted(true);
            return;
        }
        this.onLayoutCompleted(false);
    }

    protected void onLayoutCompleted(boolean done) {
        VFXGrid grid = (VFXGrid)this.getSkinnable();
        grid.setNeedsViewportLayout(false);
    }

    protected void initBehavior(VFXGridManager<T, C> behavior) {
        behavior.init();
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.DEFAULT_SIZE + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.DEFAULT_SIZE + bottomInset;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        VFXGrid grid = (VFXGrid)this.getSkinnable();
        VFXGridHelper helper = grid.getHelper();
        VFXGridState state = grid.getState();
        if (state == VFXGridState.EMPTY) {
            this.viewport.resize(0.0, 0.0);
            return;
        }
        double vw = (double)(state.getColumnsRange().diff() + 1) * helper.getTotalCellSize().getWidth() - grid.getHSpacing();
        double vh = (double)(state.getRowsRange().diff() + 1) * helper.getTotalCellSize().getHeight() - grid.getVSpacing();
        this.viewport.resize(vw, vh);
        Position pos = LayoutUtils.computePosition((Region)grid, (Node)this.viewport, (double)0.0, (double)0.0, (double)grid.getWidth(), (double)grid.getHeight(), (double)0.0, (Insets)Insets.EMPTY, (HPos)grid.getAlignment().getHpos(), (VPos)grid.getAlignment().getVpos(), (boolean)false, (boolean)false);
        this.viewport.relocate(Math.max(0.0, pos.getX()), Math.max(0.0, pos.getY()));
    }

    public void dispose() {
        VFXGrid grid = (VFXGrid)this.getSkinnable();
        grid.update(VFXGridState.EMPTY);
        super.dispose();
    }
}

