/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.grid;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.utils.GridUtils;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.grid.VFXGrid;
import io.github.palexdev.virtualizedfx.utils.StateMap;
import io.github.palexdev.virtualizedfx.utils.Utils;
import io.github.palexdev.virtualizedfx.utils.VFXCellsCache;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import javafx.scene.Node;

public class VFXGridState<T, C extends Cell<T>> {
    public static final VFXGridState EMPTY = new VFXGridState(){

        protected Cell<Object> removeCell(int index) {
            return null;
        }

        @Override
        protected void dispose() {
        }
    };
    private final VFXGrid<T, C> grid;
    private final IntegerRange rowsRange;
    private final IntegerRange columnsRange;
    private final int nColumns;
    private final StateMap<T, C> cells = new StateMap();
    private boolean cellsChanged = false;

    private VFXGridState() {
        this.grid = null;
        this.rowsRange = Utils.INVALID_RANGE;
        this.columnsRange = Utils.INVALID_RANGE;
        this.nColumns = 0;
    }

    public VFXGridState(VFXGrid<T, C> grid, IntegerRange rowsRange, IntegerRange columnsRange) {
        this.grid = grid;
        this.rowsRange = rowsRange;
        this.columnsRange = columnsRange;
        this.nColumns = grid.getHelper().maxColumns();
    }

    protected void addCell(int rIndex, int cIndex, C cell) {
        int linear = GridUtils.subToInd((int)this.nColumns, (int)rIndex, (int)cIndex);
        this.addCell(linear, this.grid.getItems().get(linear), cell);
    }

    protected void addCell(int index, C cell) {
        this.addCell(index, this.grid.getItems().get(index), cell);
    }

    protected void addCell(int index, T item, C cell) {
        this.cells.put(index, item, cell);
    }

    protected C removeCell(int rIndex, int cIndex) {
        return this.removeCell((T)GridUtils.subToInd((int)this.nColumns, (int)rIndex, (int)cIndex));
    }

    protected C removeCell(int index) {
        C c = this.cells.remove(Integer.valueOf(index));
        if (c == null) {
            c = this.removeCell(this.grid.getItems().get(index));
        }
        return c;
    }

    protected C removeCell(T item) {
        return this.cells.remove(item);
    }

    protected void dispose() {
        VFXCellsCache cache = this.grid.getCache();
        cache.cache(this.getCellsByIndex().values());
        this.cells.clear();
    }

    public VFXGrid<T, C> getGrid() {
        return this.grid;
    }

    public IntegerRange getRowsRange() {
        return this.rowsRange;
    }

    public IntegerRange getColumnsRange() {
        return this.columnsRange;
    }

    protected StateMap<T, C> getCells() {
        return this.cells;
    }

    protected SequencedMap<Integer, C> getCellsByIndex() {
        return this.cells.getByIndex();
    }

    protected Map<T, C> getCellsByItem() {
        return this.cells.resolve();
    }

    public SequencedMap<Integer, C> getCellsByIndexUnmodifiable() {
        return Collections.unmodifiableSequencedMap(this.cells.getByIndex());
    }

    public Map<T, C> getCellsByItemUnmodifiable() {
        return Collections.unmodifiableMap(this.cells.resolve());
    }

    public List<Node> getNodes() {
        return this.getCellsByIndex().values().stream().map(Cell::toNode).toList();
    }

    public int size() {
        return this.cells.size();
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public boolean haveCellsChanged() {
        return this.cellsChanged;
    }

    protected void setCellsChanged(boolean cellsChanged) {
        this.cellsChanged = cellsChanged;
    }
}

