/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.list;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.properties.functional.FunctionProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableIntegerProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.mfxcore.controls.Control;
import io.github.palexdev.mfxcore.controls.SkinBase;
import io.github.palexdev.mfxcore.utils.fx.PropUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.base.VFXContainer;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.enums.BufferSize;
import io.github.palexdev.virtualizedfx.list.VFXListHelper;
import io.github.palexdev.virtualizedfx.list.VFXListManager;
import io.github.palexdev.virtualizedfx.list.VFXListSkin;
import io.github.palexdev.virtualizedfx.list.VFXListState;
import io.github.palexdev.virtualizedfx.properties.VFXListStateProperty;
import io.github.palexdev.virtualizedfx.utils.VFXCellsCache;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Orientation;

public class VFXList<T, C extends Cell<T>>
extends Control<VFXListManager<T, C>>
implements VFXContainer<T> {
    private final VFXCellsCache<T, C> cache;
    private final ListProperty<T> items = new SimpleListProperty<T>(this, FXCollections.observableArrayList()){

        public void set(ObservableList<T> newValue) {
            if (newValue == null) {
                newValue = FXCollections.observableArrayList();
            }
            super.set(newValue);
        }
    };
    private final FunctionProperty<T, C> cellFactory = new FunctionProperty<T, C>(){

        protected void invalidated() {
            VFXList.this.cache.setCellFactory((Function)this.get());
        }
    };
    private final ReadOnlyObjectWrapper<VFXListHelper<T, C>> helper = new ReadOnlyObjectWrapper<VFXListHelper<T, C>>(this){

        public void set(VFXListHelper<T, C> newValue) {
            if (newValue == null) {
                throw new NullPointerException("List helper cannot be null!");
            }
            VFXListHelper oldValue = (VFXListHelper)this.get();
            if (oldValue != null) {
                oldValue.dispose();
            }
            super.set(newValue);
        }
    };
    private final FunctionProperty<Orientation, VFXListHelper<T, C>> helperFactory = new FunctionProperty<Orientation, VFXListHelper<T, C>>(this.defaultHelperFactory()){

        public void set(Function<Orientation, VFXListHelper<T, C>> newValue) {
            if (newValue == null) {
                throw new NullPointerException("List helper factory cannot be null!");
            }
            super.set(newValue);
        }

        protected void invalidated() {
            Orientation orientation = VFXList.this.getOrientation();
            VFXListHelper helper = (VFXListHelper)((Function)this.get()).apply(orientation);
            VFXList.this.setHelper(helper);
        }
    };
    private final DoubleProperty vPos = PropUtils.clampedDoubleProperty(() -> 0.0, () -> this.getHelper().maxVScroll());
    private final DoubleProperty hPos = PropUtils.clampedDoubleProperty(() -> 0.0, () -> this.getHelper().maxHScroll());
    private final VFXListStateProperty<T, C> state = new VFXListStateProperty(VFXListState.EMPTY);
    private final ReadOnlyBooleanWrapper needsViewportLayout = new ReadOnlyBooleanWrapper(false);
    private final StyleableDoubleProperty cellSize = new StyleableDoubleProperty(StyleableProperties.CELL_SIZE, (Object)this, "cellSize", Double.valueOf(32.0));
    private final StyleableDoubleProperty spacing = new StyleableDoubleProperty(StyleableProperties.SPACING, (Object)this, "spacing", Double.valueOf(0.0));
    private final StyleableObjectProperty<BufferSize> bufferSize = new StyleableObjectProperty(StyleableProperties.BUFFER_SIZE, (Object)this, "bufferSize", (Object)BufferSize.standard());
    private final StyleableObjectProperty<Orientation> orientation = new StyleableObjectProperty<Orientation>(StyleableProperties.ORIENTATION, (Object)this, "orientation"){

        protected void invalidated() {
            Orientation orientation = (Orientation)this.get();
            VFXListHelper helper = VFXList.this.getHelperFactory().apply(orientation);
            VFXList.this.setHelper(helper);
        }
    };
    private final StyleableBooleanProperty fitToViewport = new StyleableBooleanProperty(StyleableProperties.FIT_TO_VIEWPORT, (Object)this, "fitToViewport", true);
    private final StyleableDoubleProperty clipBorderRadius = new StyleableDoubleProperty(StyleableProperties.CLIP_BORDER_RADIUS, (Object)this, "clipBorderRadius", Double.valueOf(0.0));
    private final StyleableIntegerProperty cacheCapacity = new StyleableIntegerProperty(StyleableProperties.CACHE_CAPACITY, this, "cacheCapacity", 10){

        protected void invalidated() {
            VFXList.this.cache.setCapacity(this.get());
        }
    };

    public VFXList() {
        this.cache = this.createCache();
        this.setOrientation(Orientation.VERTICAL);
        this.initialize();
    }

    public VFXList(ObservableList<T> items, Function<T, C> cellFactory) {
        this();
        this.setItems(items);
        this.setCellFactory(cellFactory);
    }

    public VFXList(ObservableList<T> items, Function<T, C> cellFactory, Orientation orientation) {
        this();
        this.setItems(items);
        this.setCellFactory(cellFactory);
        this.setOrientation(orientation);
    }

    private void initialize() {
        this.getStyleClass().addAll(this.defaultStyleClasses());
        this.setDefaultBehaviorProvider();
    }

    protected VFXCellsCache<T, C> createCache() {
        return new VFXCellsCache(null, this.getCacheCapacity());
    }

    protected void update(VFXListState<T, C> state) {
        this.setState(state);
    }

    protected Function<Orientation, VFXListHelper<T, C>> defaultHelperFactory() {
        return o -> o == Orientation.VERTICAL ? new VFXListHelper.VerticalHelper(this) : new VFXListHelper.HorizontalHelper(this);
    }

    public void requestViewportLayout() {
        this.setNeedsViewportLayout(true);
    }

    @Override
    public List<String> defaultStyleClasses() {
        return List.of("vfx-list");
    }

    protected SkinBase<?, ?> buildSkin() {
        return new VFXListSkin(this);
    }

    public Supplier<VFXListManager<T, C>> defaultBehaviorProvider() {
        return () -> new VFXListManager(this);
    }

    public VFXList<T, C> populateCache() {
        this.cache.populate();
        return this;
    }

    @Override
    public ReadOnlyIntegerProperty sizeProperty() {
        return this.items.sizeProperty();
    }

    @Override
    public ReadOnlyBooleanProperty emptyProperty() {
        return this.items.emptyProperty();
    }

    public IntegerRange getRange() {
        return this.getState().getRange();
    }

    public SequencedMap<Integer, C> getCellsByIndexUnmodifiable() {
        return this.getState().getCellsByIndexUnmodifiable();
    }

    public Map<T, C> getCellsByItemUnmodifiable() {
        return this.getState().getCellsByItemUnmodifiable();
    }

    @Override
    public ReadOnlyDoubleProperty virtualMaxXProperty() {
        return this.getHelper().virtualMaxXProperty();
    }

    @Override
    public ReadOnlyDoubleProperty virtualMaxYProperty() {
        return this.getHelper().virtualMaxYProperty();
    }

    public void scrollBy(double pixels) {
        this.getHelper().scrollBy(pixels);
    }

    public void scrollToPixel(double pixel) {
        this.getHelper().scrollToPixel(pixel);
    }

    public void scrollToIndex(int index) {
        this.getHelper().scrollToIndex(index);
    }

    public void scrollToFirst() {
        this.scrollToIndex(0);
    }

    public void scrollToLast() {
        this.scrollToIndex(this.size() - 1);
    }

    public double getCellSize() {
        return this.cellSize.get();
    }

    public StyleableDoubleProperty cellSizeProperty() {
        return this.cellSize;
    }

    public void setCellSize(double cellSize) {
        this.cellSize.set(cellSize);
    }

    public double getSpacing() {
        return this.spacing.get();
    }

    public StyleableDoubleProperty spacingProperty() {
        return this.spacing;
    }

    public void setSpacing(double spacing) {
        this.spacing.set(spacing);
    }

    @Override
    public StyleableObjectProperty<BufferSize> bufferSizeProperty() {
        return this.bufferSize;
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public StyleableObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public boolean isFitToViewport() {
        return this.fitToViewport.get();
    }

    public StyleableBooleanProperty fitToViewportProperty() {
        return this.fitToViewport;
    }

    public void setFitToViewport(boolean fitToViewport) {
        this.fitToViewport.set(fitToViewport);
    }

    public double getClipBorderRadius() {
        return this.clipBorderRadius.get();
    }

    public StyleableDoubleProperty clipBorderRadiusProperty() {
        return this.clipBorderRadius;
    }

    public void setClipBorderRadius(double clipBorderRadius) {
        this.clipBorderRadius.set(clipBorderRadius);
    }

    public int getCacheCapacity() {
        return this.cacheCapacity.get();
    }

    public StyleableIntegerProperty cacheCapacityProperty() {
        return this.cacheCapacity;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity.set(cacheCapacity);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return VFXList.getClassCssMetaData();
    }

    protected VFXCellsCache<T, C> getCache() {
        return this.cache;
    }

    public int cacheSize() {
        return this.cache.size();
    }

    @Override
    public ListProperty<T> itemsProperty() {
        return this.items;
    }

    public Function<T, C> getCellFactory() {
        return (Function)this.cellFactory.get();
    }

    public FunctionProperty<T, C> cellFactoryProperty() {
        return this.cellFactory;
    }

    public void setCellFactory(Function<T, C> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    public VFXListHelper<T, C> getHelper() {
        return (VFXListHelper)this.helper.get();
    }

    public ReadOnlyObjectProperty<VFXListHelper<T, C>> helperProperty() {
        return this.helper.getReadOnlyProperty();
    }

    protected void setHelper(VFXListHelper<T, C> helper) {
        this.helper.set(helper);
    }

    public Function<Orientation, VFXListHelper<T, C>> getHelperFactory() {
        return (Function)this.helperFactory.get();
    }

    public FunctionProperty<Orientation, VFXListHelper<T, C>> helperFactoryProperty() {
        return this.helperFactory;
    }

    public void setHelperFactory(Function<Orientation, VFXListHelper<T, C>> helperFactory) {
        this.helperFactory.set(helperFactory);
    }

    @Override
    public DoubleProperty vPosProperty() {
        return this.vPos;
    }

    @Override
    public DoubleProperty hPosProperty() {
        return this.hPos;
    }

    public VFXListState<T, C> getState() {
        return (VFXListState)this.state.get();
    }

    public ReadOnlyObjectProperty<VFXListState<T, C>> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    protected void setState(VFXListState<T, C> state) {
        this.state.set(state);
    }

    public boolean isNeedsViewportLayout() {
        return this.needsViewportLayout.get();
    }

    public ReadOnlyBooleanProperty needsViewportLayoutProperty() {
        return this.needsViewportLayout.getReadOnlyProperty();
    }

    protected void setNeedsViewportLayout(boolean needsViewportLayout) {
        this.needsViewportLayout.set(needsViewportLayout);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<VFXList<?, ?>> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<VFXList<?, ?>, Number> CELL_SIZE;
        private static final CssMetaData<VFXList<?, ?>, Number> SPACING;
        private static final CssMetaData<VFXList<?, ?>, BufferSize> BUFFER_SIZE;
        private static final CssMetaData<VFXList<?, ?>, Orientation> ORIENTATION;
        private static final CssMetaData<VFXList<?, ?>, Boolean> FIT_TO_VIEWPORT;
        private static final CssMetaData<VFXList<?, ?>, Number> CLIP_BORDER_RADIUS;
        private static final CssMetaData<VFXList<?, ?>, Number> CACHE_CAPACITY;

        private StyleableProperties() {
        }

        static {
            CELL_SIZE = FACTORY.createSizeCssMetaData("-vfx-cell-size", VFXList::cellSizeProperty, (Number)32.0);
            SPACING = FACTORY.createSizeCssMetaData("-vfx-spacing", VFXList::spacingProperty, (Number)0.0);
            BUFFER_SIZE = FACTORY.createEnumCssMetaData(BufferSize.class, "-vfx-buffer-size", VFXList::bufferSizeProperty, (Enum)BufferSize.standard());
            ORIENTATION = FACTORY.createEnumCssMetaData(Orientation.class, "-vfx-orientation", VFXList::orientationProperty, (Enum)Orientation.VERTICAL);
            FIT_TO_VIEWPORT = FACTORY.createBooleanCssMetaData("-vfx-fit-to-viewport", VFXList::fitToViewportProperty, true);
            CLIP_BORDER_RADIUS = FACTORY.createSizeCssMetaData("-vfx-clip-border-radius", VFXList::clipBorderRadiusProperty, (Number)0.0);
            CACHE_CAPACITY = FACTORY.createSizeCssMetaData("-vfx-cache-capacity", VFXList::cacheCapacityProperty, (Number)10);
            cssMetaDataList = StyleUtils.cssMetaDataList((List)Control.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{CELL_SIZE, SPACING, BUFFER_SIZE, ORIENTATION, FIT_TO_VIEWPORT, CLIP_BORDER_RADIUS, CACHE_CAPACITY});
        }
    }
}

