/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.list;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.beans.range.NumberRange;
import io.github.palexdev.mfxcore.base.properties.PositionProperty;
import io.github.palexdev.mfxcore.base.properties.range.IntegerRangeProperty;
import io.github.palexdev.mfxcore.builders.bindings.DoubleBindingBuilder;
import io.github.palexdev.mfxcore.builders.bindings.ObjectBindingBuilder;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.LayoutUtils;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.list.VFXList;
import io.github.palexdev.virtualizedfx.utils.Utils;
import io.github.palexdev.virtualizedfx.utils.VFXCellsCache;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public interface VFXListHelper<T, C extends Cell<T>> {
    public int firstVisible();

    public int lastVisible();

    public int visibleNum();

    public int totalNum();

    public ReadOnlyObjectProperty<NumberRange<Integer>> rangeProperty();

    default public IntegerRange range() {
        return (IntegerRange)this.rangeProperty().get();
    }

    public double maxVScroll();

    public double maxHScroll();

    public ReadOnlyDoubleProperty virtualMaxXProperty();

    default public double getVirtualMaxX() {
        return this.virtualMaxXProperty().get();
    }

    public ReadOnlyDoubleProperty virtualMaxYProperty();

    default public double getVirtualMaxY() {
        return this.virtualMaxYProperty().get();
    }

    public ReadOnlyObjectProperty<Position> viewportPositionProperty();

    default public Position getViewportPosition() {
        return (Position)this.viewportPositionProperty().get();
    }

    public double computeSize(Node var1);

    public void layout(int var1, Node var2);

    public void scrollBy(double var1);

    public void scrollToPixel(double var1);

    public void scrollToIndex(int var1);

    public VFXList<T, C> getList();

    default public void invalidatePos() {
        VFXList<T, C> list = this.getList();
        list.setVPos(list.getVPos());
        list.setHPos(list.getHPos());
    }

    default public T indexToItem(int index) {
        return (T)this.getList().getItems().get(index);
    }

    default public C indexToCell(int index) {
        T item = this.indexToItem(index);
        return this.itemToCell(item);
    }

    default public C itemToCell(T item) {
        VFXCellsCache<T, C> cache = this.getList().getCache();
        Optional<C> opt = cache.tryTake();
        opt.ifPresent(c -> c.updateItem(item));
        return (C)opt.orElseGet(() -> (Cell)this.getList().getCellFactory().apply(item));
    }

    default public double getTotalCellSize() {
        return this.getList().getCellSize() + this.getList().getSpacing();
    }

    default public void dispose() {
    }

    public static class HorizontalHelper<T, C extends Cell<T>>
    extends AbstractHelper<T, C> {
        public HorizontalHelper(VFXList<T, C> list) {
            super(list);
            this.virtualMaxX.bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> (double)list.size() * this.getTotalCellSize() - list.getSpacing()).addSources(new Observable[]{list.sizeProperty(), list.cellSizeProperty(), list.spacingProperty()}).get());
            this.range.bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
                if (list.getWidth() <= 0.0) {
                    return Utils.INVALID_RANGE;
                }
                int needed = this.totalNum();
                if (needed == 0) {
                    return Utils.INVALID_RANGE;
                }
                int start = Math.max(0, this.firstVisible() - list.getBufferSize().val());
                int end = Math.min(list.size() - 1, start + this.totalNum() - 1);
                if (end - start + 1 < needed) {
                    start = Math.max(0, end - needed + 1);
                }
                return IntegerRange.of((Integer)start, (Integer)end);
            }).addSources(new Observable[]{list.widthProperty()}).addSources(new Observable[]{list.bufferSizeProperty()}).addSources(new Observable[]{list.hPosProperty()}).addSources(new Observable[]{list.sizeProperty(), list.cellSizeProperty(), list.spacingProperty()}).get());
            this.viewportPosition.bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
                if (list.isEmpty()) {
                    return Position.origin();
                }
                IntegerRange range = this.range();
                if (Utils.INVALID_RANGE.equals((Object)range)) {
                    return Position.origin();
                }
                double size = this.getTotalCellSize();
                IntegerRange rangeToFirstVisible = IntegerRange.of((Integer)((Integer)range.getMin()), (Integer)this.firstVisible());
                double pixelsToFirst = (double)rangeToFirstVisible.diff().intValue() * size;
                double visibleAmountFirst = list.getHPos() % size;
                double x = -NumberUtils.clamp((double)list.getVPos(), (double)0.0, (double)this.maxVScroll());
                double y = -(pixelsToFirst + visibleAmountFirst);
                return Position.of((double)x, (double)y);
            }).addSources(new Observable[]{list.hPosProperty(), list.vPosProperty()}).addSources(new Observable[]{list.cellSizeProperty(), list.spacingProperty()}).get());
        }

        @Override
        public int firstVisible() {
            return NumberUtils.clamp((int)((int)Math.floor(this.list.getHPos() / this.getTotalCellSize())), (int)0, (int)this.list.size());
        }

        @Override
        public int lastVisible() {
            return NumberUtils.clamp((int)((int)Math.floor((this.list.getHPos() + this.list.getWidth()) / this.getTotalCellSize())), (int)0, (int)this.list.size());
        }

        @Override
        public int visibleNum() {
            return (int)Math.ceil(this.list.getWidth() / this.getTotalCellSize());
        }

        @Override
        public double maxVScroll() {
            return Math.max(0.0, this.getVirtualMaxY() - this.list.getHeight());
        }

        @Override
        public double maxHScroll() {
            return Math.max(0.0, this.getVirtualMaxX() - this.list.getWidth());
        }

        @Override
        public double computeSize(Node node) {
            boolean fitToViewport = this.list.isFitToViewport();
            if (fitToViewport) {
                double fH = this.list.getHeight();
                this.virtualMaxY.set(fH);
                return fH;
            }
            double nH = LayoutUtils.boundHeight((Node)node);
            if (nH > this.virtualMaxY.get()) {
                this.virtualMaxY.set(nH);
            }
            return nH;
        }

        @Override
        public void layout(int index, Node node) {
            double x = this.getTotalCellSize() * (double)index;
            double w = this.list.getCellSize();
            double h = this.computeSize(node);
            node.resizeRelocate(x, 0.0, w, h);
        }

        @Override
        public void scrollBy(double pixels) {
            this.list.setHPos(this.list.getHPos() + pixels);
        }

        @Override
        public void scrollToPixel(double pixel) {
            this.list.setHPos(pixel);
        }

        @Override
        public void scrollToIndex(int index) {
            this.scrollToPixel(this.getTotalCellSize() * (double)index);
        }
    }

    public static class VerticalHelper<T, C extends Cell<T>>
    extends AbstractHelper<T, C> {
        public VerticalHelper(VFXList<T, C> list) {
            super(list);
            this.virtualMaxY.bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> (double)list.size() * this.getTotalCellSize() - list.getSpacing()).addSources(new Observable[]{list.sizeProperty(), list.cellSizeProperty(), list.spacingProperty()}).get());
            this.range.bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
                if (list.getHeight() <= 0.0) {
                    return Utils.INVALID_RANGE;
                }
                int needed = this.totalNum();
                if (needed == 0) {
                    return Utils.INVALID_RANGE;
                }
                int start = Math.max(0, this.firstVisible() - list.getBufferSize().val());
                int end = Math.min(list.size() - 1, start + this.totalNum() - 1);
                if (end - start + 1 < needed) {
                    start = Math.max(0, end - needed + 1);
                }
                return IntegerRange.of((Integer)start, (Integer)end);
            }).addSources(new Observable[]{list.heightProperty()}).addSources(new Observable[]{list.bufferSizeProperty()}).addSources(new Observable[]{list.vPosProperty()}).addSources(new Observable[]{list.sizeProperty(), list.cellSizeProperty(), list.spacingProperty()}).get());
            this.viewportPosition.bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> {
                if (list.isEmpty()) {
                    return Position.origin();
                }
                IntegerRange range = this.range();
                if (Utils.INVALID_RANGE.equals((Object)range)) {
                    return Position.origin();
                }
                double size = this.getTotalCellSize();
                IntegerRange rangeToFirstVisible = IntegerRange.of((Integer)((Integer)range.getMin()), (Integer)this.firstVisible());
                double pixelsToFirst = (double)rangeToFirstVisible.diff().intValue() * size;
                double visibleAmountFirst = list.getVPos() % size;
                double x = -NumberUtils.clamp((double)list.getHPos(), (double)0.0, (double)this.maxHScroll());
                double y = -(pixelsToFirst + visibleAmountFirst);
                return Position.of((double)x, (double)y);
            }).addSources(new Observable[]{list.hPosProperty(), list.vPosProperty()}).addSources(new Observable[]{list.cellSizeProperty(), list.spacingProperty()}).get());
        }

        @Override
        public int firstVisible() {
            return NumberUtils.clamp((int)((int)Math.floor(this.list.getVPos() / this.getTotalCellSize())), (int)0, (int)(this.list.size() - 1));
        }

        @Override
        public int lastVisible() {
            return NumberUtils.clamp((int)((int)Math.floor((this.list.getVPos() + this.list.getHeight()) / this.getTotalCellSize())), (int)0, (int)(this.list.size() - 1));
        }

        @Override
        public int visibleNum() {
            return (int)Math.ceil(this.list.getHeight() / this.getTotalCellSize());
        }

        @Override
        public double maxVScroll() {
            return Math.max(0.0, this.getVirtualMaxY() - this.list.getHeight());
        }

        @Override
        public double maxHScroll() {
            return Math.max(0.0, this.getVirtualMaxX() - this.list.getWidth());
        }

        @Override
        public double computeSize(Node node) {
            boolean fitToViewport = this.list.isFitToViewport();
            if (fitToViewport) {
                double fW = this.list.getWidth();
                this.virtualMaxX.set(fW);
                return fW;
            }
            double nW = LayoutUtils.boundWidth((Node)node);
            if (nW > this.virtualMaxX.get()) {
                this.virtualMaxX.set(nW);
            }
            return nW;
        }

        @Override
        public void layout(int index, Node node) {
            double y = this.getTotalCellSize() * (double)index;
            double w = this.computeSize(node);
            double h = this.list.getCellSize();
            node.resizeRelocate(0.0, y, w, h);
        }

        @Override
        public void scrollBy(double pixels) {
            this.list.setVPos(this.list.getVPos() + pixels);
        }

        @Override
        public void scrollToPixel(double pixel) {
            this.list.setVPos(pixel);
        }

        @Override
        public void scrollToIndex(int index) {
            this.scrollToPixel(this.getTotalCellSize() * (double)index);
        }
    }

    public static abstract class AbstractHelper<T, C extends Cell<T>>
    implements VFXListHelper<T, C> {
        protected final VFXList<T, C> list;
        protected final IntegerRangeProperty range = new IntegerRangeProperty();
        protected final ReadOnlyDoubleWrapper virtualMaxX = new ReadOnlyDoubleWrapper();
        protected final ReadOnlyDoubleWrapper virtualMaxY = new ReadOnlyDoubleWrapper();
        protected final PositionProperty viewportPosition = new PositionProperty();

        public AbstractHelper(VFXList<T, C> list) {
            this.list = list;
        }

        @Override
        public int totalNum() {
            int visible = this.visibleNum();
            return visible == 0 ? 0 : Math.min(visible + this.list.getBufferSize().val() * 2, this.list.size());
        }

        public IntegerRangeProperty rangeProperty() {
            return this.range;
        }

        @Override
        public ReadOnlyDoubleProperty virtualMaxXProperty() {
            return this.virtualMaxX.getReadOnlyProperty();
        }

        @Override
        public ReadOnlyDoubleProperty virtualMaxYProperty() {
            return this.virtualMaxY.getReadOnlyProperty();
        }

        @Override
        public ReadOnlyObjectProperty<Position> viewportPositionProperty() {
            return this.viewportPosition.getReadOnlyProperty();
        }

        @Override
        public VFXList<T, C> getList() {
            return this.list;
        }
    }
}

