/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.list;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.behavior.BehaviorBase;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.list.VFXList;
import io.github.palexdev.virtualizedfx.list.VFXListHelper;
import io.github.palexdev.virtualizedfx.list.VFXListState;
import io.github.palexdev.virtualizedfx.utils.Utils;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class VFXListManager<T, C extends Cell<T>>
extends BehaviorBase<VFXList<T, C>> {
    protected boolean invalidatingPos = false;

    public VFXListManager(VFXList<T, C> list) {
        super(list);
    }

    protected void onGeometryChanged() {
        this.invalidatingPos = true;
        VFXList list = (VFXList)this.getNode();
        VFXListHelper helper = list.getHelper();
        if (!this.listFactorySizeCheck()) {
            return;
        }
        helper.invalidatePos();
        IntegerRange range = helper.range();
        if (!this.rangeCheck(range, true, true)) {
            return;
        }
        VFXListState newState = new VFXListState(list, range);
        this.moveReuseCreateAlgorithm(range, newState);
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        list.update(newState);
        this.invalidatingPos = false;
    }

    protected void onPositionChanged() {
        IntegerRange range;
        if (this.invalidatingPos) {
            return;
        }
        VFXList list = (VFXList)this.getNode();
        VFXListState state = list.getState();
        if (state == VFXListState.EMPTY) {
            return;
        }
        VFXListHelper helper = list.getHelper();
        IntegerRange lastRange = state.getRange();
        if (Objects.equals(lastRange, range = helper.range()) || Utils.INVALID_RANGE.equals((Object)range) || !lastRange.diff().equals(range.diff())) {
            return;
        }
        VFXListState newState = new VFXListState(list, range);
        ArrayDeque<Integer> needed = new ArrayDeque<Integer>();
        for (Integer i : range) {
            Object common = state.removeCell(i.intValue());
            if (common != null) {
                newState.addCell(i, common);
                continue;
            }
            needed.add(i);
        }
        Iterator it = state.getCellsByIndex().values().iterator();
        while (it.hasNext()) {
            int idx = (Integer)needed.removeFirst();
            Cell cell = (Cell)it.next();
            cell.updateIndex(idx);
            cell.updateItem(helper.indexToItem(idx));
            newState.addCell(idx, cell);
            it.remove();
        }
        list.update(newState);
        list.requestViewportLayout();
    }

    protected void onCellFactoryChanged() {
        VFXList list = (VFXList)this.getNode();
        if (this.disposeCurrent()) {
            list.getCache().clear();
        }
        if (!this.listFactorySizeCheck()) {
            return;
        }
        VFXListState current = list.getState();
        IntegerRange range = current.getRange();
        if (!this.rangeCheck(range, true, true)) {
            return;
        }
        VFXListState newState = new VFXListState(list, range);
        this.moveReuseCreateAlgorithm(range, newState);
        newState.setCellsChanged(true);
        list.update(newState);
    }

    protected void onItemsChanged() {
        this.invalidatingPos = true;
        VFXList list = (VFXList)this.getNode();
        VFXListHelper helper = list.getHelper();
        helper.invalidatePos();
        VFXListState current = list.getState();
        if (!this.listFactorySizeCheck()) {
            return;
        }
        IntegerRange range = helper.range();
        Set expanded = IntegerRange.expandRangeToSet((IntegerRange)range);
        VFXListState newState = new VFXListState(list, range);
        for (Integer index : range) {
            Object item = helper.indexToItem(index);
            Object c = current.removeCell(item);
            if (c == null) continue;
            expanded.remove(index);
            c.updateIndex(index);
            newState.addCell(index, item, c);
        }
        this.remainingAlgorithm(expanded, newState);
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        list.update(newState);
        if (!newState.haveCellsChanged()) {
            list.requestViewportLayout();
        }
        this.invalidatingPos = false;
    }

    protected void onFitToViewportChanged() {
        VFXList list = (VFXList)this.getNode();
        VFXListHelper helper = list.getHelper();
        list.requestViewportLayout();
        helper.invalidatePos();
    }

    protected void onCellSizeChanged() {
        this.invalidatingPos = true;
        VFXList list = (VFXList)this.getNode();
        VFXListHelper helper = list.getHelper();
        helper.invalidatePos();
        if (!this.listFactorySizeCheck()) {
            return;
        }
        VFXListState<T, C> newState = this.intersectionAlgorithm();
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        list.update(newState);
        this.invalidatingPos = false;
    }

    protected void onOrientationChanged() {
        this.invalidatingPos = true;
        VFXList list = (VFXList)this.getNode();
        if (!this.listFactorySizeCheck()) {
            return;
        }
        list.setVPos(0.0);
        list.setHPos(0.0);
        VFXListState<T, C> newState = this.intersectionAlgorithm();
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        list.update(newState);
        if (!newState.haveCellsChanged()) {
            list.requestViewportLayout();
        }
        this.invalidatingPos = false;
    }

    protected void onSpacingChanged() {
        this.invalidatingPos = true;
        VFXList list = (VFXList)this.getNode();
        VFXListHelper helper = list.getHelper();
        helper.invalidatePos();
        IntegerRange range = helper.range();
        if (!this.rangeCheck(range, true, true)) {
            return;
        }
        VFXListState newState = new VFXListState(list, range);
        this.moveReuseCreateAlgorithm(range, newState);
        if (this.disposeCurrent()) {
            newState.setCellsChanged(true);
        }
        list.update(newState);
        if (!newState.haveCellsChanged()) {
            list.requestViewportLayout();
        }
        this.invalidatingPos = false;
    }

    protected void moveReuseCreateAlgorithm(IntegerRange range, VFXListState<T, C> newState) {
        VFXList list = (VFXList)this.getNode();
        VFXListState current = list.getState();
        LinkedHashSet<Integer> remaining = new LinkedHashSet<Integer>();
        for (Integer index : range) {
            Object c = current.removeCell(index.intValue());
            if (c == null) {
                remaining.add(index);
                continue;
            }
            newState.addCell(index, c);
        }
        this.remainingAlgorithm(remaining, newState);
    }

    protected VFXListState<T, C> intersectionAlgorithm() {
        VFXList list = (VFXList)this.getNode();
        VFXListHelper helper = list.getHelper();
        IntegerRange range = helper.range();
        Set expandedRange = IntegerRange.expandRangeToSet((IntegerRange)range);
        VFXListState current = list.getState();
        VFXListState newState = new VFXListState(list, range);
        IntegerRange intersection = Utils.intersection(current.getRange(), range);
        if (this.rangeCheck(intersection, false, false)) {
            for (Integer common : intersection) {
                newState.addCell(common, current.removeCell(common.intValue()));
                expandedRange.remove(common);
            }
        }
        this.remainingAlgorithm(expandedRange, newState);
        return newState;
    }

    protected void remainingAlgorithm(Set<Integer> expandedRange, VFXListState<T, C> newState) {
        VFXList list = (VFXList)this.getNode();
        VFXListHelper helper = list.getHelper();
        VFXListState current = list.getState();
        for (Integer index : expandedRange) {
            Object c;
            Object item = helper.indexToItem(index);
            if (!current.isEmpty()) {
                c = (Cell)current.getCells().poll().getValue();
                c.updateIndex(index);
                c.updateItem(item);
            } else {
                c = helper.itemToCell(item);
                c.updateIndex(index);
                newState.setCellsChanged(true);
            }
            newState.addCell(index, item, c);
        }
    }

    protected boolean listFactorySizeCheck() {
        VFXList list = (VFXList)this.getNode();
        if (list.isEmpty() || list.getCellFactory() == null || list.getCellSize() <= 0.0) {
            this.disposeCurrent();
            list.update(VFXListState.EMPTY);
            this.invalidatingPos = false;
            return false;
        }
        return true;
    }

    protected boolean rangeCheck(IntegerRange range, boolean update, boolean dispose) {
        VFXList list = (VFXList)this.getNode();
        if (Utils.INVALID_RANGE.equals((Object)range)) {
            if (dispose) {
                this.disposeCurrent();
            }
            if (update) {
                list.update(VFXListState.EMPTY);
            }
            this.invalidatingPos = false;
            return false;
        }
        return true;
    }

    protected boolean disposeCurrent() {
        VFXListState state = ((VFXList)this.getNode()).getState();
        if (!state.isEmpty()) {
            state.dispose();
            return true;
        }
        return false;
    }
}

