/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.list;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.controls.SkinBase;
import io.github.palexdev.mfxcore.observables.When;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.list.VFXList;
import io.github.palexdev.virtualizedfx.list.VFXListHelper;
import io.github.palexdev.virtualizedfx.list.VFXListManager;
import io.github.palexdev.virtualizedfx.list.VFXListState;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;

public class VFXListSkin<T, C extends Cell<T>>
extends SkinBase<VFXList<T, C>, VFXListManager<T, C>> {
    protected final Pane viewport;
    protected final Rectangle clip;
    protected double DEFAULT_SIZE = 100.0;
    protected InvalidationListener pl = o -> ((VFXListManager)this.getBehavior()).onPositionChanged();

    public VFXListSkin(VFXList<T, C> list) {
        super(list);
        this.viewport = new Pane(){

            protected void layoutChildren() {
                VFXListSkin.this.layout();
            }
        };
        this.viewport.getStyleClass().add((Object)"viewport");
        this.clip = new Rectangle();
        this.clip.widthProperty().bind((ObservableValue)list.widthProperty());
        this.clip.heightProperty().bind((ObservableValue)list.heightProperty());
        this.clip.arcWidthProperty().bind((ObservableValue)list.clipBorderRadiusProperty());
        this.clip.arcHeightProperty().bind((ObservableValue)list.clipBorderRadiusProperty());
        list.setClip((Node)this.clip);
        this.swapPositionListener();
        this.addListeners();
        this.getChildren().add((Object)this.viewport);
    }

    protected void addListeners() {
        VFXList list = (VFXList)this.getSkinnable();
        this.listeners(new When[]{When.onInvalidated(list.stateProperty()).then(s -> {
            if (s == VFXListState.EMPTY) {
                this.viewport.getChildren().clear();
            } else if (s.haveCellsChanged()) {
                this.viewport.getChildren().setAll(s.getNodes());
                list.requestViewportLayout();
            }
        }), When.onInvalidated((ObservableValue)list.needsViewportLayoutProperty()).condition(v -> v).then(v -> this.layout()), When.onInvalidated(list.orientationProperty()).then(o -> {
            ((VFXListManager)this.getBehavior()).onOrientationChanged();
            this.swapPositionListener();
        }), When.onChanged(list.helperProperty()).then((o, n) -> {
            this.viewport.translateXProperty().bind(n.viewportPositionProperty().map(Position::getX));
            this.viewport.translateYProperty().bind(n.viewportPositionProperty().map(Position::getY));
        }).executeNow(), When.onInvalidated((ObservableValue)list.widthProperty()).condition(w -> list.getOrientation() == Orientation.HORIZONTAL).then(w -> ((VFXListManager)this.getBehavior()).onGeometryChanged()).otherwise((l, w) -> list.requestViewportLayout()), When.onInvalidated((ObservableValue)list.heightProperty()).condition(h -> list.getOrientation() == Orientation.VERTICAL).then(h -> ((VFXListManager)this.getBehavior()).onGeometryChanged()).otherwise((l, h) -> list.requestViewportLayout()), When.onInvalidated(list.bufferSizeProperty()).then(b -> ((VFXListManager)this.getBehavior()).onGeometryChanged()), When.onInvalidated(list.itemsProperty()).then(it -> ((VFXListManager)this.getBehavior()).onItemsChanged()), When.onInvalidated(list.cellFactoryProperty()).then(f -> ((VFXListManager)this.getBehavior()).onCellFactoryChanged()), When.onInvalidated((ObservableValue)list.fitToViewportProperty()).then(b -> ((VFXListManager)this.getBehavior()).onFitToViewportChanged()), When.onInvalidated((ObservableValue)list.cellSizeProperty()).then(s -> ((VFXListManager)this.getBehavior()).onCellSizeChanged()), When.onInvalidated((ObservableValue)list.spacingProperty()).then(s -> ((VFXListManager)this.getBehavior()).onSpacingChanged())});
    }

    protected void layout() {
        VFXList list = (VFXList)this.getSkinnable();
        if (!list.isNeedsViewportLayout()) {
            return;
        }
        VFXListHelper helper = list.getHelper();
        VFXListState state = list.getState();
        if (state != VFXListState.EMPTY) {
            int i = 0;
            for (Cell cell : state.getCellsByIndex().values()) {
                helper.layout(i, cell.toNode());
                ++i;
            }
            this.onLayoutCompleted(true);
            return;
        }
        this.onLayoutCompleted(false);
    }

    protected void onLayoutCompleted(boolean done) {
        VFXList list = (VFXList)this.getSkinnable();
        list.setNeedsViewportLayout(false);
    }

    protected void swapPositionListener() {
        VFXList list = (VFXList)this.getSkinnable();
        Orientation orientation = list.getOrientation();
        if (orientation == Orientation.VERTICAL) {
            list.hPosProperty().removeListener(this.pl);
            list.vPosProperty().addListener(this.pl);
        } else {
            list.vPosProperty().removeListener(this.pl);
            list.hPosProperty().addListener(this.pl);
        }
    }

    protected void initBehavior(VFXListManager<T, C> behavior) {
        behavior.init();
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.DEFAULT_SIZE + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.DEFAULT_SIZE + bottomInset;
    }

    public void dispose() {
        VFXList list = (VFXList)this.getSkinnable();
        list.vPosProperty().removeListener(this.pl);
        list.hPosProperty().removeListener(this.pl);
        this.pl = null;
        list.update(VFXListState.EMPTY);
        super.dispose();
    }
}

