/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.list;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.list.VFXList;
import io.github.palexdev.virtualizedfx.utils.StateMap;
import io.github.palexdev.virtualizedfx.utils.Utils;
import io.github.palexdev.virtualizedfx.utils.VFXCellsCache;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import javafx.scene.Node;

public class VFXListState<T, C extends Cell<T>> {
    public static final VFXListState EMPTY = new VFXListState<Object, Cell<Object>>(){

        @Override
        protected Cell<Object> removeCell(int index) {
            return null;
        }

        @Override
        protected void dispose() {
        }
    };
    private final VFXList<T, C> list;
    private final IntegerRange range;
    private final StateMap<T, C> cells = new StateMap();
    private boolean cellsChanged = false;

    private VFXListState() {
        this.list = null;
        this.range = Utils.INVALID_RANGE;
    }

    public VFXListState(VFXList<T, C> list, IntegerRange range) {
        this.list = list;
        this.range = range;
    }

    protected void addCell(int index, C cell) {
        this.addCell(index, this.list.getItems().get(index), cell);
    }

    protected void addCell(int index, T item, C cell) {
        this.cells.put(index, item, cell);
    }

    protected C removeCell(int index) {
        C c = this.cells.remove(Integer.valueOf(index));
        if (c == null) {
            c = this.removeCell(this.list.getItems().get(index));
        }
        return c;
    }

    protected C removeCell(T item) {
        return this.cells.remove(item);
    }

    protected void dispose() {
        VFXCellsCache cache = this.list.getCache();
        cache.cache(this.getCellsByIndex().values());
        this.cells.clear();
    }

    public VFXList<T, C> getList() {
        return this.list;
    }

    public IntegerRange getRange() {
        return this.range;
    }

    protected StateMap<T, C> getCells() {
        return this.cells;
    }

    protected SequencedMap<Integer, C> getCellsByIndex() {
        return this.cells.getByIndex();
    }

    protected Map<T, C> getCellsByItem() {
        return this.cells.resolve();
    }

    public SequencedMap<Integer, C> getCellsByIndexUnmodifiable() {
        return Collections.unmodifiableSequencedMap(this.cells.getByIndex());
    }

    public Map<T, C> getCellsByItemUnmodifiable() {
        return Collections.unmodifiableMap(this.cells.resolve());
    }

    public List<Node> getNodes() {
        return this.getCellsByIndex().values().stream().map(Cell::toNode).toList();
    }

    public int size() {
        return this.cells.size();
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public boolean haveCellsChanged() {
        return this.cellsChanged;
    }

    protected void setCellsChanged(boolean cellsChanged) {
        this.cellsChanged = cellsChanged;
    }
}

