/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.list.paginated;

import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableIntegerProperty;
import io.github.palexdev.mfxcore.builders.bindings.IntegerBindingBuilder;
import io.github.palexdev.mfxcore.controls.SkinBase;
import io.github.palexdev.mfxcore.utils.fx.PropUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.base.Paginated;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.list.VFXList;
import io.github.palexdev.virtualizedfx.list.VFXListHelper;
import io.github.palexdev.virtualizedfx.list.VFXListManager;
import io.github.palexdev.virtualizedfx.list.paginated.VFXPaginatedListHelper;
import io.github.palexdev.virtualizedfx.list.paginated.VFXPaginatedListManager;
import io.github.palexdev.virtualizedfx.list.paginated.VFXPaginatedListSkin;
import io.github.palexdev.virtualizedfx.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Orientation;

public class VFXPaginatedList<T, C extends Cell<T>>
extends VFXList<T, C>
implements Paginated<T> {
    private final IntegerProperty page = PropUtils.clampedIntProperty(() -> 0, this::getMaxPage);
    private final ReadOnlyIntegerWrapper maxPage = new ReadOnlyIntegerWrapper();
    private final StyleableIntegerProperty cellsPerPage = new StyleableIntegerProperty(StyleableProperties.CELLS_PER_PAGE, (Object)this, "cellsPerPage", Integer.valueOf(10));

    public VFXPaginatedList() {
        this.initialize();
    }

    public VFXPaginatedList(ObservableList<T> items, Function<T, C> cellFactory) {
        super(items, cellFactory);
        this.initialize();
    }

    public VFXPaginatedList(ObservableList<T> items, Function<T, C> cellFactory, Orientation orientation) {
        super(items, cellFactory, orientation);
        this.initialize();
    }

    private void initialize() {
        this.maxPage.bind((ObservableValue)IntegerBindingBuilder.build().setMapper(this::computeMaxPage).addSources(new Observable[]{this.sizeProperty(), this.cellsPerPageProperty()}).get());
    }

    public IntegerRange getVisibleRange() {
        if (this.isEmpty()) {
            return Utils.INVALID_RANGE;
        }
        VFXListHelper helper = this.getHelper();
        int first = helper.firstVisible();
        int last = Math.min(first + this.getCellsPerPage() - 1, this.size() - 1);
        return IntegerRange.of((Integer)first, (Integer)last);
    }

    public Map<Integer, C> getVisibleCellsByIndex() {
        IntegerRange range = this.getVisibleRange();
        if (Utils.INVALID_RANGE.equals((Object)range)) {
            return Map.of();
        }
        return this.getCellsByIndexUnmodifiable().entrySet().stream().filter(e -> IntegerRange.inRangeOf((int)((Integer)e.getKey()), (IntegerRange)range)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<T, C> getVisibleCellsByItem() {
        IntegerRange range = this.getVisibleRange();
        if (Utils.INVALID_RANGE.equals((Object)range)) {
            return Map.of();
        }
        HashMap<Object, Cell> map = new HashMap<Object, Cell>();
        for (Integer i : range) {
            Object t = this.getItems().get(i.intValue());
            map.put(t, (Cell)this.getCellsByItemUnmodifiable().get(t));
        }
        return map;
    }

    @Override
    public List<String> defaultStyleClasses() {
        return List.of("vfx-list", "paginated");
    }

    @Override
    protected Function<Orientation, VFXListHelper<T, C>> defaultHelperFactory() {
        return o -> o == Orientation.VERTICAL ? new VFXPaginatedListHelper.VerticalHelper(this) : new VFXPaginatedListHelper.HorizontalHelper(this);
    }

    @Override
    public Supplier<VFXListManager<T, C>> defaultBehaviorProvider() {
        return () -> new VFXPaginatedListManager(this);
    }

    @Override
    protected SkinBase<?, ?> buildSkin() {
        return new VFXPaginatedListSkin(this);
    }

    @Override
    public void setVPos(double vPos) {
        if (this.vPosProperty().isBound()) {
            return;
        }
        super.setVPos(vPos);
    }

    @Override
    public void setHPos(double hPos) {
        if (this.hPosProperty().isBound()) {
            return;
        }
        super.setHPos(hPos);
    }

    @Override
    public void scrollToFirst() {
        this.setPage(0);
    }

    @Override
    public void scrollToLast() {
        this.setPage(this.getMaxPage());
    }

    public StyleableIntegerProperty cellsPerPageProperty() {
        return this.cellsPerPage;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    @Override
    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return VFXPaginatedList.getClassCssMetaData();
    }

    @Override
    public IntegerProperty pageProperty() {
        return this.page;
    }

    @Override
    public ReadOnlyIntegerProperty maxPageProperty() {
        return this.maxPage.getReadOnlyProperty();
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<VFXPaginatedList<?, ?>> FACTORY = new StyleablePropertyFactory(VFXList.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<VFXPaginatedList<?, ?>, Number> CELLS_PER_PAGE;

        private StyleableProperties() {
        }

        static {
            CELLS_PER_PAGE = FACTORY.createSizeCssMetaData("-vfx-cells-per-page", VFXPaginatedList::cellsPerPageProperty, (Number)10);
            cssMetaDataList = StyleUtils.cssMetaDataList(VFXList.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{CELLS_PER_PAGE});
        }
    }
}

