/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.list.paginated;

import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.list.VFXList;
import io.github.palexdev.virtualizedfx.list.VFXListHelper;
import io.github.palexdev.virtualizedfx.list.paginated.VFXPaginatedList;

public interface VFXPaginatedListHelper<T, C extends Cell<T>>
extends VFXListHelper<T, C> {

    public static class HorizontalHelper<T, C extends Cell<T>>
    extends VFXListHelper.HorizontalHelper<T, C>
    implements VFXPaginatedListHelper<T, C> {
        public HorizontalHelper(VFXPaginatedList<T, C> list) {
            super(list);
        }

        @Override
        public int visibleNum() {
            return this.getList().getCellsPerPage();
        }

        @Override
        public void scrollBy(double pixels) {
            throw new UnsupportedOperationException("This scrolls by page not pixels");
        }

        @Override
        public void scrollToPixel(double pixel) {
            throw new UnsupportedOperationException("This scrolls by page not pixels");
        }

        @Override
        public void scrollToIndex(int index) {
            VFXList list = this.getList();
            list.setPage(list.findPageByIndex(index));
        }

        @Override
        public VFXPaginatedList<T, C> getList() {
            return (VFXPaginatedList)super.getList();
        }
    }

    public static class VerticalHelper<T, C extends Cell<T>>
    extends VFXListHelper.VerticalHelper<T, C>
    implements VFXPaginatedListHelper<T, C> {
        public VerticalHelper(VFXPaginatedList<T, C> list) {
            super(list);
        }

        @Override
        public int visibleNum() {
            return this.getList().getCellsPerPage();
        }

        @Override
        public void scrollBy(double pixels) {
            throw new UnsupportedOperationException("This scrolls by page not pixels");
        }

        @Override
        public void scrollToPixel(double pixel) {
            throw new UnsupportedOperationException("This scrolls by page not pixels");
        }

        @Override
        public void scrollToIndex(int index) {
            VFXList list = this.getList();
            list.setPage(list.findPageByIndex(index));
        }

        @Override
        public VFXPaginatedList<T, C> getList() {
            return (VFXPaginatedList)super.getList();
        }
    }
}

